/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.sync.SyncActivityWorker;
import com.uber.cadence.internal.sync.SyncWorkflowWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.Suspendable;
import com.uber.cadence.worker.WorkerFactoryOptions;
import com.uber.cadence.worker.WorkerOptions;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Worker
implements Suspendable {
    private final WorkerOptions options;
    private final String taskList;
    private final SyncWorkflowWorker workflowWorker;
    private final SyncActivityWorker activityWorker;
    private final AtomicBoolean started = new AtomicBoolean();

    Worker(WorkflowClient client, String taskList, WorkerFactoryOptions factoryOptions, WorkerOptions options, DeciderCache cache, String stickyTaskListName, Duration stickyDecisionScheduleToStartTimeout, ThreadPoolExecutor threadPoolExecutor, List<ContextPropagator> contextPropagators) {
        this.taskList = Objects.requireNonNull(taskList);
        this.options = options = (WorkerOptions)MoreObjects.firstNonNull((Object)options, (Object)WorkerOptions.defaultInstance());
        Scope metricsScope = client.getOptions().getMetricsScope().tagged((Map)ImmutableMap.of((Object)"TaskList", (Object)taskList));
        SingleWorkerOptions activityOptions = SingleWorkerOptions.newBuilder().setIdentity(client.getOptions().getIdentity()).setDataConverter(client.getOptions().getDataConverter()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentActivityExecutionSize()).setTaskListActivitiesPerSecond(options.getTaskListActivitiesPerSecond()).setPollerOptions(options.getActivityPollerOptions()).setMetricsScope(metricsScope).setEnableLoggingInReplay(factoryOptions.isEnableLoggingInReplay()).setContextPropagators(contextPropagators).build();
        this.activityWorker = new SyncActivityWorker(client.getService(), client.getOptions().getDomain(), taskList, activityOptions);
        SingleWorkerOptions workflowOptions = SingleWorkerOptions.newBuilder().setDataConverter(client.getOptions().getDataConverter()).setIdentity(client.getOptions().getIdentity()).setPollerOptions(options.getWorkflowPollerOptions()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentWorkflowExecutionSize()).setMetricsScope(metricsScope).setEnableLoggingInReplay(factoryOptions.isEnableLoggingInReplay()).setContextPropagators(contextPropagators).build();
        SingleWorkerOptions localActivityOptions = SingleWorkerOptions.newBuilder().setDataConverter(client.getOptions().getDataConverter()).setIdentity(client.getOptions().getIdentity()).setPollerOptions(options.getWorkflowPollerOptions()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentLocalActivityExecutionSize()).setMetricsScope(metricsScope).setEnableLoggingInReplay(factoryOptions.isEnableLoggingInReplay()).setContextPropagators(contextPropagators).build();
        this.workflowWorker = new SyncWorkflowWorker(client.getService(), client.getOptions().getDomain(), taskList, this.options.getInterceptorFactory(), workflowOptions, localActivityOptions, activityOptions, cache, stickyTaskListName, stickyDecisionScheduleToStartTimeout, threadPoolExecutor);
    }

    SyncWorkflowWorker getWorkflowWorker() {
        return this.workflowWorker;
    }

    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.setWorkflowImplementationTypes(new WorkflowImplementationOptions.Builder().build(), workflowImplementationClasses);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerWorkflowImplementationTypes is not allowed after worker has started");
        this.workflowWorker.setWorkflowImplementationTypes(options, workflowImplementationClasses);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.addWorkflowImplementationFactory(options, workflowInterface, factory);
    }

    @VisibleForTesting
    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.workflowWorker.addWorkflowImplementationFactory(workflowInterface, factory);
    }

    public void registerActivitiesImplementations(Object ... activityImplementations) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"registerActivitiesImplementations is not allowed after worker has started");
        if (this.activityWorker != null) {
            this.activityWorker.setActivitiesImplementation(activityImplementations);
            this.workflowWorker.setActivitiesImplementationToDispatchLocally(activityImplementations);
        }
        this.workflowWorker.setLocalActivitiesImplementation(activityImplementations);
    }

    void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.workflowWorker.start();
        this.activityWorker.start();
    }

    void shutdown() {
        this.activityWorker.shutdown();
        this.workflowWorker.shutdown();
    }

    void shutdownNow() {
        this.activityWorker.shutdownNow();
        this.workflowWorker.shutdownNow();
    }

    boolean isTerminated() {
        return this.activityWorker.isTerminated() && this.workflowWorker.isTerminated();
    }

    void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = InternalUtils.awaitTermination(this.activityWorker, unit.toMillis(timeout));
        InternalUtils.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    public String toString() {
        return "Worker{options=" + this.options + '}';
    }

    public void replayWorkflowExecution(WorkflowExecutionHistory history) throws Exception {
        this.workflowWorker.queryWorkflowExecution(history, "__replay_only", String.class, (Type)((Object)String.class), new Object[0]);
    }

    public void replayWorkflowExecution(String jsonSerializedHistory) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        this.replayWorkflowExecution(history);
    }

    public String getTaskList() {
        return this.taskList;
    }

    @Override
    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
        this.activityWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.workflowWorker.resumePolling();
        this.activityWorker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.workflowWorker.isSuspended() && this.activityWorker.isSuspended();
    }

    public CompletableFuture<Boolean> isHealthy() {
        return this.workflowWorker.isHealthy();
    }
}

