/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.util.Objects;
import java.util.function.Function;

public final class WorkerOptions {
    private static final WorkerOptions DEFAULT_INSTANCE = WorkerOptions.newBuilder().build();
    private final double workerActivitiesPerSecond;
    private final int maxConcurrentActivityExecutionSize;
    private final int maxConcurrentWorkflowExecutionSize;
    private final int maxConcurrentLocalActivityExecutionSize;
    private final double taskListActivitiesPerSecond;
    private final PollerOptions activityPollerOptions;
    private final PollerOptions workflowPollerOptions;
    private final Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerOptions options) {
        return new Builder(options);
    }

    public static WorkerOptions defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerOptions(double workerActivitiesPerSecond, int maxConcurrentActivityExecutionSize, int maxConcurrentWorkflowExecutionSize, int maxConcurrentLocalActivityExecutionSize, double taskListActivitiesPerSecond, PollerOptions activityPollerOptions, PollerOptions workflowPollerOptions, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory) {
        this.workerActivitiesPerSecond = workerActivitiesPerSecond;
        this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
        this.maxConcurrentWorkflowExecutionSize = maxConcurrentWorkflowExecutionSize;
        this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
        this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
        this.activityPollerOptions = activityPollerOptions;
        this.workflowPollerOptions = workflowPollerOptions;
        this.interceptorFactory = interceptorFactory;
    }

    public double getWorkerActivitiesPerSecond() {
        return this.workerActivitiesPerSecond;
    }

    public int getMaxConcurrentActivityExecutionSize() {
        return this.maxConcurrentActivityExecutionSize;
    }

    public int getMaxConcurrentWorkflowExecutionSize() {
        return this.maxConcurrentWorkflowExecutionSize;
    }

    public int getMaxConcurrentLocalActivityExecutionSize() {
        return this.maxConcurrentLocalActivityExecutionSize;
    }

    public double getTaskListActivitiesPerSecond() {
        return this.taskListActivitiesPerSecond;
    }

    public PollerOptions getActivityPollerOptions() {
        return this.activityPollerOptions;
    }

    public PollerOptions getWorkflowPollerOptions() {
        return this.workflowPollerOptions;
    }

    public Function<WorkflowInterceptor, WorkflowInterceptor> getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public String toString() {
        return "WorkerOptions{workerActivitiesPerSecond=" + this.workerActivitiesPerSecond + ", maxConcurrentActivityExecutionSize=" + this.maxConcurrentActivityExecutionSize + ", maxConcurrentWorkflowExecutionSize=" + this.maxConcurrentWorkflowExecutionSize + ", maxConcurrentLocalActivityExecutionSize=" + this.maxConcurrentLocalActivityExecutionSize + ", taskListActivitiesPerSecond=" + this.taskListActivitiesPerSecond + ", activityPollerOptions=" + this.activityPollerOptions + ", workflowPollerOptions=" + this.workflowPollerOptions + '}';
    }

    public static final class Builder {
        private double workerActivitiesPerSecond;
        private int maxConcurrentActivityExecutionSize = 100;
        private int maxConcurrentWorkflowExecutionSize = 50;
        private int maxConcurrentLocalActivityExecutionSize = 100;
        private double taskListActivitiesPerSecond;
        private PollerOptions activityPollerOptions;
        private PollerOptions workflowPollerOptions;
        private Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory = n -> n;

        private Builder() {
        }

        private Builder(WorkerOptions options) {
            this.workerActivitiesPerSecond = options.workerActivitiesPerSecond;
            this.maxConcurrentActivityExecutionSize = options.maxConcurrentActivityExecutionSize;
            this.maxConcurrentWorkflowExecutionSize = options.maxConcurrentWorkflowExecutionSize;
            this.maxConcurrentLocalActivityExecutionSize = options.maxConcurrentLocalActivityExecutionSize;
            this.taskListActivitiesPerSecond = options.taskListActivitiesPerSecond;
            this.activityPollerOptions = options.activityPollerOptions;
            this.workflowPollerOptions = options.workflowPollerOptions;
            this.interceptorFactory = options.interceptorFactory;
        }

        public Builder setWorkerActivitiesPerSecond(double workerActivitiesPerSecond) {
            if (workerActivitiesPerSecond <= 0.0) {
                throw new IllegalArgumentException("Negative or zero: " + workerActivitiesPerSecond);
            }
            this.workerActivitiesPerSecond = workerActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentActivityExecutionSize(int maxConcurrentActivityExecutionSize) {
            if (maxConcurrentActivityExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentActivityExecutionSize);
            }
            this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentWorkflowExecutionSize(int maxConcurrentWorkflowExecutionSize) {
            if (maxConcurrentWorkflowExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentWorkflowExecutionSize);
            }
            this.maxConcurrentWorkflowExecutionSize = maxConcurrentWorkflowExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentLocalActivityExecutionSize(int maxConcurrentLocalActivityExecutionSize) {
            if (maxConcurrentLocalActivityExecutionSize <= 0) {
                throw new IllegalArgumentException("Negative or zero: " + maxConcurrentLocalActivityExecutionSize);
            }
            this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
            return this;
        }

        public Builder setActivityPollerOptions(PollerOptions activityPollerOptions) {
            this.activityPollerOptions = Objects.requireNonNull(activityPollerOptions);
            return this;
        }

        public Builder setWorkflowPollerOptions(PollerOptions workflowPollerOptions) {
            this.workflowPollerOptions = Objects.requireNonNull(workflowPollerOptions);
            return this;
        }

        public Builder setInterceptorFactory(Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory) {
            this.interceptorFactory = Objects.requireNonNull(interceptorFactory);
            return this;
        }

        public Builder setTaskListActivitiesPerSecond(double taskListActivitiesPerSecond) {
            this.taskListActivitiesPerSecond = taskListActivitiesPerSecond;
            return this;
        }

        public WorkerOptions build() {
            return new WorkerOptions(this.workerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.taskListActivitiesPerSecond, this.activityPollerOptions, this.workflowPollerOptions, this.interceptorFactory);
        }
    }
}

