/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.workflow;

import com.uber.cadence.ParentClosePolicy;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.common.CronSchedule;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.internal.common.OptionsUtils;
import com.uber.cadence.workflow.WorkflowMethod;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ChildWorkflowOptions {
    private final String domain;
    private final String workflowId;
    private final WorkflowIdReusePolicy workflowIdReusePolicy;
    private final Duration executionStartToCloseTimeout;
    private final Duration taskStartToCloseTimeout;
    private final String taskList;
    private final RetryOptions retryOptions;
    private final String cronSchedule;
    private final ParentClosePolicy parentClosePolicy;
    private final Map<String, Object> memo;
    private final Map<String, Object> searchAttributes;
    private List<ContextPropagator> contextPropagators;

    public static ChildWorkflowOptions merge(WorkflowMethod a, MethodRetry r, CronSchedule cronSchedule, ChildWorkflowOptions o) {
        if (o == null) {
            o = new Builder().build();
        }
        String cronAnnotation = cronSchedule == null ? "" : cronSchedule.value();
        return new Builder().setDomain(o.getDomain()).setWorkflowIdReusePolicy(OptionsUtils.merge(a.workflowIdReusePolicy(), o.getWorkflowIdReusePolicy(), WorkflowIdReusePolicy.class)).setWorkflowId(OptionsUtils.merge(a.workflowId(), o.getWorkflowId(), String.class)).setTaskStartToCloseTimeout(OptionsUtils.merge(a.taskStartToCloseTimeoutSeconds(), o.getTaskStartToCloseTimeout())).setExecutionStartToCloseTimeout(OptionsUtils.merge(a.executionStartToCloseTimeoutSeconds(), o.getExecutionStartToCloseTimeout())).setTaskList(OptionsUtils.merge(a.taskList(), o.getTaskList(), String.class)).setRetryOptions(RetryOptions.merge(r, o.getRetryOptions())).setCronSchedule(OptionsUtils.merge(cronAnnotation, o.getCronSchedule(), String.class)).setParentClosePolicy(o.getParentClosePolicy()).setMemo(o.getMemo()).setSearchAttributes(o.getSearchAttributes()).setContextPropagators(o.getContextPropagators()).validateAndBuildWithDefaults();
    }

    private ChildWorkflowOptions(String domain, String workflowId, WorkflowIdReusePolicy workflowIdReusePolicy, Duration executionStartToCloseTimeout, Duration taskStartToCloseTimeout, String taskList, RetryOptions retryOptions, String cronSchedule, ParentClosePolicy parentClosePolicy, Map<String, Object> memo, Map<String, Object> searchAttributes, List<ContextPropagator> contextPropagators) {
        this.domain = domain;
        this.workflowId = workflowId;
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        this.taskList = taskList;
        this.retryOptions = retryOptions;
        this.cronSchedule = cronSchedule;
        this.parentClosePolicy = parentClosePolicy;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.contextPropagators = contextPropagators;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public WorkflowIdReusePolicy getWorkflowIdReusePolicy() {
        return this.workflowIdReusePolicy;
    }

    public Duration getExecutionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public Duration getTaskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public ParentClosePolicy getParentClosePolicy() {
        return this.parentClosePolicy;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildWorkflowOptions that = (ChildWorkflowOptions)o;
        return Objects.equals(this.domain, that.domain) && Objects.equals(this.workflowId, that.workflowId) && this.workflowIdReusePolicy == that.workflowIdReusePolicy && Objects.equals(this.executionStartToCloseTimeout, that.executionStartToCloseTimeout) && Objects.equals(this.taskStartToCloseTimeout, that.taskStartToCloseTimeout) && Objects.equals(this.taskList, that.taskList) && Objects.equals(this.retryOptions, that.retryOptions) && Objects.equals(this.cronSchedule, that.cronSchedule) && Objects.equals((Object)this.parentClosePolicy, (Object)that.parentClosePolicy) && Objects.equals(this.memo, that.memo) && Objects.equals(this.searchAttributes, that.searchAttributes) && Objects.equals(this.contextPropagators, that.contextPropagators);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domain, this.workflowId, this.workflowIdReusePolicy, this.executionStartToCloseTimeout, this.taskStartToCloseTimeout, this.taskList, this.retryOptions, this.cronSchedule, this.parentClosePolicy, this.memo, this.searchAttributes, this.contextPropagators});
    }

    public String toString() {
        return "ChildWorkflowOptions{domain='" + this.domain + '\'' + ", workflowId='" + this.workflowId + '\'' + ", workflowIdReusePolicy=" + (Object)((Object)this.workflowIdReusePolicy) + ", executionStartToCloseTimeout=" + this.executionStartToCloseTimeout + ", taskStartToCloseTimeout=" + this.taskStartToCloseTimeout + ", taskList='" + this.taskList + '\'' + ", retryOptions=" + this.retryOptions + ", cronSchedule=" + this.cronSchedule + ", parentClosePolicy=" + (Object)((Object)this.parentClosePolicy) + ", memo='" + this.memo + '\'' + ", searchAttributes='" + this.searchAttributes + ", contextPropagators='" + this.contextPropagators + '\'' + '}';
    }

    public static final class Builder {
        private String domain;
        private String workflowId;
        private WorkflowIdReusePolicy workflowIdReusePolicy;
        private Duration executionStartToCloseTimeout;
        private Duration taskStartToCloseTimeout;
        private String taskList;
        private RetryOptions retryOptions;
        private String cronSchedule;
        private ParentClosePolicy parentClosePolicy;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;
        private List<ContextPropagator> contextPropagators;

        public Builder() {
        }

        public Builder(ChildWorkflowOptions source) {
            if (source == null) {
                return;
            }
            this.domain = source.getDomain();
            this.workflowId = source.getWorkflowId();
            this.workflowIdReusePolicy = source.getWorkflowIdReusePolicy();
            this.executionStartToCloseTimeout = source.getExecutionStartToCloseTimeout();
            this.taskStartToCloseTimeout = source.getTaskStartToCloseTimeout();
            this.taskList = source.getTaskList();
            this.retryOptions = source.getRetryOptions();
            this.cronSchedule = source.getCronSchedule();
            this.parentClosePolicy = source.getParentClosePolicy();
            this.memo = source.getMemo();
            this.searchAttributes = source.getSearchAttributes();
            this.contextPropagators = source.getContextPropagators();
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder setWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy;
            return this;
        }

        public Builder setExecutionStartToCloseTimeout(Duration executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public Builder setTaskStartToCloseTimeout(Duration taskStartToCloseTimeout) {
            if (OptionsUtils.roundUpToSeconds(taskStartToCloseTimeout).getSeconds() > 60L) {
                throw new IllegalArgumentException("TaskStartToCloseTimeout over one minute: " + taskStartToCloseTimeout);
            }
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public Builder setTaskList(String taskList) {
            this.taskList = taskList;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setCronSchedule(String cronSchedule) {
            this.cronSchedule = cronSchedule;
            return this;
        }

        public Builder setParentClosePolicy(ParentClosePolicy parentClosePolicy) {
            this.parentClosePolicy = parentClosePolicy;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public ChildWorkflowOptions build() {
            return new ChildWorkflowOptions(this.domain, this.workflowId, this.workflowIdReusePolicy, this.executionStartToCloseTimeout, this.taskStartToCloseTimeout, this.taskList, this.retryOptions, this.cronSchedule, this.parentClosePolicy, this.memo, this.searchAttributes, this.contextPropagators);
        }

        public ChildWorkflowOptions validateAndBuildWithDefaults() {
            return new ChildWorkflowOptions(this.domain, this.workflowId, this.workflowIdReusePolicy, OptionsUtils.roundUpToSeconds(this.executionStartToCloseTimeout), OptionsUtils.roundUpToSeconds(this.taskStartToCloseTimeout), this.taskList, this.retryOptions, this.cronSchedule, this.parentClosePolicy, this.memo, this.searchAttributes, this.contextPropagators);
        }
    }
}

