/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.workflow;

import com.uber.cadence.internal.common.OptionsUtils;
import java.time.Duration;

public final class ContinueAsNewOptions {
    private final Duration executionStartToCloseTimeout;
    private final String taskList;
    private final Duration taskStartToCloseTimeout;

    public ContinueAsNewOptions(Duration executionStartToCloseTimeout, String taskList, Duration taskStartToCloseTimeout) {
        this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        this.taskList = taskList;
        this.taskStartToCloseTimeout = taskStartToCloseTimeout;
    }

    public Duration getExecutionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public Duration getTaskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public static final class Builder {
        private Duration executionStartToCloseTimeout;
        private String taskList;
        private Duration taskStartToCloseTimeout;

        public Builder setExecutionStartToCloseTimeout(Duration executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public Builder setTaskList(String taskList) {
            this.taskList = taskList;
            return this;
        }

        public Builder setTaskStartToCloseTimeout(Duration taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public ContinueAsNewOptions build() {
            return new ContinueAsNewOptions(OptionsUtils.roundUpToSeconds(this.executionStartToCloseTimeout), this.taskList, OptionsUtils.roundUpToSeconds(this.taskStartToCloseTimeout));
        }
    }
}

