/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.converter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.uber.cadence.converter.DataConverterException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.thrift.TEnum;

public class TEnumTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, final TypeToken<T> typeToken) {
        if (!TEnum.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        TypeAdapter result = new TypeAdapter<T>(){

            public void write(JsonWriter jsonWriter, T value) throws IOException {
                jsonWriter.value((long)((TEnum)value).getValue());
            }

            public T read(JsonReader jsonReader) throws IOException {
                int value = jsonReader.nextInt();
                try {
                    Method m = typeToken.getRawType().getDeclaredMethod("findByValue", Integer.TYPE);
                    Object instance = m.invoke(null, value);
                    return instance;
                }
                catch (Exception e) {
                    throw new DataConverterException("Failed to deserilize TEnum", e);
                }
            }
        }.nullSafe();
        return result;
    }
}

