/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public final class CheckedExceptionWrapper
extends RuntimeException {
    private static final Field causeField;

    public static RuntimeException wrap(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof InvocationTargetException) {
            return CheckedExceptionWrapper.wrap(e.getCause());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new CheckedExceptionWrapper((Exception)e);
    }

    public static Exception unwrap(Throwable e) {
        Throwable head = e;
        if (head instanceof CheckedExceptionWrapper) {
            head = head.getCause();
        }
        Throwable tail = head;
        Throwable current = tail.getCause();
        while (current != null) {
            if (current instanceof CheckedExceptionWrapper) {
                current = current.getCause();
                CheckedExceptionWrapper.setThrowableCause(tail, current);
            }
            tail = current;
            current = tail.getCause();
        }
        if (head instanceof Error) {
            throw (Error)head;
        }
        return (Exception)head;
    }

    private static void setThrowableCause(Throwable throwable, Throwable cause) {
        try {
            causeField.set(throwable, cause);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unexpected", e);
        }
    }

    private CheckedExceptionWrapper(Exception e) {
        super(e);
    }

    static {
        try {
            causeField = Throwable.class.getDeclaredField("cause");
            causeField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("unexpected", e);
        }
    }
}

