/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.proto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class Helpers {
    Helpers() {
    }

    static DoubleValue fromDoubleValue(double v) {
        return DoubleValue.newBuilder().setValue(v).build();
    }

    static Timestamp unixNanoToTime(long t) {
        return Timestamps.fromNanos((long)t);
    }

    static Duration secondsToDuration(int d) {
        return Duration.newBuilder().setSeconds((long)d).build();
    }

    static int longToInt(long v) {
        return (int)v;
    }

    static FieldMask newFieldMask(List<String> fields) {
        return FieldMask.newBuilder().addAllPaths(fields).build();
    }

    static Duration daysToDuration(int days) {
        return Durations.fromDays((long)days);
    }

    static Map nullToEmpty(Map t) {
        return (Map)MoreObjects.firstNonNull((Object)t, Collections.emptyMap());
    }

    static String nullToEmpty(String t) {
        return Strings.nullToEmpty((String)t);
    }

    static boolean nullToEmpty(boolean t) {
        return (Boolean)MoreObjects.firstNonNull((Object)t, (Object)false);
    }

    static ByteString arrayToByteString(byte[] t) {
        if (t == null) {
            return null;
        }
        return ByteString.copyFrom((byte[])t);
    }
}

