/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.proto;

import com.uber.cadence.CountWorkflowExecutionsRequest;
import com.uber.cadence.DeprecateDomainRequest;
import com.uber.cadence.DescribeDomainRequest;
import com.uber.cadence.DescribeTaskListRequest;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DomainConfiguration;
import com.uber.cadence.DomainReplicationConfiguration;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.ListArchivedWorkflowExecutionsRequest;
import com.uber.cadence.ListClosedWorkflowExecutionsRequest;
import com.uber.cadence.ListDomainsRequest;
import com.uber.cadence.ListOpenWorkflowExecutionsRequest;
import com.uber.cadence.ListTaskListPartitionsRequest;
import com.uber.cadence.ListWorkflowExecutionsRequest;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatByIDRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.RegisterDomainRequest;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.ResetStickyTaskListRequest;
import com.uber.cadence.ResetWorkflowExecutionRequest;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.SignalWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.TerminateWorkflowExecutionRequest;
import com.uber.cadence.UpdateDomainInfo;
import com.uber.cadence.UpdateDomainRequest;
import com.uber.cadence.api.v1.CountWorkflowExecutionsRequest;
import com.uber.cadence.api.v1.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.api.v1.ListArchivedWorkflowExecutionsRequest;
import com.uber.cadence.api.v1.ListClosedWorkflowExecutionsRequest;
import com.uber.cadence.api.v1.ListDomainsRequest;
import com.uber.cadence.api.v1.ListOpenWorkflowExecutionsRequest;
import com.uber.cadence.api.v1.ListWorkflowExecutionsRequest;
import com.uber.cadence.api.v1.PollForActivityTaskRequest;
import com.uber.cadence.api.v1.PollForDecisionTaskRequest;
import com.uber.cadence.api.v1.RecordActivityTaskHeartbeatByIDRequest;
import com.uber.cadence.api.v1.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.api.v1.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.api.v1.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.api.v1.RespondActivityTaskCanceledRequest;
import com.uber.cadence.api.v1.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.api.v1.RespondActivityTaskCompletedRequest;
import com.uber.cadence.api.v1.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.api.v1.RespondActivityTaskFailedRequest;
import com.uber.cadence.api.v1.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.api.v1.RespondDecisionTaskFailedRequest;
import com.uber.cadence.api.v1.RespondQueryTaskCompletedRequest;
import com.uber.cadence.api.v1.ScanWorkflowExecutionsRequest;
import com.uber.cadence.api.v1.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.api.v1.SignalWorkflowExecutionRequest;
import com.uber.cadence.api.v1.StartWorkflowExecutionRequest;
import com.uber.cadence.api.v1.TerminateWorkflowExecutionRequest;
import com.uber.cadence.api.v1.UpdateDomainRequest;
import com.uber.cadence.api.v1.WorkflowQueryResult;
import com.uber.cadence.internal.compatibility.proto.DecisionMapper;
import com.uber.cadence.internal.compatibility.proto.EnumMapper;
import com.uber.cadence.internal.compatibility.proto.Helpers;
import com.uber.cadence.internal.compatibility.proto.TypeMapper;
import java.util.ArrayList;

public class RequestMapper {
    private static final String DomainUpdateDescriptionField = "description";
    private static final String DomainUpdateOwnerEmailField = "owner_email";
    private static final String DomainUpdateDataField = "data";
    private static final String DomainUpdateRetentionPeriodField = "workflow_execution_retention_period";
    private static final String DomainUpdateBadBinariesField = "bad_binaries";
    private static final String DomainUpdateHistoryArchivalStatusField = "history_archival_status";
    private static final String DomainUpdateHistoryArchivalURIField = "history_archival_uri";
    private static final String DomainUpdateVisibilityArchivalStatusField = "visibility_archival_status";
    private static final String DomainUpdateVisibilityArchivalURIField = "visibility_archival_uri";
    private static final String DomainUpdateActiveClusterNameField = "active_cluster_name";
    private static final String DomainUpdateClustersField = "clusters";
    private static final String DomainUpdateDeleteBadBinaryField = "delete_bad_binary";
    private static final String DomainUpdateFailoverTimeoutField = "failover_timeout";

    public static com.uber.cadence.api.v1.CountWorkflowExecutionsRequest countWorkflowExecutionsRequest(CountWorkflowExecutionsRequest t) {
        if (t == null) {
            return null;
        }
        CountWorkflowExecutionsRequest.Builder request = com.uber.cadence.api.v1.CountWorkflowExecutionsRequest.newBuilder().setDomain(t.getDomain());
        if (t.getQuery() != null) {
            request.setQuery(t.getQuery());
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.DescribeTaskListRequest describeTaskListRequest(DescribeTaskListRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.DescribeTaskListRequest.newBuilder().setDomain(t.getDomain()).setTaskList(TypeMapper.taskList(t.getTaskList())).setTaskListType(EnumMapper.taskListType(t.getTaskListType())).setIncludeTaskListStatus(t.isIncludeTaskListStatus()).build();
    }

    public static com.uber.cadence.api.v1.ListArchivedWorkflowExecutionsRequest listArchivedWorkflowExecutionsRequest(ListArchivedWorkflowExecutionsRequest t) {
        if (t == null) {
            return null;
        }
        ListArchivedWorkflowExecutionsRequest.Builder request = com.uber.cadence.api.v1.ListArchivedWorkflowExecutionsRequest.newBuilder().setDomain(t.getDomain()).setPageSize(t.getPageSize());
        if (t.getNextPageToken() != null) {
            request.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        if (t.getQuery() != null) {
            request.setQuery(t.getQuery());
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest(RequestCancelWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        RequestCancelWorkflowExecutionRequest.Builder builder = com.uber.cadence.api.v1.RequestCancelWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution())).setRequestId(t.getRequestId());
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.ResetStickyTaskListRequest resetStickyTaskListRequest(ResetStickyTaskListRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.ResetStickyTaskListRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getExecution())).build();
    }

    public static com.uber.cadence.api.v1.ResetWorkflowExecutionRequest resetWorkflowExecutionRequest(ResetWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.ResetWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution())).setReason(t.getReason()).setDecisionFinishEventId(t.getDecisionFinishEventId()).setRequestId(t.getRequestId()).setSkipSignalReapply(t.isSkipSignalReapply()).build();
    }

    public static com.uber.cadence.api.v1.RespondActivityTaskCanceledByIDRequest respondActivityTaskCanceledByIdRequest(RespondActivityTaskCanceledByIDRequest t) {
        if (t == null) {
            return null;
        }
        RespondActivityTaskCanceledByIDRequest.Builder builder = com.uber.cadence.api.v1.RespondActivityTaskCanceledByIDRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowRunPair(t.getWorkflowID(), t.getRunID())).setActivityId(t.getActivityID()).setDetails(TypeMapper.payload(t.getDetails()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest(RespondActivityTaskCanceledRequest t) {
        if (t == null) {
            return null;
        }
        RespondActivityTaskCanceledRequest.Builder builder = com.uber.cadence.api.v1.RespondActivityTaskCanceledRequest.newBuilder().setDetails(TypeMapper.payload(t.getDetails()));
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondActivityTaskCompletedByIDRequest respondActivityTaskCompletedByIdRequest(RespondActivityTaskCompletedByIDRequest t) {
        if (t == null) {
            return null;
        }
        RespondActivityTaskCompletedByIDRequest.Builder builder = com.uber.cadence.api.v1.RespondActivityTaskCompletedByIDRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowRunPair(t.getWorkflowID(), t.getRunID())).setActivityId(t.getActivityID()).setResult(TypeMapper.payload(t.getResult()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest(RespondActivityTaskCompletedRequest t) {
        if (t == null) {
            return null;
        }
        RespondActivityTaskCompletedRequest.Builder builder = com.uber.cadence.api.v1.RespondActivityTaskCompletedRequest.newBuilder().setResult(TypeMapper.payload(t.getResult()));
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondActivityTaskFailedByIDRequest respondActivityTaskFailedByIdRequest(RespondActivityTaskFailedByIDRequest t) {
        if (t == null) {
            return null;
        }
        RespondActivityTaskFailedByIDRequest.Builder builder = com.uber.cadence.api.v1.RespondActivityTaskFailedByIDRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowRunPair(t.getWorkflowID(), t.getRunID())).setActivityId(t.getActivityID()).setFailure(TypeMapper.failure(t.getReason(), t.getDetails()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondActivityTaskFailedRequest respondActivityTaskFailedRequest(RespondActivityTaskFailedRequest t) {
        if (t == null) {
            return null;
        }
        RespondActivityTaskFailedRequest.Builder builder = com.uber.cadence.api.v1.RespondActivityTaskFailedRequest.newBuilder().setFailure(TypeMapper.failure(t.getReason(), t.getDetails()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest(RespondDecisionTaskCompletedRequest t) {
        if (t == null) {
            return null;
        }
        RespondDecisionTaskCompletedRequest.Builder builder = com.uber.cadence.api.v1.RespondDecisionTaskCompletedRequest.newBuilder().addAllDecisions(DecisionMapper.decisionArray(t.getDecisions())).setStickyAttributes(TypeMapper.stickyExecutionAttributes(t.getStickyAttributes())).setReturnNewDecisionTask(t.isReturnNewDecisionTask()).setForceCreateNewDecisionTask(t.isForceCreateNewDecisionTask()).putAllQueryResults(TypeMapper.workflowQueryResultMap(t.getQueryResults()));
        if (t.getExecutionContext() != null) {
            builder.setExecutionContext(Helpers.arrayToByteString(t.getExecutionContext()));
        }
        if (t.getBinaryChecksum() != null) {
            builder.setBinaryChecksum(t.getBinaryChecksum());
        }
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondDecisionTaskFailedRequest respondDecisionTaskFailedRequest(RespondDecisionTaskFailedRequest t) {
        if (t == null) {
            return null;
        }
        RespondDecisionTaskFailedRequest.Builder builder = com.uber.cadence.api.v1.RespondDecisionTaskFailedRequest.newBuilder().setCause(EnumMapper.decisionTaskFailedCause(t.getCause())).setDetails(TypeMapper.payload(t.getDetails()));
        if (t.getBinaryChecksum() != null) {
            builder.setBinaryChecksum(t.getBinaryChecksum());
        }
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RespondQueryTaskCompletedRequest respondQueryTaskCompletedRequest(RespondQueryTaskCompletedRequest t) {
        if (t == null) {
            return null;
        }
        WorkflowQueryResult.Builder wqBuilder = WorkflowQueryResult.newBuilder().setResultType(EnumMapper.queryTaskCompletedType(t.getCompletedType())).setAnswer(TypeMapper.payload(t.getQueryResult()));
        if (t.getErrorMessage() != null) {
            wqBuilder.setErrorMessage(t.getErrorMessage());
        }
        RespondQueryTaskCompletedRequest.Builder builder = com.uber.cadence.api.v1.RespondQueryTaskCompletedRequest.newBuilder().setResult(wqBuilder.build()).setWorkerVersionInfo(TypeMapper.workerVersionInfo(t.getWorkerVersionInfo()));
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        return builder.build();
    }

    public static ScanWorkflowExecutionsRequest scanWorkflowExecutionsRequest(ListWorkflowExecutionsRequest t) {
        if (t == null) {
            return null;
        }
        ScanWorkflowExecutionsRequest.Builder request = ScanWorkflowExecutionsRequest.newBuilder().setDomain(t.getDomain()).setPageSize(t.getPageSize());
        if (t.getNextPageToken() != null) {
            request.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        if (t.getQuery() != null) {
            request.setQuery(t.getQuery());
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest(DescribeWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.DescribeWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getExecution())).build();
    }

    public static com.uber.cadence.api.v1.GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest(GetWorkflowExecutionHistoryRequest t) {
        if (t == null) {
            return null;
        }
        GetWorkflowExecutionHistoryRequest.Builder builder = com.uber.cadence.api.v1.GetWorkflowExecutionHistoryRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getExecution())).setPageSize(t.getMaximumPageSize()).setWaitForNewEvent(t.isWaitForNewEvent()).setHistoryEventFilterType(EnumMapper.eventFilterType(t.HistoryEventFilterType)).setSkipArchival(t.isSkipArchival());
        if (t.getNextPageToken() != null) {
            builder.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.SignalWithStartWorkflowExecutionRequest signalWithStartWorkflowExecutionRequest(SignalWithStartWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        StartWorkflowExecutionRequest.Builder builder = com.uber.cadence.api.v1.StartWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowId(t.getWorkflowId()).setWorkflowType(TypeMapper.workflowType(t.getWorkflowType())).setTaskList(TypeMapper.taskList(t.getTaskList())).setInput(TypeMapper.payload(t.getInput())).setExecutionStartToCloseTimeout(Helpers.secondsToDuration(t.getExecutionStartToCloseTimeoutSeconds())).setTaskStartToCloseTimeout(Helpers.secondsToDuration(t.getTaskStartToCloseTimeoutSeconds())).setRequestId(t.getRequestId()).setMemo(TypeMapper.memo(t.getMemo())).setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes())).setHeader(TypeMapper.header(t.getHeader()));
        if (t.getRetryPolicy() != null) {
            builder.setRetryPolicy(TypeMapper.retryPolicy(t.getRetryPolicy()));
        }
        builder.setWorkflowIdReusePolicy(EnumMapper.workflowIdReusePolicy(t.getWorkflowIdReusePolicy()));
        if (t.getWorkflowIdReusePolicy() != null) {
            builder.setWorkflowIdReusePolicy(EnumMapper.workflowIdReusePolicy(t.getWorkflowIdReusePolicy()));
        }
        if (t.getCronSchedule() != null) {
            builder.setCronSchedule(t.getCronSchedule());
        }
        if (t.getDelayStartSeconds() > 0) {
            builder.setDelayStart(Helpers.secondsToDuration(t.getDelayStartSeconds()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        SignalWithStartWorkflowExecutionRequest.Builder sb = com.uber.cadence.api.v1.SignalWithStartWorkflowExecutionRequest.newBuilder().setStartRequest(builder.build()).setSignalName(t.getSignalName()).setSignalInput(TypeMapper.payload(t.getSignalInput()));
        if (t.getControl() != null) {
            sb.setControl(Helpers.arrayToByteString(t.getControl()));
        }
        return sb.build();
    }

    public static com.uber.cadence.api.v1.SignalWorkflowExecutionRequest signalWorkflowExecutionRequest(SignalWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        SignalWorkflowExecutionRequest.Builder builder = com.uber.cadence.api.v1.SignalWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution())).setSignalName(t.getSignalName()).setSignalInput(TypeMapper.payload(t.getInput())).setRequestId(t.getRequestId());
        if (t.getControl() != null) {
            builder.setControl(Helpers.arrayToByteString(t.getControl()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.StartWorkflowExecutionRequest startWorkflowExecutionRequest(StartWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        StartWorkflowExecutionRequest.Builder request = com.uber.cadence.api.v1.StartWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowId(t.getWorkflowId()).setWorkflowType(TypeMapper.workflowType(t.getWorkflowType())).setTaskList(TypeMapper.taskList(t.getTaskList())).setInput(TypeMapper.payload(t.getInput())).setRequestId(t.getRequestId()).setExecutionStartToCloseTimeout(Helpers.secondsToDuration(t.getExecutionStartToCloseTimeoutSeconds())).setTaskStartToCloseTimeout(Helpers.secondsToDuration(t.getTaskStartToCloseTimeoutSeconds())).setWorkflowIdReusePolicy(EnumMapper.workflowIdReusePolicy(t.getWorkflowIdReusePolicy())).setMemo(TypeMapper.memo(t.getMemo())).setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes())).setHeader(TypeMapper.header(t.getHeader())).setDelayStart(Helpers.secondsToDuration(t.getDelayStartSeconds()));
        if (t.getRetryPolicy() != null) {
            request.setRetryPolicy(TypeMapper.retryPolicy(t.getRetryPolicy()));
        }
        if (t.getCronSchedule() != null) {
            request.setCronSchedule(t.getCronSchedule());
        }
        if (t.getIdentity() != null) {
            request.setIdentity(t.getIdentity());
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest(TerminateWorkflowExecutionRequest t) {
        if (t == null) {
            return null;
        }
        TerminateWorkflowExecutionRequest.Builder builder = com.uber.cadence.api.v1.TerminateWorkflowExecutionRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution())).setReason(t.getReason()).setDetails(TypeMapper.payload(t.getDetails()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.DeprecateDomainRequest deprecateDomainRequest(DeprecateDomainRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.DeprecateDomainRequest.newBuilder().setName(t.getName()).setSecurityToken(t.getSecurityToken()).build();
    }

    public static com.uber.cadence.api.v1.DescribeDomainRequest describeDomainRequest(DescribeDomainRequest t) {
        if (t == null) {
            return null;
        }
        if (t.uuid != null) {
            return com.uber.cadence.api.v1.DescribeDomainRequest.newBuilder().setId(t.uuid).build();
        }
        if (t.name != null) {
            return com.uber.cadence.api.v1.DescribeDomainRequest.newBuilder().setName(t.name).build();
        }
        throw new IllegalArgumentException("neither one of field is set for DescribeDomainRequest");
    }

    public static com.uber.cadence.api.v1.ListDomainsRequest listDomainsRequest(ListDomainsRequest t) {
        if (t == null) {
            return null;
        }
        ListDomainsRequest.Builder request = com.uber.cadence.api.v1.ListDomainsRequest.newBuilder().setPageSize(t.pageSize);
        if (t.getNextPageToken() != null) {
            request.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.ListTaskListPartitionsRequest listTaskListPartitionsRequest(ListTaskListPartitionsRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.ListTaskListPartitionsRequest.newBuilder().setDomain(t.getDomain()).setTaskList(TypeMapper.taskList(t.getTaskList())).build();
    }

    public static com.uber.cadence.api.v1.ListWorkflowExecutionsRequest listWorkflowExecutionsRequest(ListWorkflowExecutionsRequest t) {
        if (t == null) {
            return null;
        }
        ListWorkflowExecutionsRequest.Builder request = com.uber.cadence.api.v1.ListWorkflowExecutionsRequest.newBuilder().setDomain(t.getDomain()).setPageSize(t.getPageSize());
        if (t.getNextPageToken() != null) {
            request.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        if (t.getQuery() != null) {
            request.setQuery(t.getQuery());
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.PollForActivityTaskRequest pollForActivityTaskRequest(PollForActivityTaskRequest t) {
        if (t == null) {
            return null;
        }
        PollForActivityTaskRequest.Builder builder = com.uber.cadence.api.v1.PollForActivityTaskRequest.newBuilder().setDomain(t.getDomain()).setTaskList(TypeMapper.taskList(t.getTaskList())).setTaskListMetadata(TypeMapper.taskListMetadata(t.getTaskListMetadata()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.PollForDecisionTaskRequest pollForDecisionTaskRequest(PollForDecisionTaskRequest t) {
        if (t == null) {
            return null;
        }
        PollForDecisionTaskRequest.Builder builder = com.uber.cadence.api.v1.PollForDecisionTaskRequest.newBuilder().setDomain(t.getDomain()).setTaskList(TypeMapper.taskList(t.getTaskList()));
        if (t.getBinaryChecksum() != null) {
            builder.setBinaryChecksum(t.getBinaryChecksum());
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.QueryWorkflowRequest queryWorkflowRequest(QueryWorkflowRequest t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.QueryWorkflowRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(t.getExecution())).setQuery(TypeMapper.workflowQuery(t.getQuery())).setQueryRejectCondition(EnumMapper.queryRejectCondition(t.getQueryRejectCondition())).setQueryConsistencyLevel(EnumMapper.queryConsistencyLevel(t.getQueryConsistencyLevel())).build();
    }

    public static com.uber.cadence.api.v1.RecordActivityTaskHeartbeatByIDRequest recordActivityTaskHeartbeatByIdRequest(RecordActivityTaskHeartbeatByIDRequest t) {
        if (t == null) {
            return null;
        }
        RecordActivityTaskHeartbeatByIDRequest.Builder builder = com.uber.cadence.api.v1.RecordActivityTaskHeartbeatByIDRequest.newBuilder().setDomain(t.getDomain()).setWorkflowExecution(TypeMapper.workflowRunPair(t.getWorkflowID(), t.getRunID())).setActivityId(t.getActivityID()).setDetails(TypeMapper.payload(t.getDetails()));
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest(RecordActivityTaskHeartbeatRequest t) {
        if (t == null) {
            return null;
        }
        RecordActivityTaskHeartbeatRequest.Builder builder = com.uber.cadence.api.v1.RecordActivityTaskHeartbeatRequest.newBuilder().setDetails(TypeMapper.payload(t.getDetails()));
        if (t.getTaskToken() != null) {
            builder.setTaskToken(Helpers.arrayToByteString(t.getTaskToken()));
        }
        if (t.getIdentity() != null) {
            builder.setIdentity(t.getIdentity());
        }
        return builder.build();
    }

    public static com.uber.cadence.api.v1.RegisterDomainRequest registerDomainRequest(RegisterDomainRequest t) {
        if (t == null) {
            return null;
        }
        com.uber.cadence.api.v1.RegisterDomainRequest request = com.uber.cadence.api.v1.RegisterDomainRequest.newBuilder().setName(t.getName()).setDescription(Helpers.nullToEmpty(t.getDescription())).setOwnerEmail(Helpers.nullToEmpty(t.getOwnerEmail())).setWorkflowExecutionRetentionPeriod(Helpers.daysToDuration(t.getWorkflowExecutionRetentionPeriodInDays())).addAllClusters(TypeMapper.clusterReplicationConfigurationArray(t.getClusters())).setActiveClusterName(Helpers.nullToEmpty(t.getActiveClusterName())).putAllData(Helpers.nullToEmpty(t.getData())).setSecurityToken(Helpers.nullToEmpty(t.getSecurityToken())).setIsGlobalDomain(Helpers.nullToEmpty(t.isIsGlobalDomain())).setHistoryArchivalStatus(EnumMapper.archivalStatus(t.getHistoryArchivalStatus())).setHistoryArchivalUri(Helpers.nullToEmpty(t.getHistoryArchivalURI())).setVisibilityArchivalStatus(EnumMapper.archivalStatus(t.getVisibilityArchivalStatus())).setVisibilityArchivalUri(Helpers.nullToEmpty(t.getVisibilityArchivalURI())).build();
        return request;
    }

    public static com.uber.cadence.api.v1.UpdateDomainRequest updateDomainRequest(UpdateDomainRequest t) {
        DomainReplicationConfiguration replicationConfiguration;
        DomainConfiguration configuration;
        if (t == null) {
            return null;
        }
        UpdateDomainRequest.Builder request = com.uber.cadence.api.v1.UpdateDomainRequest.newBuilder().setName(t.getName()).setSecurityToken(t.getSecurityToken());
        ArrayList<String> fields = new ArrayList<String>();
        UpdateDomainInfo updatedInfo = t.getUpdatedInfo();
        if (updatedInfo != null) {
            if (updatedInfo.getDescription() != null) {
                request.setDescription(updatedInfo.getDescription());
                fields.add(DomainUpdateDescriptionField);
            }
            if (updatedInfo.getOwnerEmail() != null) {
                request.setOwnerEmail(updatedInfo.getOwnerEmail());
                fields.add(DomainUpdateOwnerEmailField);
            }
            if (updatedInfo.getData() != null) {
                updatedInfo.setData(updatedInfo.getData());
                fields.add(DomainUpdateDataField);
            }
        }
        if ((configuration = t.getConfiguration()) != null) {
            if (configuration.getWorkflowExecutionRetentionPeriodInDays() > 0) {
                request.setWorkflowExecutionRetentionPeriod(Helpers.daysToDuration(configuration.getWorkflowExecutionRetentionPeriodInDays()));
                fields.add(DomainUpdateRetentionPeriodField);
            }
            if (configuration.getBadBinaries() != null) {
                request.setBadBinaries(TypeMapper.badBinaries(configuration.getBadBinaries()));
                fields.add(DomainUpdateBadBinariesField);
            }
            if (configuration.getHistoryArchivalStatus() != null) {
                request.setHistoryArchivalStatus(EnumMapper.archivalStatus(configuration.getHistoryArchivalStatus()));
                fields.add(DomainUpdateHistoryArchivalStatusField);
            }
            if (configuration.getHistoryArchivalURI() != null) {
                request.setHistoryArchivalUri(configuration.getHistoryArchivalURI());
                fields.add(DomainUpdateHistoryArchivalURIField);
            }
            if (configuration.getVisibilityArchivalStatus() != null) {
                request.setVisibilityArchivalStatus(EnumMapper.archivalStatus(configuration.getVisibilityArchivalStatus()));
                fields.add(DomainUpdateVisibilityArchivalStatusField);
            }
            if (configuration.getVisibilityArchivalURI() != null) {
                request.setVisibilityArchivalUri(configuration.getVisibilityArchivalURI());
                fields.add(DomainUpdateVisibilityArchivalURIField);
            }
        }
        if ((replicationConfiguration = new DomainReplicationConfiguration()) != null) {
            if (replicationConfiguration.getActiveClusterName() != null) {
                request.setActiveClusterName(replicationConfiguration.getActiveClusterName());
                fields.add(DomainUpdateActiveClusterNameField);
            }
            if (replicationConfiguration.getClusters() != null) {
                request.addAllClusters(TypeMapper.clusterReplicationConfigurationArray(replicationConfiguration.getClusters()));
                fields.add(DomainUpdateClustersField);
            }
        }
        if (t.getDeleteBadBinary() != null) {
            request.setDeleteBadBinary(t.getDeleteBadBinary());
            fields.add(DomainUpdateDeleteBadBinaryField);
        }
        if (t.getFailoverTimeoutInSeconds() > 0) {
            request.setFailoverTimeout(Helpers.secondsToDuration(t.getFailoverTimeoutInSeconds()));
            fields.add(DomainUpdateFailoverTimeoutField);
        }
        request.setUpdateMask(Helpers.newFieldMask(fields));
        return request.build();
    }

    public static com.uber.cadence.api.v1.ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest(ListClosedWorkflowExecutionsRequest t) {
        if (t == null) {
            return null;
        }
        ListClosedWorkflowExecutionsRequest.Builder request = com.uber.cadence.api.v1.ListClosedWorkflowExecutionsRequest.newBuilder().setDomain(t.getDomain()).setPageSize(t.getMaximumPageSize());
        if (t.getExecutionFilter() != null) {
            request.setExecutionFilter(TypeMapper.workflowExecutionFilter(t.getExecutionFilter()));
        }
        if (t.getTypeFilter() != null) {
            request.setTypeFilter(TypeMapper.workflowTypeFilter(t.getTypeFilter()));
        }
        if (t.getStatusFilter() != null) {
            request.setStatusFilter(TypeMapper.statusFilter(t.getStatusFilter()));
        }
        if (t.getNextPageToken() != null) {
            request.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        if (t.getStartTimeFilter() != null) {
            request.setStartTimeFilter(TypeMapper.startTimeFilter(t.getStartTimeFilter()));
        }
        return request.build();
    }

    public static com.uber.cadence.api.v1.ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest(ListOpenWorkflowExecutionsRequest t) {
        if (t == null) {
            return null;
        }
        ListOpenWorkflowExecutionsRequest.Builder request = com.uber.cadence.api.v1.ListOpenWorkflowExecutionsRequest.newBuilder().setDomain(t.getDomain()).setPageSize(t.getMaximumPageSize());
        if (t.getExecutionFilter() != null) {
            request.setExecutionFilter(TypeMapper.workflowExecutionFilter(t.getExecutionFilter()));
        }
        if (t.getTypeFilter() != null) {
            request.setTypeFilter(TypeMapper.workflowTypeFilter(t.getTypeFilter()));
        }
        if (t.getNextPageToken() != null) {
            request.setNextPageToken(Helpers.arrayToByteString(t.getNextPageToken()));
        }
        if (t.getStartTimeFilter() != null) {
            request.setStartTimeFilter(TypeMapper.startTimeFilter(t.getStartTimeFilter()));
        }
        return request.build();
    }
}

