/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.thrift;

import com.uber.cadence.ActivityTaskCancelRequestedEventAttributes;
import com.uber.cadence.ActivityTaskCanceledEventAttributes;
import com.uber.cadence.ActivityTaskCompletedEventAttributes;
import com.uber.cadence.ActivityTaskFailedEventAttributes;
import com.uber.cadence.ActivityTaskScheduledEventAttributes;
import com.uber.cadence.ActivityTaskStartedEventAttributes;
import com.uber.cadence.ActivityTaskTimedOutEventAttributes;
import com.uber.cadence.CancelTimerFailedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionStartedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTerminatedEventAttributes;
import com.uber.cadence.ChildWorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.DecisionTaskCompletedEventAttributes;
import com.uber.cadence.DecisionTaskFailedEventAttributes;
import com.uber.cadence.DecisionTaskScheduledEventAttributes;
import com.uber.cadence.DecisionTaskStartedEventAttributes;
import com.uber.cadence.DecisionTaskTimedOutEventAttributes;
import com.uber.cadence.EventType;
import com.uber.cadence.ExternalWorkflowExecutionCancelRequestedEventAttributes;
import com.uber.cadence.ExternalWorkflowExecutionSignaledEventAttributes;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.RequestCancelActivityTaskFailedEventAttributes;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionInitiatedEventAttributes;
import com.uber.cadence.StartChildWorkflowExecutionFailedEventAttributes;
import com.uber.cadence.StartChildWorkflowExecutionInitiatedEventAttributes;
import com.uber.cadence.TimerCanceledEventAttributes;
import com.uber.cadence.TimerFiredEventAttributes;
import com.uber.cadence.TimerStartedEventAttributes;
import com.uber.cadence.UpsertWorkflowSearchAttributesEventAttributes;
import com.uber.cadence.WorkflowExecutionCancelRequestedEventAttributes;
import com.uber.cadence.WorkflowExecutionCanceledEventAttributes;
import com.uber.cadence.WorkflowExecutionCompletedEventAttributes;
import com.uber.cadence.WorkflowExecutionContinuedAsNewEventAttributes;
import com.uber.cadence.WorkflowExecutionFailedEventAttributes;
import com.uber.cadence.WorkflowExecutionSignaledEventAttributes;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowExecutionTerminatedEventAttributes;
import com.uber.cadence.WorkflowExecutionTimedOutEventAttributes;
import com.uber.cadence.internal.compatibility.thrift.EnumMapper;
import com.uber.cadence.internal.compatibility.thrift.Helpers;
import com.uber.cadence.internal.compatibility.thrift.TypeMapper;
import java.util.ArrayList;
import java.util.List;

class HistoryMapper {
    HistoryMapper() {
    }

    static History history(com.uber.cadence.api.v1.History t) {
        if (t == null || t == com.uber.cadence.api.v1.History.getDefaultInstance()) {
            return null;
        }
        History history = new History();
        history.setEvents(HistoryMapper.historyEventArray(t.getEventsList()));
        return history;
    }

    static List<HistoryEvent> historyEventArray(List<com.uber.cadence.api.v1.HistoryEvent> t) {
        if (t == null) {
            return null;
        }
        ArrayList<HistoryEvent> v = new ArrayList<HistoryEvent>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(HistoryMapper.historyEvent(t.get(i)));
        }
        return v;
    }

    static HistoryEvent historyEvent(com.uber.cadence.api.v1.HistoryEvent e) {
        if (e == null || e == com.uber.cadence.api.v1.HistoryEvent.getDefaultInstance()) {
            return null;
        }
        HistoryEvent event = new HistoryEvent();
        event.setEventId(e.getEventId());
        event.setTimestamp(Helpers.timeToUnixNano(e.getEventTime()));
        event.setVersion(e.getVersion());
        event.setTaskId(e.getTaskId());
        if (e.getWorkflowExecutionStartedEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionStartedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionStarted);
            event.setWorkflowExecutionStartedEventAttributes(HistoryMapper.workflowExecutionStartedEventAttributes(e.getWorkflowExecutionStartedEventAttributes()));
        } else if (e.getWorkflowExecutionCompletedEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionCompletedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionCompleted);
            event.setWorkflowExecutionCompletedEventAttributes(HistoryMapper.workflowExecutionCompletedEventAttributes(e.getWorkflowExecutionCompletedEventAttributes()));
        } else if (e.getWorkflowExecutionFailedEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionFailed);
            event.setWorkflowExecutionFailedEventAttributes(HistoryMapper.workflowExecutionFailedEventAttributes(e.getWorkflowExecutionFailedEventAttributes()));
        } else if (e.getWorkflowExecutionTimedOutEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionTimedOutEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionTimedOut);
            event.setWorkflowExecutionTimedOutEventAttributes(HistoryMapper.workflowExecutionTimedOutEventAttributes(e.getWorkflowExecutionTimedOutEventAttributes()));
        } else if (e.getDecisionTaskScheduledEventAttributes() != com.uber.cadence.api.v1.DecisionTaskScheduledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.DecisionTaskScheduled);
            event.setDecisionTaskScheduledEventAttributes(HistoryMapper.decisionTaskScheduledEventAttributes(e.getDecisionTaskScheduledEventAttributes()));
        } else if (e.getDecisionTaskStartedEventAttributes() != com.uber.cadence.api.v1.DecisionTaskStartedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.DecisionTaskStarted);
            event.setDecisionTaskStartedEventAttributes(HistoryMapper.decisionTaskStartedEventAttributes(e.getDecisionTaskStartedEventAttributes()));
        } else if (e.getDecisionTaskCompletedEventAttributes() != com.uber.cadence.api.v1.DecisionTaskCompletedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.DecisionTaskCompleted);
            event.setDecisionTaskCompletedEventAttributes(HistoryMapper.decisionTaskCompletedEventAttributes(e.getDecisionTaskCompletedEventAttributes()));
        } else if (e.getDecisionTaskTimedOutEventAttributes() != com.uber.cadence.api.v1.DecisionTaskTimedOutEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.DecisionTaskTimedOut);
            event.setDecisionTaskTimedOutEventAttributes(HistoryMapper.decisionTaskTimedOutEventAttributes(e.getDecisionTaskTimedOutEventAttributes()));
        } else if (e.getDecisionTaskFailedEventAttributes() != com.uber.cadence.api.v1.DecisionTaskFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.DecisionTaskFailed);
            event.setDecisionTaskFailedEventAttributes(HistoryMapper.decisionTaskFailedEventAttributes(e.getDecisionTaskFailedEventAttributes()));
        } else if (e.getActivityTaskScheduledEventAttributes() != com.uber.cadence.api.v1.ActivityTaskScheduledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskScheduled);
            event.setActivityTaskScheduledEventAttributes(HistoryMapper.activityTaskScheduledEventAttributes(e.getActivityTaskScheduledEventAttributes()));
        } else if (e.getActivityTaskStartedEventAttributes() != com.uber.cadence.api.v1.ActivityTaskStartedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskStarted);
            event.setActivityTaskStartedEventAttributes(HistoryMapper.activityTaskStartedEventAttributes(e.getActivityTaskStartedEventAttributes()));
        } else if (e.getActivityTaskCompletedEventAttributes() != com.uber.cadence.api.v1.ActivityTaskCompletedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskCompleted);
            event.setActivityTaskCompletedEventAttributes(HistoryMapper.activityTaskCompletedEventAttributes(e.getActivityTaskCompletedEventAttributes()));
        } else if (e.getActivityTaskFailedEventAttributes() != com.uber.cadence.api.v1.ActivityTaskFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskFailed);
            event.setActivityTaskFailedEventAttributes(HistoryMapper.activityTaskFailedEventAttributes(e.getActivityTaskFailedEventAttributes()));
        } else if (e.getActivityTaskTimedOutEventAttributes() != com.uber.cadence.api.v1.ActivityTaskTimedOutEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskTimedOut);
            event.setActivityTaskTimedOutEventAttributes(HistoryMapper.activityTaskTimedOutEventAttributes(e.getActivityTaskTimedOutEventAttributes()));
        } else if (e.getTimerStartedEventAttributes() != com.uber.cadence.api.v1.TimerStartedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.TimerStarted);
            event.setTimerStartedEventAttributes(HistoryMapper.timerStartedEventAttributes(e.getTimerStartedEventAttributes()));
        } else if (e.getTimerFiredEventAttributes() != com.uber.cadence.api.v1.TimerFiredEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.TimerFired);
            event.setTimerFiredEventAttributes(HistoryMapper.timerFiredEventAttributes(e.getTimerFiredEventAttributes()));
        } else if (e.getActivityTaskCancelRequestedEventAttributes() != com.uber.cadence.api.v1.ActivityTaskCancelRequestedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskCancelRequested);
            event.setActivityTaskCancelRequestedEventAttributes(HistoryMapper.activityTaskCancelRequestedEventAttributes(e.getActivityTaskCancelRequestedEventAttributes()));
        } else if (e.getRequestCancelActivityTaskFailedEventAttributes() != com.uber.cadence.api.v1.RequestCancelActivityTaskFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.RequestCancelActivityTaskFailed);
            event.setRequestCancelActivityTaskFailedEventAttributes(HistoryMapper.requestCancelActivityTaskFailedEventAttributes(e.getRequestCancelActivityTaskFailedEventAttributes()));
        } else if (e.getActivityTaskCanceledEventAttributes() != com.uber.cadence.api.v1.ActivityTaskCanceledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ActivityTaskCanceled);
            event.setActivityTaskCanceledEventAttributes(HistoryMapper.activityTaskCanceledEventAttributes(e.getActivityTaskCanceledEventAttributes()));
        } else if (e.getTimerCanceledEventAttributes() != com.uber.cadence.api.v1.TimerCanceledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.TimerCanceled);
            event.setTimerCanceledEventAttributes(HistoryMapper.timerCanceledEventAttributes(e.getTimerCanceledEventAttributes()));
        } else if (e.getCancelTimerFailedEventAttributes() != com.uber.cadence.api.v1.CancelTimerFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.CancelTimerFailed);
            event.setCancelTimerFailedEventAttributes(HistoryMapper.cancelTimerFailedEventAttributes(e.getCancelTimerFailedEventAttributes()));
        } else if (e.getMarkerRecordedEventAttributes() != com.uber.cadence.api.v1.MarkerRecordedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.MarkerRecorded);
            event.setMarkerRecordedEventAttributes(HistoryMapper.markerRecordedEventAttributes(e.getMarkerRecordedEventAttributes()));
        } else if (e.getWorkflowExecutionSignaledEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionSignaledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionSignaled);
            event.setWorkflowExecutionSignaledEventAttributes(HistoryMapper.workflowExecutionSignaledEventAttributes(e.getWorkflowExecutionSignaledEventAttributes()));
        } else if (e.getWorkflowExecutionTerminatedEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionTerminatedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionTerminated);
            event.setWorkflowExecutionTerminatedEventAttributes(HistoryMapper.workflowExecutionTerminatedEventAttributes(e.getWorkflowExecutionTerminatedEventAttributes()));
        } else if (e.getWorkflowExecutionCancelRequestedEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionCancelRequestedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionCancelRequested);
            event.setWorkflowExecutionCancelRequestedEventAttributes(HistoryMapper.workflowExecutionCancelRequestedEventAttributes(e.getWorkflowExecutionCancelRequestedEventAttributes()));
        } else if (e.getWorkflowExecutionCanceledEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionCanceledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionCanceled);
            event.setWorkflowExecutionCanceledEventAttributes(HistoryMapper.workflowExecutionCanceledEventAttributes(e.getWorkflowExecutionCanceledEventAttributes()));
        } else if (e.getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes() != com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.RequestCancelExternalWorkflowExecutionInitiated);
            event.setRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(HistoryMapper.requestCancelExternalWorkflowExecutionInitiatedEventAttributes(e.getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes()));
        } else if (e.getRequestCancelExternalWorkflowExecutionFailedEventAttributes() != com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.RequestCancelExternalWorkflowExecutionFailed);
            event.setRequestCancelExternalWorkflowExecutionFailedEventAttributes(HistoryMapper.requestCancelExternalWorkflowExecutionFailedEventAttributes(e.getRequestCancelExternalWorkflowExecutionFailedEventAttributes()));
        } else if (e.getExternalWorkflowExecutionCancelRequestedEventAttributes() != com.uber.cadence.api.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ExternalWorkflowExecutionCancelRequested);
            event.setExternalWorkflowExecutionCancelRequestedEventAttributes(HistoryMapper.externalWorkflowExecutionCancelRequestedEventAttributes(e.getExternalWorkflowExecutionCancelRequestedEventAttributes()));
        } else if (e.getWorkflowExecutionContinuedAsNewEventAttributes() != com.uber.cadence.api.v1.WorkflowExecutionContinuedAsNewEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.WorkflowExecutionContinuedAsNew);
            event.setWorkflowExecutionContinuedAsNewEventAttributes(HistoryMapper.workflowExecutionContinuedAsNewEventAttributes(e.getWorkflowExecutionContinuedAsNewEventAttributes()));
        } else if (e.getStartChildWorkflowExecutionInitiatedEventAttributes() != com.uber.cadence.api.v1.StartChildWorkflowExecutionInitiatedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.StartChildWorkflowExecutionInitiated);
            event.setStartChildWorkflowExecutionInitiatedEventAttributes(HistoryMapper.startChildWorkflowExecutionInitiatedEventAttributes(e.getStartChildWorkflowExecutionInitiatedEventAttributes()));
        } else if (e.getStartChildWorkflowExecutionFailedEventAttributes() != com.uber.cadence.api.v1.StartChildWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.StartChildWorkflowExecutionFailed);
            event.setStartChildWorkflowExecutionFailedEventAttributes(HistoryMapper.startChildWorkflowExecutionFailedEventAttributes(e.getStartChildWorkflowExecutionFailedEventAttributes()));
        } else if (e.getChildWorkflowExecutionStartedEventAttributes() != com.uber.cadence.api.v1.ChildWorkflowExecutionStartedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ChildWorkflowExecutionStarted);
            event.setChildWorkflowExecutionStartedEventAttributes(HistoryMapper.childWorkflowExecutionStartedEventAttributes(e.getChildWorkflowExecutionStartedEventAttributes()));
        } else if (e.getChildWorkflowExecutionCompletedEventAttributes() != com.uber.cadence.api.v1.ChildWorkflowExecutionCompletedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ChildWorkflowExecutionCompleted);
            event.setChildWorkflowExecutionCompletedEventAttributes(HistoryMapper.childWorkflowExecutionCompletedEventAttributes(e.getChildWorkflowExecutionCompletedEventAttributes()));
        } else if (e.getChildWorkflowExecutionFailedEventAttributes() != com.uber.cadence.api.v1.ChildWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ChildWorkflowExecutionFailed);
            event.setChildWorkflowExecutionFailedEventAttributes(HistoryMapper.childWorkflowExecutionFailedEventAttributes(e.getChildWorkflowExecutionFailedEventAttributes()));
        } else if (e.getChildWorkflowExecutionCanceledEventAttributes() != com.uber.cadence.api.v1.ChildWorkflowExecutionCanceledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ChildWorkflowExecutionCanceled);
            event.setChildWorkflowExecutionCanceledEventAttributes(HistoryMapper.childWorkflowExecutionCanceledEventAttributes(e.getChildWorkflowExecutionCanceledEventAttributes()));
        } else if (e.getChildWorkflowExecutionTimedOutEventAttributes() != com.uber.cadence.api.v1.ChildWorkflowExecutionTimedOutEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ChildWorkflowExecutionTimedOut);
            event.setChildWorkflowExecutionTimedOutEventAttributes(HistoryMapper.childWorkflowExecutionTimedOutEventAttributes(e.getChildWorkflowExecutionTimedOutEventAttributes()));
        } else if (e.getChildWorkflowExecutionTerminatedEventAttributes() != com.uber.cadence.api.v1.ChildWorkflowExecutionTerminatedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ChildWorkflowExecutionTerminated);
            event.setChildWorkflowExecutionTerminatedEventAttributes(HistoryMapper.childWorkflowExecutionTerminatedEventAttributes(e.getChildWorkflowExecutionTerminatedEventAttributes()));
        } else if (e.getSignalExternalWorkflowExecutionInitiatedEventAttributes() != com.uber.cadence.api.v1.SignalExternalWorkflowExecutionInitiatedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.SignalExternalWorkflowExecutionInitiated);
            event.setSignalExternalWorkflowExecutionInitiatedEventAttributes(HistoryMapper.signalExternalWorkflowExecutionInitiatedEventAttributes(e.getSignalExternalWorkflowExecutionInitiatedEventAttributes()));
        } else if (e.getSignalExternalWorkflowExecutionFailedEventAttributes() != com.uber.cadence.api.v1.SignalExternalWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.SignalExternalWorkflowExecutionFailed);
            event.setSignalExternalWorkflowExecutionFailedEventAttributes(HistoryMapper.signalExternalWorkflowExecutionFailedEventAttributes(e.getSignalExternalWorkflowExecutionFailedEventAttributes()));
        } else if (e.getExternalWorkflowExecutionSignaledEventAttributes() != com.uber.cadence.api.v1.ExternalWorkflowExecutionSignaledEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.ExternalWorkflowExecutionSignaled);
            event.setExternalWorkflowExecutionSignaledEventAttributes(HistoryMapper.externalWorkflowExecutionSignaledEventAttributes(e.getExternalWorkflowExecutionSignaledEventAttributes()));
        } else if (e.getUpsertWorkflowSearchAttributesEventAttributes() != com.uber.cadence.api.v1.UpsertWorkflowSearchAttributesEventAttributes.getDefaultInstance()) {
            event.setEventType(EventType.UpsertWorkflowSearchAttributes);
            event.setUpsertWorkflowSearchAttributesEventAttributes(HistoryMapper.upsertWorkflowSearchAttributesEventAttributes(e.getUpsertWorkflowSearchAttributesEventAttributes()));
        } else {
            throw new IllegalArgumentException("unknown event type");
        }
        return event;
    }

    static ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes(com.uber.cadence.api.v1.ActivityTaskCancelRequestedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskCancelRequestedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskCancelRequestedEventAttributes res = new ActivityTaskCancelRequestedEventAttributes();
        res.setActivityId(t.getActivityId());
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        return res;
    }

    static ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes(com.uber.cadence.api.v1.ActivityTaskCanceledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskCanceledEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskCanceledEventAttributes res = new ActivityTaskCanceledEventAttributes();
        res.setDetails(TypeMapper.payload(t.getDetails()));
        res.setLatestCancelRequestedEventId(t.getLatestCancelRequestedEventId());
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setIdentity(t.getIdentity());
        return res;
    }

    static ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes(com.uber.cadence.api.v1.ActivityTaskCompletedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskCompletedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskCompletedEventAttributes res = new ActivityTaskCompletedEventAttributes();
        res.setResult(TypeMapper.payload(t.getResult()));
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setIdentity(t.getIdentity());
        return res;
    }

    static ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes(com.uber.cadence.api.v1.ActivityTaskFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskFailedEventAttributes res = new ActivityTaskFailedEventAttributes();
        res.setReason(TypeMapper.failureReason(t.getFailure()));
        res.setDetails(TypeMapper.failureDetails(t.getFailure()));
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setIdentity(t.getIdentity());
        return res;
    }

    static ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes(com.uber.cadence.api.v1.ActivityTaskScheduledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskScheduledEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskScheduledEventAttributes res = new ActivityTaskScheduledEventAttributes();
        res.setActivityId(t.getActivityId());
        res.setActivityType(TypeMapper.activityType(t.getActivityType()));
        res.setDomain(t.getDomain());
        res.setTaskList(TypeMapper.taskList(t.getTaskList()));
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setScheduleToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getScheduleToCloseTimeout()));
        res.setScheduleToStartTimeoutSeconds(Helpers.durationToSeconds(t.getScheduleToStartTimeout()));
        res.setStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getStartToCloseTimeout()));
        res.setHeartbeatTimeoutSeconds(Helpers.durationToSeconds(t.getHeartbeatTimeout()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setRetryPolicy(TypeMapper.retryPolicy(t.getRetryPolicy()));
        res.setHeader(TypeMapper.header(t.getHeader()));
        return res;
    }

    static ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes(com.uber.cadence.api.v1.ActivityTaskStartedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskStartedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskStartedEventAttributes res = new ActivityTaskStartedEventAttributes();
        res.setScheduledEventId(t.getScheduledEventId());
        res.setIdentity(t.getIdentity());
        res.setRequestId(t.getRequestId());
        res.setAttempt(t.getAttempt());
        res.setLastFailureReason(TypeMapper.failureReason(t.getLastFailure()));
        res.setLastFailureDetails(TypeMapper.failureDetails(t.getLastFailure()));
        return res;
    }

    static ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes(com.uber.cadence.api.v1.ActivityTaskTimedOutEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityTaskTimedOutEventAttributes.getDefaultInstance()) {
            return null;
        }
        ActivityTaskTimedOutEventAttributes res = new ActivityTaskTimedOutEventAttributes();
        res.setDetails(TypeMapper.payload(t.getDetails()));
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setTimeoutType(EnumMapper.timeoutType(t.getTimeoutType()));
        res.setLastFailureReason(TypeMapper.failureReason(t.getLastFailure()));
        res.setLastFailureDetails(TypeMapper.failureDetails(t.getLastFailure()));
        return res;
    }

    static CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes(com.uber.cadence.api.v1.CancelTimerFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.CancelTimerFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        CancelTimerFailedEventAttributes res = new CancelTimerFailedEventAttributes();
        res.setTimerId(t.getTimerId());
        res.setCause(t.getCause());
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setIdentity(t.getIdentity());
        return res;
    }

    static ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes(com.uber.cadence.api.v1.ChildWorkflowExecutionCanceledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ChildWorkflowExecutionCanceledEventAttributes.getDefaultInstance()) {
            return null;
        }
        ChildWorkflowExecutionCanceledEventAttributes res = new ChildWorkflowExecutionCanceledEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setDetails(TypeMapper.payload(t.getDetails()));
        return res;
    }

    static ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes(com.uber.cadence.api.v1.ChildWorkflowExecutionCompletedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ChildWorkflowExecutionCompletedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ChildWorkflowExecutionCompletedEventAttributes res = new ChildWorkflowExecutionCompletedEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setResult(TypeMapper.payload(t.getResult()));
        return res;
    }

    static ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes(com.uber.cadence.api.v1.ChildWorkflowExecutionFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ChildWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ChildWorkflowExecutionFailedEventAttributes res = new ChildWorkflowExecutionFailedEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setReason(TypeMapper.failureReason(t.getFailure()));
        res.setDetails(TypeMapper.failureDetails(t.getFailure()));
        return res;
    }

    static ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes(com.uber.cadence.api.v1.ChildWorkflowExecutionStartedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ChildWorkflowExecutionStartedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ChildWorkflowExecutionStartedEventAttributes res = new ChildWorkflowExecutionStartedEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setHeader(TypeMapper.header(t.getHeader()));
        return res;
    }

    static ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes(com.uber.cadence.api.v1.ChildWorkflowExecutionTerminatedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ChildWorkflowExecutionTerminatedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ChildWorkflowExecutionTerminatedEventAttributes res = new ChildWorkflowExecutionTerminatedEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setStartedEventId(t.getStartedEventId());
        return res;
    }

    static ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes(com.uber.cadence.api.v1.ChildWorkflowExecutionTimedOutEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ChildWorkflowExecutionTimedOutEventAttributes.getDefaultInstance()) {
            return null;
        }
        ChildWorkflowExecutionTimedOutEventAttributes res = new ChildWorkflowExecutionTimedOutEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setTimeoutType(EnumMapper.timeoutType(t.getTimeoutType()));
        return res;
    }

    static DecisionTaskFailedEventAttributes decisionTaskFailedEventAttributes(com.uber.cadence.api.v1.DecisionTaskFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.DecisionTaskFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        DecisionTaskFailedEventAttributes res = new DecisionTaskFailedEventAttributes();
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setCause(EnumMapper.decisionTaskFailedCause(t.getCause()));
        res.setReason(TypeMapper.failureReason(t.getFailure()));
        res.setDetails(TypeMapper.failureDetails(t.getFailure()));
        res.setIdentity(t.getIdentity());
        res.setBaseRunId(t.getBaseRunId());
        res.setNewRunId(t.getNewRunId());
        res.setForkEventVersion(t.getForkEventVersion());
        res.setBinaryChecksum(t.getBinaryChecksum());
        return res;
    }

    static DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes(com.uber.cadence.api.v1.DecisionTaskScheduledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.DecisionTaskScheduledEventAttributes.getDefaultInstance()) {
            return null;
        }
        DecisionTaskScheduledEventAttributes res = new DecisionTaskScheduledEventAttributes();
        res.setTaskList(TypeMapper.taskList(t.getTaskList()));
        res.setStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getStartToCloseTimeout()));
        res.setAttempt(t.getAttempt());
        return res;
    }

    static DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes(com.uber.cadence.api.v1.DecisionTaskStartedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.DecisionTaskStartedEventAttributes.getDefaultInstance()) {
            return null;
        }
        DecisionTaskStartedEventAttributes res = new DecisionTaskStartedEventAttributes();
        res.setScheduledEventId(t.getScheduledEventId());
        res.setIdentity(t.getIdentity());
        res.setRequestId(t.getRequestId());
        return res;
    }

    static DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes(com.uber.cadence.api.v1.DecisionTaskCompletedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.DecisionTaskCompletedEventAttributes.getDefaultInstance()) {
            return null;
        }
        DecisionTaskCompletedEventAttributes res = new DecisionTaskCompletedEventAttributes();
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setIdentity(t.getIdentity());
        res.setBinaryChecksum(t.getBinaryChecksum());
        res.setExecutionContext(Helpers.byteStringToArray(t.getExecutionContext()));
        return res;
    }

    static DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes(com.uber.cadence.api.v1.DecisionTaskTimedOutEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.DecisionTaskTimedOutEventAttributes.getDefaultInstance()) {
            return null;
        }
        DecisionTaskTimedOutEventAttributes res = new DecisionTaskTimedOutEventAttributes();
        res.setScheduledEventId(t.getScheduledEventId());
        res.setStartedEventId(t.getStartedEventId());
        res.setTimeoutType(EnumMapper.timeoutType(t.getTimeoutType()));
        res.setBaseRunId(t.getBaseRunId());
        res.setNewRunId(t.getNewRunId());
        res.setForkEventVersion(t.getForkEventVersion());
        res.setReason(t.getReason());
        res.setCause(EnumMapper.decisionTaskTimedOutCause(t.getCause()));
        return res;
    }

    static ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes(com.uber.cadence.api.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes.getDefaultInstance()) {
            return null;
        }
        ExternalWorkflowExecutionCancelRequestedEventAttributes res = new ExternalWorkflowExecutionCancelRequestedEventAttributes();
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        return res;
    }

    static ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes(com.uber.cadence.api.v1.ExternalWorkflowExecutionSignaledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.ExternalWorkflowExecutionSignaledEventAttributes.getDefaultInstance()) {
            return null;
        }
        ExternalWorkflowExecutionSignaledEventAttributes res = new ExternalWorkflowExecutionSignaledEventAttributes();
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        return res;
    }

    static MarkerRecordedEventAttributes markerRecordedEventAttributes(com.uber.cadence.api.v1.MarkerRecordedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.MarkerRecordedEventAttributes.getDefaultInstance()) {
            return null;
        }
        MarkerRecordedEventAttributes res = new MarkerRecordedEventAttributes();
        res.setMarkerName(t.getMarkerName());
        res.setDetails(TypeMapper.payload(t.getDetails()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setHeader(TypeMapper.header(t.getHeader()));
        return res;
    }

    static RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes(com.uber.cadence.api.v1.RequestCancelActivityTaskFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.RequestCancelActivityTaskFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        RequestCancelActivityTaskFailedEventAttributes res = new RequestCancelActivityTaskFailedEventAttributes();
        res.setActivityId(t.getActivityId());
        res.setCause(t.getCause());
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        return res;
    }

    static RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes(com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        RequestCancelExternalWorkflowExecutionFailedEventAttributes res = new RequestCancelExternalWorkflowExecutionFailedEventAttributes();
        res.setCause(EnumMapper.cancelExternalWorkflowExecutionFailedCause(t.getCause()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        return res;
    }

    static RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes(com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.getDefaultInstance()) {
            return null;
        }
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes res = new RequestCancelExternalWorkflowExecutionInitiatedEventAttributes();
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        res.setChildWorkflowOnly(t.getChildWorkflowOnly());
        return res;
    }

    static SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes(com.uber.cadence.api.v1.SignalExternalWorkflowExecutionFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.SignalExternalWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        SignalExternalWorkflowExecutionFailedEventAttributes res = new SignalExternalWorkflowExecutionFailedEventAttributes();
        res.setCause(EnumMapper.signalExternalWorkflowExecutionFailedCause(t.getCause()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        return res;
    }

    static SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes(com.uber.cadence.api.v1.SignalExternalWorkflowExecutionInitiatedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.SignalExternalWorkflowExecutionInitiatedEventAttributes.getDefaultInstance()) {
            return null;
        }
        SignalExternalWorkflowExecutionInitiatedEventAttributes res = new SignalExternalWorkflowExecutionInitiatedEventAttributes();
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setDomain(t.getDomain());
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setSignalName(t.getSignalName());
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        res.setChildWorkflowOnly(t.getChildWorkflowOnly());
        return res;
    }

    static StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes(com.uber.cadence.api.v1.StartChildWorkflowExecutionFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.StartChildWorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        StartChildWorkflowExecutionFailedEventAttributes res = new StartChildWorkflowExecutionFailedEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowId(t.getWorkflowId());
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setCause(EnumMapper.childWorkflowExecutionFailedCause(t.getCause()));
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        res.setInitiatedEventId(t.getInitiatedEventId());
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        return res;
    }

    static StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes(com.uber.cadence.api.v1.StartChildWorkflowExecutionInitiatedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.StartChildWorkflowExecutionInitiatedEventAttributes.getDefaultInstance()) {
            return null;
        }
        StartChildWorkflowExecutionInitiatedEventAttributes res = new StartChildWorkflowExecutionInitiatedEventAttributes();
        res.setDomain(t.getDomain());
        res.setWorkflowId(t.getWorkflowId());
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setTaskList(TypeMapper.taskList(t.getTaskList()));
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setExecutionStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getExecutionStartToCloseTimeout()));
        res.setTaskStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getTaskStartToCloseTimeout()));
        res.setParentClosePolicy(EnumMapper.parentClosePolicy(t.getParentClosePolicy()));
        res.setControl(Helpers.byteStringToArray(t.getControl()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setWorkflowIdReusePolicy(EnumMapper.workflowIdReusePolicy(t.getWorkflowIdReusePolicy()));
        res.setRetryPolicy(TypeMapper.retryPolicy(t.getRetryPolicy()));
        res.setCronSchedule(t.getCronSchedule());
        res.setHeader(TypeMapper.header(t.getHeader()));
        res.setMemo(TypeMapper.memo(t.getMemo()));
        res.setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes()));
        res.setDelayStartSeconds(Helpers.durationToSeconds(t.getDelayStart()));
        return res;
    }

    static TimerCanceledEventAttributes timerCanceledEventAttributes(com.uber.cadence.api.v1.TimerCanceledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.TimerCanceledEventAttributes.getDefaultInstance()) {
            return null;
        }
        TimerCanceledEventAttributes res = new TimerCanceledEventAttributes();
        res.setTimerId(t.getTimerId());
        res.setStartedEventId(t.getStartedEventId());
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setIdentity(t.getIdentity());
        return res;
    }

    static TimerFiredEventAttributes timerFiredEventAttributes(com.uber.cadence.api.v1.TimerFiredEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.TimerFiredEventAttributes.getDefaultInstance()) {
            return null;
        }
        TimerFiredEventAttributes res = new TimerFiredEventAttributes();
        res.setTimerId(t.getTimerId());
        res.setStartedEventId(t.getStartedEventId());
        return res;
    }

    static TimerStartedEventAttributes timerStartedEventAttributes(com.uber.cadence.api.v1.TimerStartedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.TimerStartedEventAttributes.getDefaultInstance()) {
            return null;
        }
        TimerStartedEventAttributes res = new TimerStartedEventAttributes();
        res.setTimerId(t.getTimerId());
        res.setStartToFireTimeoutSeconds(Helpers.durationToSeconds(t.getStartToFireTimeout()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        return res;
    }

    static UpsertWorkflowSearchAttributesEventAttributes upsertWorkflowSearchAttributesEventAttributes(com.uber.cadence.api.v1.UpsertWorkflowSearchAttributesEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.UpsertWorkflowSearchAttributesEventAttributes.getDefaultInstance()) {
            return null;
        }
        UpsertWorkflowSearchAttributesEventAttributes res = new UpsertWorkflowSearchAttributesEventAttributes();
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes()));
        return res;
    }

    static WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionCancelRequestedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionCancelRequestedEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionCancelRequestedEventAttributes res = new WorkflowExecutionCancelRequestedEventAttributes();
        res.setCause(t.getCause());
        res.setExternalInitiatedEventId(TypeMapper.externalInitiatedId(t.getExternalExecutionInfo()));
        res.setExternalWorkflowExecution(TypeMapper.externalWorkflowExecution(t.getExternalExecutionInfo()));
        res.setIdentity(t.getIdentity());
        return res;
    }

    static WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionCanceledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionCanceledEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionCanceledEventAttributes res = new WorkflowExecutionCanceledEventAttributes();
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setDetails(TypeMapper.payload(t.getDetails()));
        return res;
    }

    static WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionCompletedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionCompletedEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionCompletedEventAttributes res = new WorkflowExecutionCompletedEventAttributes();
        res.setResult(TypeMapper.payload(t.getResult()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        return res;
    }

    static WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionContinuedAsNewEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionContinuedAsNewEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionContinuedAsNewEventAttributes res = new WorkflowExecutionContinuedAsNewEventAttributes();
        res.setNewExecutionRunId(t.getNewExecutionRunId());
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setTaskList(TypeMapper.taskList(t.getTaskList()));
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setExecutionStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getExecutionStartToCloseTimeout()));
        res.setTaskStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getTaskStartToCloseTimeout()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        res.setBackoffStartIntervalInSeconds(Helpers.durationToSeconds(t.getBackoffStartInterval()));
        res.setInitiator(EnumMapper.continueAsNewInitiator(t.getInitiator()));
        res.setFailureReason(TypeMapper.failureReason(t.getFailure()));
        res.setFailureDetails(TypeMapper.failureDetails(t.getFailure()));
        res.setLastCompletionResult(TypeMapper.payload(t.getLastCompletionResult()));
        res.setHeader(TypeMapper.header(t.getHeader()));
        res.setMemo(TypeMapper.memo(t.getMemo()));
        res.setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes()));
        return res;
    }

    static WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionFailedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionFailedEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionFailedEventAttributes res = new WorkflowExecutionFailedEventAttributes();
        res.setReason(TypeMapper.failureReason(t.getFailure()));
        res.setDetails(TypeMapper.failureDetails(t.getFailure()));
        res.setDecisionTaskCompletedEventId(t.getDecisionTaskCompletedEventId());
        return res;
    }

    static WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionSignaledEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionSignaledEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionSignaledEventAttributes res = new WorkflowExecutionSignaledEventAttributes();
        res.setSignalName(t.getSignalName());
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setIdentity(t.getIdentity());
        return res;
    }

    static WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionStartedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionStartedEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionStartedEventAttributes res = new WorkflowExecutionStartedEventAttributes();
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setParentWorkflowDomain(TypeMapper.parentDomainName(t.getParentExecutionInfo()));
        res.setParentWorkflowExecution(TypeMapper.parentWorkflowExecution(t.getParentExecutionInfo()));
        res.setParentInitiatedEventId(TypeMapper.parentInitiatedId(t.getParentExecutionInfo()));
        res.setTaskList(TypeMapper.taskList(t.getTaskList()));
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setExecutionStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getExecutionStartToCloseTimeout()));
        res.setTaskStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getTaskStartToCloseTimeout()));
        res.setContinuedExecutionRunId(t.getContinuedExecutionRunId());
        res.setInitiator(EnumMapper.continueAsNewInitiator(t.getInitiator()));
        res.setContinuedFailureReason(TypeMapper.failureReason(t.getContinuedFailure()));
        res.setContinuedFailureDetails(TypeMapper.failureDetails(t.getContinuedFailure()));
        res.setLastCompletionResult(TypeMapper.payload(t.getLastCompletionResult()));
        res.setOriginalExecutionRunId(t.getOriginalExecutionRunId());
        res.setIdentity(t.getIdentity());
        res.setFirstExecutionRunId(t.getFirstExecutionRunId());
        res.setRetryPolicy(TypeMapper.retryPolicy(t.getRetryPolicy()));
        res.setAttempt(t.getAttempt());
        res.setExpirationTimestamp(Helpers.timeToUnixNano(t.getExpirationTime()));
        res.setCronSchedule(t.getCronSchedule());
        res.setFirstDecisionTaskBackoffSeconds(Helpers.durationToSeconds(t.getFirstDecisionTaskBackoff()));
        res.setMemo(TypeMapper.memo(t.getMemo()));
        res.setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes()));
        res.setPrevAutoResetPoints(TypeMapper.resetPoints(t.getPrevAutoResetPoints()));
        res.setHeader(TypeMapper.header(t.getHeader()));
        return res;
    }

    static WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionTerminatedEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionTerminatedEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionTerminatedEventAttributes res = new WorkflowExecutionTerminatedEventAttributes();
        res.setReason(t.getReason());
        res.setDetails(TypeMapper.payload(t.getDetails()));
        res.setIdentity(t.getIdentity());
        return res;
    }

    static WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes(com.uber.cadence.api.v1.WorkflowExecutionTimedOutEventAttributes t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionTimedOutEventAttributes.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionTimedOutEventAttributes res = new WorkflowExecutionTimedOutEventAttributes();
        res.setTimeoutType(EnumMapper.timeoutType(t.getTimeoutType()));
        return res;
    }
}

