/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.thrift;

import com.uber.cadence.ClusterInfo;
import com.uber.cadence.CountWorkflowExecutionsResponse;
import com.uber.cadence.DescribeDomainResponse;
import com.uber.cadence.DescribeTaskListResponse;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.DomainConfiguration;
import com.uber.cadence.DomainInfo;
import com.uber.cadence.DomainReplicationConfiguration;
import com.uber.cadence.GetSearchAttributesResponse;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.ListArchivedWorkflowExecutionsResponse;
import com.uber.cadence.ListClosedWorkflowExecutionsResponse;
import com.uber.cadence.ListDomainsResponse;
import com.uber.cadence.ListOpenWorkflowExecutionsResponse;
import com.uber.cadence.ListTaskListPartitionsResponse;
import com.uber.cadence.ListWorkflowExecutionsResponse;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.ResetWorkflowExecutionResponse;
import com.uber.cadence.RespondDecisionTaskCompletedResponse;
import com.uber.cadence.StartWorkflowExecutionResponse;
import com.uber.cadence.UpdateDomainResponse;
import com.uber.cadence.api.v1.GetClusterInfoResponse;
import com.uber.cadence.api.v1.RecordActivityTaskHeartbeatByIDResponse;
import com.uber.cadence.api.v1.ScanWorkflowExecutionsResponse;
import com.uber.cadence.api.v1.SignalWithStartWorkflowExecutionResponse;
import com.uber.cadence.api.v1.WorkflowQuery;
import com.uber.cadence.internal.compatibility.thrift.EnumMapper;
import com.uber.cadence.internal.compatibility.thrift.Helpers;
import com.uber.cadence.internal.compatibility.thrift.HistoryMapper;
import com.uber.cadence.internal.compatibility.thrift.TypeMapper;

public class ResponseMapper {
    public static StartWorkflowExecutionResponse startWorkflowExecutionResponse(com.uber.cadence.api.v1.StartWorkflowExecutionResponse t) {
        if (t == null) {
            return null;
        }
        StartWorkflowExecutionResponse startWorkflowExecutionResponse = new StartWorkflowExecutionResponse();
        startWorkflowExecutionResponse.setRunId(t.getRunId());
        return startWorkflowExecutionResponse;
    }

    public static DescribeTaskListResponse describeTaskListResponse(com.uber.cadence.api.v1.DescribeTaskListResponse t) {
        if (t == null) {
            return null;
        }
        DescribeTaskListResponse describeTaskListResponse = new DescribeTaskListResponse();
        describeTaskListResponse.setPollers(TypeMapper.pollerInfoArray(t.getPollersList()));
        describeTaskListResponse.setTaskListStatus(TypeMapper.taskListStatus(t.getTaskListStatus()));
        return describeTaskListResponse;
    }

    public static DescribeWorkflowExecutionResponse describeWorkflowExecutionResponse(com.uber.cadence.api.v1.DescribeWorkflowExecutionResponse t) {
        if (t == null) {
            return null;
        }
        DescribeWorkflowExecutionResponse describeWorkflowExecutionResponse = new DescribeWorkflowExecutionResponse();
        describeWorkflowExecutionResponse.setExecutionConfiguration(TypeMapper.workflowExecutionConfiguration(t.getExecutionConfiguration()));
        describeWorkflowExecutionResponse.setWorkflowExecutionInfo(TypeMapper.workflowExecutionInfo(t.getWorkflowExecutionInfo()));
        describeWorkflowExecutionResponse.setPendingActivities(TypeMapper.pendingActivityInfoArray(t.getPendingActivitiesList()));
        describeWorkflowExecutionResponse.setPendingChildren(TypeMapper.pendingChildExecutionInfoArray(t.getPendingChildrenList()));
        describeWorkflowExecutionResponse.setPendingDecision(TypeMapper.pendingDecisionInfo(t.getPendingDecision()));
        return describeWorkflowExecutionResponse;
    }

    public static ClusterInfo getClusterInfoResponse(GetClusterInfoResponse t) {
        if (t == null) {
            return null;
        }
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setSupportedClientVersions(TypeMapper.supportedClientVersions(t.getSupportedClientVersions()));
        return clusterInfo;
    }

    public static GetSearchAttributesResponse getSearchAttributesResponse(com.uber.cadence.api.v1.GetSearchAttributesResponse t) {
        if (t == null) {
            return null;
        }
        GetSearchAttributesResponse getSearchAttributesResponse = new GetSearchAttributesResponse();
        getSearchAttributesResponse.setKeys(TypeMapper.indexedValueTypeMap(t.getKeysMap()));
        return getSearchAttributesResponse;
    }

    public static GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse(com.uber.cadence.api.v1.GetWorkflowExecutionHistoryResponse t) {
        if (t == null) {
            return null;
        }
        GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse = new GetWorkflowExecutionHistoryResponse();
        getWorkflowExecutionHistoryResponse.setHistory(HistoryMapper.history(t.getHistory()));
        getWorkflowExecutionHistoryResponse.setRawHistory(TypeMapper.dataBlobArray(t.getRawHistoryList()));
        getWorkflowExecutionHistoryResponse.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        getWorkflowExecutionHistoryResponse.setArchived(t.getArchived());
        return getWorkflowExecutionHistoryResponse;
    }

    public static ListArchivedWorkflowExecutionsResponse listArchivedWorkflowExecutionsResponse(com.uber.cadence.api.v1.ListArchivedWorkflowExecutionsResponse t) {
        if (t == null) {
            return null;
        }
        ListArchivedWorkflowExecutionsResponse res = new ListArchivedWorkflowExecutionsResponse();
        res.setExecutions(TypeMapper.workflowExecutionInfoArray(t.getExecutionsList()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        return res;
    }

    public static ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutionsResponse(com.uber.cadence.api.v1.ListClosedWorkflowExecutionsResponse t) {
        if (t == null) {
            return null;
        }
        ListClosedWorkflowExecutionsResponse res = new ListClosedWorkflowExecutionsResponse();
        res.setExecutions(TypeMapper.workflowExecutionInfoArray(t.getExecutionsList()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        return res;
    }

    public static ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutionsResponse(com.uber.cadence.api.v1.ListOpenWorkflowExecutionsResponse t) {
        if (t == null) {
            return null;
        }
        ListOpenWorkflowExecutionsResponse res = new ListOpenWorkflowExecutionsResponse();
        res.setExecutions(TypeMapper.workflowExecutionInfoArray(t.getExecutionsList()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        return res;
    }

    public static ListTaskListPartitionsResponse listTaskListPartitionsResponse(com.uber.cadence.api.v1.ListTaskListPartitionsResponse t) {
        if (t == null) {
            return null;
        }
        ListTaskListPartitionsResponse res = new ListTaskListPartitionsResponse();
        res.setActivityTaskListPartitions(TypeMapper.taskListPartitionMetadataArray(t.getActivityTaskListPartitionsList()));
        res.setDecisionTaskListPartitions(TypeMapper.taskListPartitionMetadataArray(t.getDecisionTaskListPartitionsList()));
        return res;
    }

    public static ListWorkflowExecutionsResponse listWorkflowExecutionsResponse(com.uber.cadence.api.v1.ListWorkflowExecutionsResponse t) {
        if (t == null) {
            return null;
        }
        ListWorkflowExecutionsResponse res = new ListWorkflowExecutionsResponse();
        res.setExecutions(TypeMapper.workflowExecutionInfoArray(t.getExecutionsList()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        return res;
    }

    public static PollForActivityTaskResponse pollForActivityTaskResponse(com.uber.cadence.api.v1.PollForActivityTaskResponse t) {
        if (t == null) {
            return null;
        }
        PollForActivityTaskResponse res = new PollForActivityTaskResponse();
        res.setTaskToken(Helpers.byteStringToArray(t.getTaskToken()));
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setActivityId(t.getActivityId());
        res.setActivityType(TypeMapper.activityType(t.getActivityType()));
        res.setInput(TypeMapper.payload(t.getInput()));
        res.setScheduledTimestamp(Helpers.timeToUnixNano(t.getScheduledTime()));
        res.setStartedTimestamp(Helpers.timeToUnixNano(t.getStartedTime()));
        res.setScheduleToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getScheduleToCloseTimeout()));
        res.setStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getStartToCloseTimeout()));
        res.setHeartbeatTimeoutSeconds(Helpers.durationToSeconds(t.getHeartbeatTimeout()));
        res.setAttempt(t.getAttempt());
        res.setScheduledTimestampOfThisAttempt(Helpers.timeToUnixNano(t.getScheduledTimeOfThisAttempt()));
        res.setHeartbeatDetails(TypeMapper.payload(t.getHeartbeatDetails()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setWorkflowDomain(t.getWorkflowDomain());
        res.setHeader(TypeMapper.header(t.getHeader()));
        return res;
    }

    public static PollForDecisionTaskResponse pollForDecisionTaskResponse(com.uber.cadence.api.v1.PollForDecisionTaskResponse t) {
        if (t == null) {
            return null;
        }
        PollForDecisionTaskResponse res = new PollForDecisionTaskResponse();
        res.setTaskToken(Helpers.byteStringToArray(t.getTaskToken()));
        res.setWorkflowExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setWorkflowType(TypeMapper.workflowType(t.getWorkflowType()));
        res.setPreviousStartedEventId(Helpers.toInt64Value(t.getPreviousStartedEventId()));
        res.setStartedEventId(t.getStartedEventId());
        res.setAttempt(t.getAttempt());
        res.setBacklogCountHint(t.getBacklogCountHint());
        res.setHistory(HistoryMapper.history(t.getHistory()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        if (t.getQuery() != WorkflowQuery.getDefaultInstance()) {
            res.setQuery(TypeMapper.workflowQuery(t.getQuery()));
        }
        res.setWorkflowExecutionTaskList(TypeMapper.taskList(t.getWorkflowExecutionTaskList()));
        res.setScheduledTimestamp(Helpers.timeToUnixNano(t.getScheduledTime()));
        res.setStartedTimestamp(Helpers.timeToUnixNano(t.getStartedTime()));
        res.setQueries(TypeMapper.workflowQueryMap(t.getQueriesMap()));
        res.setNextEventId(t.getNextEventId());
        return res;
    }

    public static QueryWorkflowResponse queryWorkflowResponse(com.uber.cadence.api.v1.QueryWorkflowResponse t) {
        if (t == null) {
            return null;
        }
        QueryWorkflowResponse res = new QueryWorkflowResponse();
        res.setQueryResult(TypeMapper.payload(t.getQueryResult()));
        res.setQueryRejected(TypeMapper.queryRejected(t.getQueryRejected()));
        return res;
    }

    public static RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatByIdResponse(RecordActivityTaskHeartbeatByIDResponse t) {
        if (t == null) {
            return null;
        }
        RecordActivityTaskHeartbeatResponse res = new RecordActivityTaskHeartbeatResponse();
        res.setCancelRequested(t.getCancelRequested());
        return res;
    }

    public static RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatResponse(com.uber.cadence.api.v1.RecordActivityTaskHeartbeatResponse t) {
        if (t == null) {
            return null;
        }
        RecordActivityTaskHeartbeatResponse res = new RecordActivityTaskHeartbeatResponse();
        res.setCancelRequested(t.getCancelRequested());
        return res;
    }

    public static ResetWorkflowExecutionResponse resetWorkflowExecutionResponse(com.uber.cadence.api.v1.ResetWorkflowExecutionResponse t) {
        if (t == null) {
            return null;
        }
        ResetWorkflowExecutionResponse res = new ResetWorkflowExecutionResponse();
        res.setRunId(t.getRunId());
        return res;
    }

    public static RespondDecisionTaskCompletedResponse respondDecisionTaskCompletedResponse(com.uber.cadence.api.v1.RespondDecisionTaskCompletedResponse t) {
        if (t == null) {
            return null;
        }
        RespondDecisionTaskCompletedResponse res = new RespondDecisionTaskCompletedResponse();
        res.setDecisionTask(ResponseMapper.pollForDecisionTaskResponse(t.getDecisionTask()));
        res.setActivitiesToDispatchLocally(TypeMapper.activityLocalDispatchInfoMap(t.getActivitiesToDispatchLocallyMap()));
        return res;
    }

    public static ListWorkflowExecutionsResponse scanWorkflowExecutionsResponse(ScanWorkflowExecutionsResponse t) {
        if (t == null) {
            return null;
        }
        ListWorkflowExecutionsResponse res = new ListWorkflowExecutionsResponse();
        res.setExecutions(TypeMapper.workflowExecutionInfoArray(t.getExecutionsList()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        return res;
    }

    public static CountWorkflowExecutionsResponse countWorkflowExecutionsResponse(com.uber.cadence.api.v1.CountWorkflowExecutionsResponse t) {
        if (t == null) {
            return null;
        }
        CountWorkflowExecutionsResponse res = new CountWorkflowExecutionsResponse();
        res.setCount(t.getCount());
        return res;
    }

    public static DescribeDomainResponse describeDomainResponse(com.uber.cadence.api.v1.DescribeDomainResponse t) {
        if (t == null) {
            return null;
        }
        DescribeDomainResponse response = new DescribeDomainResponse();
        DomainInfo domainInfo = new DomainInfo();
        response.setDomainInfo(domainInfo);
        domainInfo.setName(t.getDomain().getName());
        domainInfo.setStatus(EnumMapper.domainStatus(t.getDomain().getStatus()));
        domainInfo.setDescription(t.getDomain().getDescription());
        domainInfo.setOwnerEmail(t.getDomain().getOwnerEmail());
        domainInfo.setData(t.getDomain().getDataMap());
        domainInfo.setUuid(t.getDomain().getId());
        DomainConfiguration domainConfiguration = new DomainConfiguration();
        domainConfiguration.setWorkflowExecutionRetentionPeriodInDays(Helpers.durationToDays(t.getDomain().getWorkflowExecutionRetentionPeriod()));
        domainConfiguration.setEmitMetric(true);
        domainConfiguration.setBadBinaries(TypeMapper.badBinaries(t.getDomain().getBadBinaries()));
        domainConfiguration.setHistoryArchivalStatus(EnumMapper.archivalStatus(t.getDomain().getHistoryArchivalStatus()));
        domainConfiguration.setHistoryArchivalURI(t.getDomain().getHistoryArchivalUri());
        domainConfiguration.setVisibilityArchivalStatus(EnumMapper.archivalStatus(t.getDomain().getVisibilityArchivalStatus()));
        domainConfiguration.setVisibilityArchivalURI(t.getDomain().getVisibilityArchivalUri());
        DomainReplicationConfiguration replicationConfiguration = new DomainReplicationConfiguration();
        replicationConfiguration.setActiveClusterName(t.getDomain().getActiveClusterName());
        replicationConfiguration.setClusters(TypeMapper.clusterReplicationConfigurationArray(t.getDomain().getClustersList()));
        response.setFailoverVersion(t.getDomain().getFailoverVersion());
        response.setIsGlobalDomain(t.getDomain().getIsGlobalDomain());
        return response;
    }

    public static ListDomainsResponse listDomainsResponse(com.uber.cadence.api.v1.ListDomainsResponse t) {
        if (t == null) {
            return null;
        }
        ListDomainsResponse res = new ListDomainsResponse();
        res.setDomains(TypeMapper.describeDomainResponseArray(t.getDomainsList()));
        res.setNextPageToken(Helpers.byteStringToArray(t.getNextPageToken()));
        return res;
    }

    public static StartWorkflowExecutionResponse signalWithStartWorkflowExecutionResponse(SignalWithStartWorkflowExecutionResponse t) {
        if (t == null) {
            return null;
        }
        StartWorkflowExecutionResponse startWorkflowExecutionResponse = new StartWorkflowExecutionResponse();
        startWorkflowExecutionResponse.setRunId(t.getRunId());
        return startWorkflowExecutionResponse;
    }

    public static UpdateDomainResponse updateDomainResponse(com.uber.cadence.api.v1.UpdateDomainResponse t) {
        if (t == null) {
            return null;
        }
        UpdateDomainResponse updateDomainResponse = new UpdateDomainResponse();
        DomainInfo domainInfo = new DomainInfo();
        updateDomainResponse.setDomainInfo(domainInfo);
        domainInfo.setName(t.getDomain().getName());
        domainInfo.setStatus(EnumMapper.domainStatus(t.getDomain().getStatus()));
        domainInfo.setDescription(t.getDomain().getDescription());
        domainInfo.setOwnerEmail(t.getDomain().getOwnerEmail());
        domainInfo.setData(t.getDomain().getDataMap());
        domainInfo.setUuid(t.getDomain().getId());
        DomainConfiguration domainConfiguration = new DomainConfiguration();
        domainConfiguration.setWorkflowExecutionRetentionPeriodInDays(Helpers.durationToDays(t.getDomain().getWorkflowExecutionRetentionPeriod()));
        domainConfiguration.setEmitMetric(true);
        domainConfiguration.setBadBinaries(TypeMapper.badBinaries(t.getDomain().getBadBinaries()));
        domainConfiguration.setHistoryArchivalStatus(EnumMapper.archivalStatus(t.getDomain().getHistoryArchivalStatus()));
        domainConfiguration.setHistoryArchivalURI(t.getDomain().getHistoryArchivalUri());
        domainConfiguration.setVisibilityArchivalStatus(EnumMapper.archivalStatus(t.getDomain().getVisibilityArchivalStatus()));
        domainConfiguration.setVisibilityArchivalURI(t.getDomain().getVisibilityArchivalUri());
        DomainReplicationConfiguration domainReplicationConfiguration = new DomainReplicationConfiguration();
        domainReplicationConfiguration.setActiveClusterName(t.getDomain().getActiveClusterName());
        domainReplicationConfiguration.setClusters(TypeMapper.clusterReplicationConfigurationArray(t.getDomain().getClustersList()));
        updateDomainResponse.setFailoverVersion(t.getDomain().getFailoverVersion());
        updateDomainResponse.setIsGlobalDomain(t.getDomain().getIsGlobalDomain());
        return updateDomainResponse;
    }
}

