/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.thrift;

import com.uber.cadence.ActivityLocalDispatchInfo;
import com.uber.cadence.ActivityType;
import com.uber.cadence.BadBinaries;
import com.uber.cadence.BadBinaryInfo;
import com.uber.cadence.ClusterReplicationConfiguration;
import com.uber.cadence.DataBlob;
import com.uber.cadence.DescribeDomainResponse;
import com.uber.cadence.DomainConfiguration;
import com.uber.cadence.DomainInfo;
import com.uber.cadence.DomainReplicationConfiguration;
import com.uber.cadence.Header;
import com.uber.cadence.IndexedValueType;
import com.uber.cadence.Memo;
import com.uber.cadence.PendingActivityInfo;
import com.uber.cadence.PendingChildExecutionInfo;
import com.uber.cadence.PendingDecisionInfo;
import com.uber.cadence.PollerInfo;
import com.uber.cadence.QueryRejected;
import com.uber.cadence.ResetPointInfo;
import com.uber.cadence.ResetPoints;
import com.uber.cadence.RetryPolicy;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.SupportedClientVersions;
import com.uber.cadence.TaskIDBlock;
import com.uber.cadence.TaskList;
import com.uber.cadence.TaskListPartitionMetadata;
import com.uber.cadence.TaskListStatus;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionConfiguration;
import com.uber.cadence.WorkflowExecutionInfo;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.api.v1.Domain;
import com.uber.cadence.api.v1.ExternalExecutionInfo;
import com.uber.cadence.api.v1.Failure;
import com.uber.cadence.api.v1.ParentExecutionInfo;
import com.uber.cadence.api.v1.Payload;
import com.uber.cadence.internal.compatibility.thrift.EnumMapper;
import com.uber.cadence.internal.compatibility.thrift.Helpers;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TypeMapper {
    TypeMapper() {
    }

    static byte[] payload(Payload t) {
        if (t == null || t == Payload.getDefaultInstance()) {
            return null;
        }
        if (t.getData() == null || t.getData().size() == 0) {
            return new byte[0];
        }
        return Helpers.byteStringToArray(t.getData());
    }

    static String failureReason(Failure t) {
        if (t == null || t == Failure.getDefaultInstance()) {
            return null;
        }
        return t.getReason();
    }

    static byte[] failureDetails(Failure t) {
        if (t == null || t == Failure.getDefaultInstance()) {
            return null;
        }
        return Helpers.byteStringToArray(t.getDetails());
    }

    static WorkflowExecution workflowExecution(com.uber.cadence.api.v1.WorkflowExecution t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecution.getDefaultInstance()) {
            return null;
        }
        WorkflowExecution we = new WorkflowExecution();
        we.setWorkflowId(t.getWorkflowId());
        we.setRunId(t.getRunId());
        return we;
    }

    static String workflowId(com.uber.cadence.api.v1.WorkflowExecution t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecution.getDefaultInstance()) {
            return null;
        }
        return t.getWorkflowId();
    }

    static String runId(com.uber.cadence.api.v1.WorkflowExecution t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecution.getDefaultInstance()) {
            return null;
        }
        return t.getRunId();
    }

    static ActivityType activityType(com.uber.cadence.api.v1.ActivityType t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityType.getDefaultInstance()) {
            return null;
        }
        ActivityType activityType = new ActivityType();
        activityType.setName(t.getName());
        return activityType;
    }

    static WorkflowType workflowType(com.uber.cadence.api.v1.WorkflowType t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowType.getDefaultInstance()) {
            return null;
        }
        WorkflowType wt = new WorkflowType();
        wt.setName(t.getName());
        return wt;
    }

    static TaskList taskList(com.uber.cadence.api.v1.TaskList t) {
        if (t == null || t == com.uber.cadence.api.v1.TaskList.getDefaultInstance()) {
            return null;
        }
        TaskList taskList = new TaskList();
        taskList.setName(t.getName());
        taskList.setKind(EnumMapper.taskListKind(t.getKind()));
        return taskList;
    }

    static RetryPolicy retryPolicy(com.uber.cadence.api.v1.RetryPolicy t) {
        if (t == null || t == com.uber.cadence.api.v1.RetryPolicy.getDefaultInstance()) {
            return null;
        }
        RetryPolicy res = new RetryPolicy();
        res.setInitialIntervalInSeconds(Helpers.durationToSeconds(t.getInitialInterval()));
        res.setBackoffCoefficient(t.getBackoffCoefficient());
        res.setMaximumIntervalInSeconds(Helpers.durationToSeconds(t.getMaximumInterval()));
        res.setMaximumAttempts(t.getMaximumAttempts());
        res.setNonRetriableErrorReasons((List<String>)t.getNonRetryableErrorReasonsList());
        res.setExpirationIntervalInSeconds(Helpers.durationToSeconds(t.getExpirationInterval()));
        return res;
    }

    static Header header(com.uber.cadence.api.v1.Header t) {
        if (t == null || t == com.uber.cadence.api.v1.Header.getDefaultInstance()) {
            return null;
        }
        Header res = new Header();
        res.setFields(TypeMapper.payloadMap(t.getFieldsMap()));
        return res;
    }

    static Memo memo(com.uber.cadence.api.v1.Memo t) {
        if (t == null || t == com.uber.cadence.api.v1.Memo.getDefaultInstance()) {
            return null;
        }
        Memo res = new Memo();
        res.setFields(TypeMapper.payloadMap(t.getFieldsMap()));
        return res;
    }

    static SearchAttributes searchAttributes(com.uber.cadence.api.v1.SearchAttributes t) {
        if (t == null || t.getAllFields().size() == 0 || t == com.uber.cadence.api.v1.SearchAttributes.getDefaultInstance()) {
            return null;
        }
        SearchAttributes res = new SearchAttributes();
        res.setIndexedFields(TypeMapper.payloadMap(t.getIndexedFieldsMap()));
        return res;
    }

    static BadBinaries badBinaries(com.uber.cadence.api.v1.BadBinaries t) {
        if (t == null || t == com.uber.cadence.api.v1.BadBinaries.getDefaultInstance()) {
            return null;
        }
        BadBinaries badBinaries = new BadBinaries();
        badBinaries.setBinaries(TypeMapper.badBinaryInfoMap(t.getBinariesMap()));
        return badBinaries;
    }

    static BadBinaryInfo badBinaryInfo(com.uber.cadence.api.v1.BadBinaryInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.BadBinaryInfo.getDefaultInstance()) {
            return null;
        }
        BadBinaryInfo res = new BadBinaryInfo();
        res.setReason(t.getReason());
        res.setOperator(t.getOperator());
        res.setCreatedTimeNano(Helpers.timeToUnixNano(t.getCreatedTime()));
        return res;
    }

    static Map<String, BadBinaryInfo> badBinaryInfoMap(Map<String, com.uber.cadence.api.v1.BadBinaryInfo> t) {
        if (t == null) {
            return null;
        }
        HashMap<String, BadBinaryInfo> v = new HashMap<String, BadBinaryInfo>();
        for (String key : t.keySet()) {
            v.put(key, TypeMapper.badBinaryInfo(t.get(key)));
        }
        return v;
    }

    static WorkflowQuery workflowQuery(com.uber.cadence.api.v1.WorkflowQuery t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowQuery.getDefaultInstance()) {
            return null;
        }
        WorkflowQuery res = new WorkflowQuery();
        res.setQueryType(t.getQueryType());
        res.setQueryArgs(TypeMapper.payload(t.getQueryArgs()));
        return res;
    }

    static Map<String, ByteBuffer> payloadMap(Map<String, Payload> t) {
        if (t == null) {
            return null;
        }
        HashMap<String, ByteBuffer> v = new HashMap<String, ByteBuffer>();
        for (String key : t.keySet()) {
            v.put(key, ByteBuffer.wrap(TypeMapper.payload(t.get(key))));
        }
        return v;
    }

    static List<ClusterReplicationConfiguration> clusterReplicationConfigurationArray(List<com.uber.cadence.api.v1.ClusterReplicationConfiguration> t) {
        if (t == null) {
            return null;
        }
        ArrayList<ClusterReplicationConfiguration> v = new ArrayList<ClusterReplicationConfiguration>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.clusterReplicationConfiguration(t.get(i)));
        }
        return v;
    }

    static ClusterReplicationConfiguration clusterReplicationConfiguration(com.uber.cadence.api.v1.ClusterReplicationConfiguration t) {
        if (t == null || t == com.uber.cadence.api.v1.ClusterReplicationConfiguration.getDefaultInstance()) {
            return null;
        }
        ClusterReplicationConfiguration res = new ClusterReplicationConfiguration();
        res.setClusterName(t.getClusterName());
        return res;
    }

    static DataBlob dataBlob(com.uber.cadence.api.v1.DataBlob t) {
        if (t == null || t == com.uber.cadence.api.v1.DataBlob.getDefaultInstance()) {
            return null;
        }
        DataBlob dataBlob = new DataBlob();
        dataBlob.setEncodingType(EnumMapper.encodingType(t.getEncodingType()));
        dataBlob.setData(Helpers.byteStringToArray(t.getData()));
        return dataBlob;
    }

    static long externalInitiatedId(ExternalExecutionInfo t) {
        return t.getInitiatedId();
    }

    static WorkflowExecution externalWorkflowExecution(ExternalExecutionInfo t) {
        if (t == null || t == ExternalExecutionInfo.getDefaultInstance()) {
            return null;
        }
        return TypeMapper.workflowExecution(t.getWorkflowExecution());
    }

    static ResetPoints resetPoints(com.uber.cadence.api.v1.ResetPoints t) {
        if (t == null || t == com.uber.cadence.api.v1.ResetPoints.getDefaultInstance()) {
            return null;
        }
        ResetPoints res = new ResetPoints();
        res.setPoints(TypeMapper.resetPointInfoArray(t.getPointsList()));
        return res;
    }

    static ResetPointInfo resetPointInfo(com.uber.cadence.api.v1.ResetPointInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.ResetPointInfo.getDefaultInstance()) {
            return null;
        }
        ResetPointInfo res = new ResetPointInfo();
        res.setBinaryChecksum(t.getBinaryChecksum());
        res.setRunId(t.getRunId());
        res.setFirstDecisionCompletedId(t.getFirstDecisionCompletedId());
        res.setCreatedTimeNano(Helpers.timeToUnixNano(t.getCreatedTime()));
        res.setExpiringTimeNano(Helpers.timeToUnixNano(t.getExpiringTime()));
        res.setResettable(t.getResettable());
        return res;
    }

    static PollerInfo pollerInfo(com.uber.cadence.api.v1.PollerInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.PollerInfo.getDefaultInstance()) {
            return null;
        }
        PollerInfo res = new PollerInfo();
        res.setLastAccessTime(Helpers.timeToUnixNano(t.getLastAccessTime()));
        res.setIdentity(t.getIdentity());
        res.setRatePerSecond(t.getRatePerSecond());
        return res;
    }

    static TaskListStatus taskListStatus(com.uber.cadence.api.v1.TaskListStatus t) {
        if (t == null || t == com.uber.cadence.api.v1.TaskListStatus.getDefaultInstance()) {
            return null;
        }
        TaskListStatus res = new TaskListStatus();
        res.setBacklogCountHint(t.getBacklogCountHint());
        res.setReadLevel(t.getReadLevel());
        res.setAckLevel(t.getAckLevel());
        res.setRatePerSecond(t.getRatePerSecond());
        res.setTaskIDBlock(TypeMapper.taskIdBlock(t.getTaskIdBlock()));
        return res;
    }

    static TaskIDBlock taskIdBlock(com.uber.cadence.api.v1.TaskIDBlock t) {
        if (t == null || t == com.uber.cadence.api.v1.TaskIDBlock.getDefaultInstance()) {
            return null;
        }
        TaskIDBlock res = new TaskIDBlock();
        res.setStartID(t.getStartId());
        res.setEndID(t.getEndId());
        return res;
    }

    static WorkflowExecutionConfiguration workflowExecutionConfiguration(com.uber.cadence.api.v1.WorkflowExecutionConfiguration t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionConfiguration.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionConfiguration res = new WorkflowExecutionConfiguration();
        res.setTaskList(TypeMapper.taskList(t.getTaskList()));
        res.setExecutionStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getExecutionStartToCloseTimeout()));
        res.setTaskStartToCloseTimeoutSeconds(Helpers.durationToSeconds(t.getTaskStartToCloseTimeout()));
        return res;
    }

    static WorkflowExecutionInfo workflowExecutionInfo(com.uber.cadence.api.v1.WorkflowExecutionInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.WorkflowExecutionInfo.getDefaultInstance()) {
            return null;
        }
        WorkflowExecutionInfo res = new WorkflowExecutionInfo();
        res.setExecution(TypeMapper.workflowExecution(t.getWorkflowExecution()));
        res.setType(TypeMapper.workflowType(t.getType()));
        res.setStartTime(Helpers.timeToUnixNano(t.getStartTime()));
        res.setCloseTime(Helpers.timeToUnixNano(t.getCloseTime()));
        res.setCloseStatus(EnumMapper.workflowExecutionCloseStatus(t.getCloseStatus()));
        res.setHistoryLength(t.getHistoryLength());
        res.setParentDomainId(TypeMapper.parentDomainId(t.getParentExecutionInfo()));
        res.setParentExecution(TypeMapper.parentWorkflowExecution(t.getParentExecutionInfo()));
        res.setExecutionTime(Helpers.timeToUnixNano(t.getExecutionTime()));
        res.setMemo(TypeMapper.memo(t.getMemo()));
        res.setSearchAttributes(TypeMapper.searchAttributes(t.getSearchAttributes()));
        res.setAutoResetPoints(TypeMapper.resetPoints(t.getAutoResetPoints()));
        res.setTaskList(t.getTaskList());
        res.setIsCron(t.getIsCron());
        return res;
    }

    static String parentDomainId(ParentExecutionInfo t) {
        if (t == null || t == ParentExecutionInfo.getDefaultInstance()) {
            return null;
        }
        return t.getDomainId();
    }

    static String parentDomainName(ParentExecutionInfo t) {
        if (t == null || t == ParentExecutionInfo.getDefaultInstance()) {
            return null;
        }
        return t.getDomainName();
    }

    static long parentInitiatedId(ParentExecutionInfo t) {
        if (t == null || t == ParentExecutionInfo.getDefaultInstance()) {
            return -1L;
        }
        return t.getInitiatedId();
    }

    static WorkflowExecution parentWorkflowExecution(ParentExecutionInfo t) {
        if (t == null || t == ParentExecutionInfo.getDefaultInstance()) {
            return null;
        }
        return TypeMapper.workflowExecution(t.getWorkflowExecution());
    }

    static PendingActivityInfo pendingActivityInfo(com.uber.cadence.api.v1.PendingActivityInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.PendingActivityInfo.getDefaultInstance()) {
            return null;
        }
        PendingActivityInfo res = new PendingActivityInfo();
        res.setActivityID(t.getActivityId());
        res.setActivityType(TypeMapper.activityType(t.getActivityType()));
        res.setState(EnumMapper.pendingActivityState(t.getState()));
        res.setHeartbeatDetails(TypeMapper.payload(t.getHeartbeatDetails()));
        res.setLastHeartbeatTimestamp(Helpers.timeToUnixNano(t.getLastHeartbeatTime()));
        res.setLastStartedTimestamp(Helpers.timeToUnixNano(t.getLastStartedTime()));
        res.setAttempt(t.getAttempt());
        res.setMaximumAttempts(t.getMaximumAttempts());
        res.setScheduledTimestamp(Helpers.timeToUnixNano(t.getScheduledTime()));
        res.setExpirationTimestamp(Helpers.timeToUnixNano(t.getExpirationTime()));
        res.setLastFailureReason(TypeMapper.failureReason(t.getLastFailure()));
        res.setLastFailureDetails(TypeMapper.failureDetails(t.getLastFailure()));
        res.setLastWorkerIdentity(t.getLastWorkerIdentity());
        return res;
    }

    static PendingChildExecutionInfo pendingChildExecutionInfo(com.uber.cadence.api.v1.PendingChildExecutionInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.PendingChildExecutionInfo.getDefaultInstance()) {
            return null;
        }
        PendingChildExecutionInfo res = new PendingChildExecutionInfo();
        res.setWorkflowID(TypeMapper.workflowId(t.getWorkflowExecution()));
        res.setRunID(TypeMapper.runId(t.getWorkflowExecution()));
        res.setWorkflowTypName(t.getWorkflowTypeName());
        res.setInitiatedID(t.getInitiatedId());
        res.setParentClosePolicy(EnumMapper.parentClosePolicy(t.getParentClosePolicy()));
        return res;
    }

    static PendingDecisionInfo pendingDecisionInfo(com.uber.cadence.api.v1.PendingDecisionInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.PendingDecisionInfo.getDefaultInstance()) {
            return null;
        }
        PendingDecisionInfo res = new PendingDecisionInfo();
        res.setState(EnumMapper.pendingDecisionState(t.getState()));
        res.setScheduledTimestamp(Helpers.timeToUnixNano(t.getScheduledTime()));
        res.setStartedTimestamp(Helpers.timeToUnixNano(t.getStartedTime()));
        res.setAttempt(t.getAttempt());
        res.setOriginalScheduledTimestamp(Helpers.timeToUnixNano(t.getOriginalScheduledTime()));
        return res;
    }

    static ActivityLocalDispatchInfo activityLocalDispatchInfo(com.uber.cadence.api.v1.ActivityLocalDispatchInfo t) {
        if (t == null || t == com.uber.cadence.api.v1.ActivityLocalDispatchInfo.getDefaultInstance()) {
            return null;
        }
        ActivityLocalDispatchInfo res = new ActivityLocalDispatchInfo();
        res.setActivityId(t.getActivityId());
        res.setScheduledTimestamp(Helpers.timeToUnixNano(t.getScheduledTime()));
        res.setStartedTimestamp(Helpers.timeToUnixNano(t.getStartedTime()));
        res.setScheduledTimestampOfThisAttempt(Helpers.timeToUnixNano(t.getScheduledTimeOfThisAttempt()));
        res.setTaskToken(Helpers.byteStringToArray(t.getTaskToken()));
        return res;
    }

    static SupportedClientVersions supportedClientVersions(com.uber.cadence.api.v1.SupportedClientVersions t) {
        if (t == null || t == com.uber.cadence.api.v1.SupportedClientVersions.getDefaultInstance()) {
            return null;
        }
        SupportedClientVersions res = new SupportedClientVersions();
        res.setGoSdk(t.getGoSdk());
        res.setJavaSdk(t.getJavaSdk());
        return res;
    }

    static DescribeDomainResponse describeDomainResponseDomain(Domain t) {
        if (t == null || t == Domain.getDefaultInstance()) {
            return null;
        }
        DescribeDomainResponse res = new DescribeDomainResponse();
        DomainInfo domainInfo = new DomainInfo();
        res.setDomainInfo(domainInfo);
        domainInfo.setName(t.getName());
        domainInfo.setStatus(EnumMapper.domainStatus(t.getStatus()));
        domainInfo.setDescription(t.getDescription());
        domainInfo.setOwnerEmail(t.getOwnerEmail());
        domainInfo.setData(t.getDataMap());
        domainInfo.setUuid(t.getId());
        DomainConfiguration domainConfiguration = new DomainConfiguration();
        domainConfiguration.setWorkflowExecutionRetentionPeriodInDays(Helpers.durationToDays(t.getWorkflowExecutionRetentionPeriod()));
        domainConfiguration.setEmitMetric(true);
        domainConfiguration.setBadBinaries(TypeMapper.badBinaries(t.getBadBinaries()));
        domainConfiguration.setHistoryArchivalStatus(EnumMapper.archivalStatus(t.getHistoryArchivalStatus()));
        domainConfiguration.setHistoryArchivalURI(t.getHistoryArchivalUri());
        domainConfiguration.setVisibilityArchivalStatus(EnumMapper.archivalStatus(t.getVisibilityArchivalStatus()));
        domainConfiguration.setVisibilityArchivalURI(t.getVisibilityArchivalUri());
        DomainReplicationConfiguration domainReplicationConfiguration = new DomainReplicationConfiguration();
        domainReplicationConfiguration.setActiveClusterName(t.getActiveClusterName());
        domainReplicationConfiguration.setClusters(TypeMapper.clusterReplicationConfigurationArray(t.getClustersList()));
        res.setFailoverVersion(t.getFailoverVersion());
        res.setIsGlobalDomain(t.getIsGlobalDomain());
        return res;
    }

    static TaskListPartitionMetadata taskListPartitionMetadata(com.uber.cadence.api.v1.TaskListPartitionMetadata t) {
        if (t == null || t == com.uber.cadence.api.v1.TaskListPartitionMetadata.getDefaultInstance()) {
            return null;
        }
        TaskListPartitionMetadata res = new TaskListPartitionMetadata();
        res.setKey(t.getKey());
        res.setOwnerHostName(t.getOwnerHostName());
        return res;
    }

    static QueryRejected queryRejected(com.uber.cadence.api.v1.QueryRejected t) {
        if (t == null || t == com.uber.cadence.api.v1.QueryRejected.getDefaultInstance()) {
            return null;
        }
        QueryRejected res = new QueryRejected();
        res.setCloseStatus(EnumMapper.workflowExecutionCloseStatus(t.getCloseStatus()));
        return res;
    }

    static List<PollerInfo> pollerInfoArray(List<com.uber.cadence.api.v1.PollerInfo> t) {
        if (t == null) {
            return null;
        }
        ArrayList<PollerInfo> v = new ArrayList<PollerInfo>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.pollerInfo(t.get(i)));
        }
        return v;
    }

    static List<ResetPointInfo> resetPointInfoArray(List<com.uber.cadence.api.v1.ResetPointInfo> t) {
        if (t == null) {
            return null;
        }
        ArrayList<ResetPointInfo> v = new ArrayList<ResetPointInfo>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.resetPointInfo(t.get(i)));
        }
        return v;
    }

    static List<PendingActivityInfo> pendingActivityInfoArray(List<com.uber.cadence.api.v1.PendingActivityInfo> t) {
        if (t == null) {
            return null;
        }
        ArrayList<PendingActivityInfo> v = new ArrayList<PendingActivityInfo>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.pendingActivityInfo(t.get(i)));
        }
        return v;
    }

    static List<PendingChildExecutionInfo> pendingChildExecutionInfoArray(List<com.uber.cadence.api.v1.PendingChildExecutionInfo> t) {
        if (t == null) {
            return null;
        }
        ArrayList<PendingChildExecutionInfo> v = new ArrayList<PendingChildExecutionInfo>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.pendingChildExecutionInfo(t.get(i)));
        }
        return v;
    }

    static Map<String, IndexedValueType> indexedValueTypeMap(Map<String, com.uber.cadence.api.v1.IndexedValueType> t) {
        if (t == null) {
            return null;
        }
        HashMap<String, IndexedValueType> v = new HashMap<String, IndexedValueType>();
        for (String key : t.keySet()) {
            v.put(key, EnumMapper.indexedValueType(t.get(key)));
        }
        return v;
    }

    static List<DataBlob> dataBlobArray(List<com.uber.cadence.api.v1.DataBlob> t) {
        if (t == null || t.size() == 0) {
            return null;
        }
        ArrayList<DataBlob> v = new ArrayList<DataBlob>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.dataBlob(t.get(i)));
        }
        return v;
    }

    static List<WorkflowExecutionInfo> workflowExecutionInfoArray(List<com.uber.cadence.api.v1.WorkflowExecutionInfo> t) {
        if (t == null) {
            return null;
        }
        ArrayList<WorkflowExecutionInfo> v = new ArrayList<WorkflowExecutionInfo>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.workflowExecutionInfo(t.get(i)));
        }
        return v;
    }

    static List<DescribeDomainResponse> describeDomainResponseArray(List<Domain> t) {
        if (t == null) {
            return null;
        }
        ArrayList<DescribeDomainResponse> v = new ArrayList<DescribeDomainResponse>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.describeDomainResponseDomain(t.get(i)));
        }
        return v;
    }

    static List<TaskListPartitionMetadata> taskListPartitionMetadataArray(List<com.uber.cadence.api.v1.TaskListPartitionMetadata> t) {
        if (t == null) {
            return null;
        }
        ArrayList<TaskListPartitionMetadata> v = new ArrayList<TaskListPartitionMetadata>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.taskListPartitionMetadata(t.get(i)));
        }
        return v;
    }

    static Map<String, WorkflowQuery> workflowQueryMap(Map<String, com.uber.cadence.api.v1.WorkflowQuery> t) {
        if (t == null) {
            return null;
        }
        HashMap<String, WorkflowQuery> v = new HashMap<String, WorkflowQuery>();
        for (String key : t.keySet()) {
            v.put(key, TypeMapper.workflowQuery(t.get(key)));
        }
        return v;
    }

    static Map<String, ActivityLocalDispatchInfo> activityLocalDispatchInfoMap(Map<String, com.uber.cadence.api.v1.ActivityLocalDispatchInfo> t) {
        if (t == null) {
            return null;
        }
        HashMap<String, ActivityLocalDispatchInfo> v = new HashMap<String, ActivityLocalDispatchInfo>();
        for (String key : t.keySet()) {
            v.put(key, TypeMapper.activityLocalDispatchInfo(t.get(key)));
        }
        return v;
    }
}

