/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.external;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.external.ManualActivityCompletionClient;
import com.uber.cadence.internal.external.ManualActivityCompletionClientFactory;
import com.uber.cadence.internal.external.ManualActivityCompletionClientImpl;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class ManualActivityCompletionClientFactoryImpl
extends ManualActivityCompletionClientFactory {
    private final IWorkflowService service;
    private final DataConverter dataConverter;
    private final String domain;
    private final Scope metricsScope;

    public ManualActivityCompletionClientFactoryImpl(IWorkflowService service, String domain, DataConverter dataConverter, Scope metricsScope) {
        this.service = Objects.requireNonNull(service);
        this.domain = Objects.requireNonNull(domain);
        this.dataConverter = Objects.requireNonNull(dataConverter);
        ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"Domain", (Object)domain).build();
        this.metricsScope = metricsScope.tagged((Map)tags);
    }

    public IWorkflowService getService() {
        return this.service;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    @Override
    public ManualActivityCompletionClient getClient(byte[] taskToken) {
        if (taskToken == null || taskToken.length == 0) {
            throw new IllegalArgumentException("null or empty task token");
        }
        return new ManualActivityCompletionClientImpl(this.service, this.domain, taskToken, this.dataConverter, this.metricsScope);
    }

    @Override
    public ManualActivityCompletionClient getClient(WorkflowExecution execution, String activityId) {
        if (execution == null) {
            throw new IllegalArgumentException("null execution");
        }
        if (activityId == null) {
            throw new IllegalArgumentException("null activityId");
        }
        return new ManualActivityCompletionClientImpl(this.service, this.domain, execution, activityId, this.dataConverter, this.metricsScope);
    }
}

