/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.ActivityTaskCanceledEventAttributes;
import com.uber.cadence.ActivityTaskCompletedEventAttributes;
import com.uber.cadence.ActivityTaskFailedEventAttributes;
import com.uber.cadence.ActivityTaskTimedOutEventAttributes;
import com.uber.cadence.ActivityType;
import com.uber.cadence.Header;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.TaskList;
import com.uber.cadence.TimeoutType;
import com.uber.cadence.internal.common.RetryParameters;
import com.uber.cadence.internal.replay.ActivityTaskFailedException;
import com.uber.cadence.internal.replay.ActivityTaskTimeoutException;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.ExecuteActivityParameters;
import com.uber.cadence.internal.replay.NonDeterminisicWorkflowError;
import com.uber.cadence.internal.replay.OpenRequestInfo;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class ActivityDecisionContext {
    private final DecisionsHelper decisions;
    private final Map<Long, OpenRequestInfo<byte[], ActivityType>> scheduledActivities = new HashMap<Long, OpenRequestInfo<byte[], ActivityType>>();

    ActivityDecisionContext(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    public boolean isActivityScheduledWithRetryOptions() {
        return this.decisions.isActivityScheduledWithRetryOptions();
    }

    Consumer<Exception> scheduleActivityTask(ExecuteActivityParameters parameters, BiConsumer<byte[], Exception> callback) {
        RetryParameters retryParameters;
        OpenRequestInfo<byte[], ActivityType> context = new OpenRequestInfo<byte[], ActivityType>(parameters.getActivityType());
        ScheduleActivityTaskDecisionAttributes attributes = new ScheduleActivityTaskDecisionAttributes();
        attributes.setActivityType(parameters.getActivityType());
        attributes.setInput(parameters.getInput());
        if (parameters.getHeartbeatTimeoutSeconds() > 0L) {
            attributes.setHeartbeatTimeoutSeconds((int)parameters.getHeartbeatTimeoutSeconds());
        }
        attributes.setScheduleToCloseTimeoutSeconds((int)parameters.getScheduleToCloseTimeoutSeconds());
        attributes.setScheduleToStartTimeoutSeconds((int)parameters.getScheduleToStartTimeoutSeconds());
        attributes.setStartToCloseTimeoutSeconds((int)parameters.getStartToCloseTimeoutSeconds());
        String activityId = parameters.getActivityId();
        if (activityId == null) {
            activityId = String.valueOf(this.decisions.getAndIncrementNextId());
        }
        attributes.setActivityId(activityId);
        String taskList = parameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            TaskList tl = new TaskList();
            tl.setName(taskList);
            attributes.setTaskList(tl);
        }
        if ((retryParameters = parameters.getRetryParameters()) != null) {
            attributes.setRetryPolicy(retryParameters.toRetryPolicy());
        }
        attributes.setHeader(this.toHeaderThrift(parameters.getContext()));
        long scheduledEventId = this.decisions.scheduleActivityTask(attributes);
        context.setCompletionHandle(callback);
        this.scheduledActivities.put(scheduledEventId, context);
        return new ActivityCancellationHandler(scheduledEventId, attributes.getActivityId(), callback);
    }

    void handleActivityTaskCanceled(HistoryEvent event) {
        ActivityTaskCanceledEventAttributes attributes = event.getActivityTaskCanceledEventAttributes();
        if (this.decisions.handleActivityTaskCanceled(event)) {
            CancellationException e = new CancellationException();
            OpenRequestInfo<byte[], ActivityType> scheduled = this.scheduledActivities.remove(attributes.getScheduledEventId());
            if (scheduled != null) {
                BiConsumer<byte[], Exception> completionHandle = scheduled.getCompletionCallback();
                completionHandle.accept(null, e);
            }
        }
    }

    void handleActivityTaskCompleted(HistoryEvent event) {
        ActivityTaskCompletedEventAttributes attributes = event.getActivityTaskCompletedEventAttributes();
        if (this.decisions.handleActivityTaskClosed(attributes.getScheduledEventId())) {
            OpenRequestInfo<byte[], ActivityType> scheduled = this.scheduledActivities.remove(attributes.getScheduledEventId());
            if (scheduled != null) {
                byte[] result = attributes.getResult();
                BiConsumer<byte[], Exception> completionHandle = scheduled.getCompletionCallback();
                completionHandle.accept(result, null);
            } else {
                throw new NonDeterminisicWorkflowError("Trying to complete activity event " + attributes.getScheduledEventId() + " that is not in scheduledActivities");
            }
        }
    }

    void handleActivityTaskFailed(HistoryEvent event) {
        OpenRequestInfo<byte[], ActivityType> scheduled;
        ActivityTaskFailedEventAttributes attributes = event.getActivityTaskFailedEventAttributes();
        if (this.decisions.handleActivityTaskClosed(attributes.getScheduledEventId()) && (scheduled = this.scheduledActivities.remove(attributes.getScheduledEventId())) != null) {
            String reason = attributes.getReason();
            byte[] details = attributes.getDetails();
            ActivityTaskFailedException failure = new ActivityTaskFailedException(event.getEventId(), scheduled.getUserContext(), null, reason, details);
            BiConsumer<byte[], Exception> completionHandle = scheduled.getCompletionCallback();
            completionHandle.accept(null, failure);
        }
    }

    void handleActivityTaskTimedOut(HistoryEvent event) {
        OpenRequestInfo<byte[], ActivityType> scheduled;
        ActivityTaskTimedOutEventAttributes attributes = event.getActivityTaskTimedOutEventAttributes();
        if (this.decisions.handleActivityTaskClosed(attributes.getScheduledEventId()) && (scheduled = this.scheduledActivities.remove(attributes.getScheduledEventId())) != null) {
            TimeoutType timeoutType = attributes.getTimeoutType();
            byte[] details = attributes.getDetails();
            ActivityTaskTimeoutException failure = new ActivityTaskTimeoutException(event.getEventId(), scheduled.getUserContext(), null, timeoutType, details);
            BiConsumer<byte[], Exception> completionHandle = scheduled.getCompletionCallback();
            completionHandle.accept(null, failure);
        }
    }

    private Header toHeaderThrift(Map<String, byte[]> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        HashMap<String, ByteBuffer> fields = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, byte[]> item : headers.entrySet()) {
            fields.put(item.getKey(), ByteBuffer.wrap(item.getValue()));
        }
        Header headerThrift = new Header();
        headerThrift.setFields(fields);
        return headerThrift;
    }

    private final class ActivityCancellationHandler
    implements Consumer<Exception> {
        private final long scheduledEventId;
        private final String activityId;
        private final BiConsumer<byte[], Exception> callback;

        private ActivityCancellationHandler(long scheduledEventId, String activityId, BiConsumer<byte[], Exception> callaback) {
            this.scheduledEventId = scheduledEventId;
            this.activityId = activityId;
            this.callback = callaback;
        }

        @Override
        public void accept(Exception cause) {
            if (!ActivityDecisionContext.this.scheduledActivities.containsKey(this.scheduledEventId)) {
                return;
            }
            ActivityDecisionContext.this.decisions.requestCancelActivityTask(this.scheduledEventId, () -> {
                OpenRequestInfo scheduled = (OpenRequestInfo)ActivityDecisionContext.this.scheduledActivities.remove(this.scheduledEventId);
                if (scheduled == null) {
                    throw new IllegalArgumentException(String.format("Activity with activityId=%s and scheduledEventId=%d wasn't found", this.activityId, this.scheduledEventId));
                }
                this.callback.accept(null, new CancellationException("Cancelled by request"));
            });
        }
    }
}

