/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.RequestCancelActivityTaskDecisionAttributes;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.internal.replay.DecisionId;
import com.uber.cadence.internal.replay.DecisionState;
import com.uber.cadence.internal.replay.DecisionStateMachineBase;

final class ActivityDecisionStateMachine
extends DecisionStateMachineBase {
    private ScheduleActivityTaskDecisionAttributes scheduleAttributes;

    public ActivityDecisionStateMachine(DecisionId id, ScheduleActivityTaskDecisionAttributes scheduleAttributes) {
        super(id);
        this.scheduleAttributes = scheduleAttributes;
    }

    ActivityDecisionStateMachine(DecisionId id, ScheduleActivityTaskDecisionAttributes scheduleAttributes, DecisionState state) {
        super(id, state);
        this.scheduleAttributes = scheduleAttributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createScheduleActivityTaskDecision();
            }
            case CANCELED_AFTER_INITIATED: {
                return this.createRequestCancelActivityTaskDecision();
            }
        }
        return null;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_INITIATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.INITIATED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    private Decision createRequestCancelActivityTaskDecision() {
        RequestCancelActivityTaskDecisionAttributes tryCancel = new RequestCancelActivityTaskDecisionAttributes();
        tryCancel.setActivityId(this.scheduleAttributes.getActivityId());
        Decision decision = new Decision();
        decision.setRequestCancelActivityTaskDecisionAttributes(tryCancel);
        decision.setDecisionType(DecisionType.RequestCancelActivityTask);
        return decision;
    }

    private Decision createScheduleActivityTaskDecision() {
        Decision decision = new Decision();
        decision.setScheduleActivityTaskDecisionAttributes(this.scheduleAttributes);
        decision.setDecisionType(DecisionType.ScheduleActivityTask);
        return decision;
    }
}

