/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.EventType;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryResultType;
import com.uber.cadence.TimerFiredEventAttributes;
import com.uber.cadence.WorkflowExecutionSignaledEventAttributes;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.WorkflowQueryResult;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.OptionsUtils;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import com.uber.cadence.internal.replay.Decider;
import com.uber.cadence.internal.replay.DecisionContextImpl;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.HistoryHelper;
import com.uber.cadence.internal.replay.ReplayWorkflow;
import com.uber.cadence.internal.worker.DecisionTaskWithHistoryIterator;
import com.uber.cadence.internal.worker.LocalActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.WorkflowExecutionException;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.worker.NonDeterministicWorkflowPolicy;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplayDecider
implements Decider {
    private static final Logger log = LoggerFactory.getLogger(ReplayDecider.class);
    private static final int MAXIMUM_PAGE_SIZE = 10000;
    private final DecisionsHelper decisionsHelper;
    private final DecisionContextImpl context;
    private final IWorkflowService service;
    private final ReplayWorkflow workflow;
    private boolean cancelRequested;
    private boolean completed;
    private WorkflowExecutionException failure;
    private long wakeUpTime;
    private Consumer<Exception> timerCancellationHandler;
    private final Scope metricsScope;
    private final long wfStartTimeNanos;
    private final WorkflowExecutionStartedEventAttributes startedEvent;
    private final Lock lock = new ReentrantLock();
    private final Consumer<HistoryEvent> localActivityCompletionSink;

    ReplayDecider(IWorkflowService service, String domain, WorkflowType workflowType, ReplayWorkflow workflow, DecisionsHelper decisionsHelper, SingleWorkerOptions options, BiFunction<LocalActivityWorker.Task, java.time.Duration, Boolean> laTaskPoller) {
        this.service = service;
        this.workflow = workflow;
        this.decisionsHelper = decisionsHelper;
        this.metricsScope = options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"WorkflowType", (Object)workflowType.getName()));
        PollForDecisionTaskResponse decisionTask = decisionsHelper.getTask();
        this.startedEvent = decisionTask.getHistory().getEvents().get(0).getWorkflowExecutionStartedEventAttributes();
        if (this.startedEvent == null) {
            throw new IllegalArgumentException("First event in the history is not WorkflowExecutionStarted");
        }
        this.wfStartTimeNanos = decisionTask.getHistory().getEvents().get(0).getTimestamp();
        this.context = new DecisionContextImpl(decisionsHelper, domain, decisionTask, this.startedEvent, options, laTaskPoller, this);
        this.localActivityCompletionSink = historyEvent -> {
            this.lock.lock();
            try {
                this.processEvent((HistoryEvent)historyEvent);
            }
            finally {
                this.lock.unlock();
            }
        };
    }

    Lock getLock() {
        return this.lock;
    }

    private void handleWorkflowExecutionStarted(HistoryEvent event) {
        this.workflow.start(event, this.context);
    }

    private void processEvent(HistoryEvent event) {
        EventType eventType = event.getEventType();
        switch (eventType) {
            case ActivityTaskCanceled: {
                this.context.handleActivityTaskCanceled(event);
                break;
            }
            case ActivityTaskCompleted: {
                this.context.handleActivityTaskCompleted(event);
                break;
            }
            case ActivityTaskFailed: {
                this.context.handleActivityTaskFailed(event);
                break;
            }
            case ActivityTaskStarted: {
                this.decisionsHelper.handleActivityTaskStarted(event);
                break;
            }
            case ActivityTaskTimedOut: {
                this.context.handleActivityTaskTimedOut(event);
                break;
            }
            case ExternalWorkflowExecutionCancelRequested: {
                this.context.handleChildWorkflowExecutionCancelRequested(event);
                this.decisionsHelper.handleExternalWorkflowExecutionCancelRequested(event);
                break;
            }
            case ChildWorkflowExecutionCanceled: {
                this.context.handleChildWorkflowExecutionCanceled(event);
                break;
            }
            case ChildWorkflowExecutionCompleted: {
                this.context.handleChildWorkflowExecutionCompleted(event);
                break;
            }
            case ChildWorkflowExecutionFailed: {
                this.context.handleChildWorkflowExecutionFailed(event);
                break;
            }
            case ChildWorkflowExecutionStarted: {
                this.context.handleChildWorkflowExecutionStarted(event);
                break;
            }
            case ChildWorkflowExecutionTerminated: {
                this.context.handleChildWorkflowExecutionTerminated(event);
                break;
            }
            case ChildWorkflowExecutionTimedOut: {
                this.context.handleChildWorkflowExecutionTimedOut(event);
                break;
            }
            case DecisionTaskCompleted: {
                break;
            }
            case DecisionTaskScheduled: {
                break;
            }
            case DecisionTaskStarted: {
                throw new IllegalArgumentException("not expected");
            }
            case DecisionTaskTimedOut: {
                break;
            }
            case ExternalWorkflowExecutionSignaled: {
                this.context.handleExternalWorkflowExecutionSignaled(event);
                break;
            }
            case StartChildWorkflowExecutionFailed: {
                this.context.handleStartChildWorkflowExecutionFailed(event);
                break;
            }
            case TimerFired: {
                this.handleTimerFired(event);
                break;
            }
            case WorkflowExecutionCancelRequested: {
                this.handleWorkflowExecutionCancelRequested(event);
                break;
            }
            case WorkflowExecutionSignaled: {
                this.handleWorkflowExecutionSignaled(event);
                break;
            }
            case WorkflowExecutionStarted: {
                this.handleWorkflowExecutionStarted(event);
                break;
            }
            case WorkflowExecutionTerminated: {
                break;
            }
            case WorkflowExecutionTimedOut: {
                break;
            }
            case ActivityTaskScheduled: {
                this.decisionsHelper.handleActivityTaskScheduled(event);
                break;
            }
            case ActivityTaskCancelRequested: {
                this.decisionsHelper.handleActivityTaskCancelRequested(event);
                break;
            }
            case RequestCancelActivityTaskFailed: {
                this.decisionsHelper.handleRequestCancelActivityTaskFailed(event);
                break;
            }
            case MarkerRecorded: {
                this.context.handleMarkerRecorded(event);
                break;
            }
            case WorkflowExecutionCompleted: {
                break;
            }
            case WorkflowExecutionFailed: {
                break;
            }
            case WorkflowExecutionCanceled: {
                break;
            }
            case WorkflowExecutionContinuedAsNew: {
                break;
            }
            case TimerStarted: {
                this.decisionsHelper.handleTimerStarted(event);
                break;
            }
            case TimerCanceled: {
                this.context.handleTimerCanceled(event);
                break;
            }
            case SignalExternalWorkflowExecutionInitiated: {
                this.decisionsHelper.handleSignalExternalWorkflowExecutionInitiated(event);
                break;
            }
            case SignalExternalWorkflowExecutionFailed: {
                this.context.handleSignalExternalWorkflowExecutionFailed(event);
                break;
            }
            case RequestCancelExternalWorkflowExecutionInitiated: {
                this.decisionsHelper.handleRequestCancelExternalWorkflowExecutionInitiated(event);
                break;
            }
            case RequestCancelExternalWorkflowExecutionFailed: {
                this.decisionsHelper.handleRequestCancelExternalWorkflowExecutionFailed(event);
                break;
            }
            case StartChildWorkflowExecutionInitiated: {
                this.decisionsHelper.handleStartChildWorkflowExecutionInitiated(event);
                break;
            }
            case CancelTimerFailed: {
                this.decisionsHelper.handleCancelTimerFailed(event);
                break;
            }
            case DecisionTaskFailed: {
                this.context.handleDecisionTaskFailed(event);
                break;
            }
            case UpsertWorkflowSearchAttributes: {
                this.context.handleUpsertSearchAttributes(event);
            }
        }
    }

    private void eventLoop() {
        if (this.completed) {
            return;
        }
        try {
            this.completed = this.workflow.eventLoop();
        }
        catch (Error e) {
            throw e;
        }
        catch (WorkflowExecutionException e) {
            this.failure = e;
            this.completed = true;
        }
        catch (CancellationException e) {
            if (!this.cancelRequested) {
                this.failure = this.workflow.mapUnexpectedException(e);
            }
            this.completed = true;
        }
        catch (Throwable e) {
            this.failure = this.workflow.mapUnexpectedException((Exception)e);
            this.completed = true;
        }
    }

    private void mayBeCompleteWorkflow() {
        if (this.completed) {
            this.completeWorkflow();
        } else {
            this.updateTimers();
        }
    }

    private void completeWorkflow() {
        if (this.failure != null) {
            this.decisionsHelper.failWorkflowExecution(this.failure);
            this.metricsScope.counter("cadence-workflow-failed").inc(1L);
        } else if (this.cancelRequested) {
            this.decisionsHelper.cancelWorkflowExecution();
            this.metricsScope.counter("cadence-workflow-canceled").inc(1L);
        } else {
            ContinueAsNewWorkflowExecutionParameters continueAsNewOnCompletion = this.context.getContinueAsNewOnCompletion();
            if (continueAsNewOnCompletion != null) {
                this.decisionsHelper.continueAsNewWorkflowExecution(continueAsNewOnCompletion);
                this.metricsScope.counter("cadence-workflow-continue-as-new").inc(1L);
            } else {
                byte[] workflowOutput = this.workflow.getOutput();
                this.decisionsHelper.completeWorkflowExecution(workflowOutput);
                this.metricsScope.counter("cadence-workflow-completed").inc(1L);
            }
        }
        long nanoTime = TimeUnit.NANOSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        Duration d = Duration.ofNanos((long)(nanoTime - this.wfStartTimeNanos));
        this.metricsScope.timer("cadence-workflow-endtoend-latency").record(d);
    }

    private void updateTimers() {
        long nextWakeUpTime = this.workflow.getNextWakeUpTime();
        if (nextWakeUpTime == 0L) {
            if (this.timerCancellationHandler != null) {
                this.timerCancellationHandler.accept(null);
                this.timerCancellationHandler = null;
            }
            this.wakeUpTime = nextWakeUpTime;
            return;
        }
        if (this.wakeUpTime == nextWakeUpTime && this.timerCancellationHandler != null) {
            return;
        }
        long delayMilliseconds = nextWakeUpTime - this.context.currentTimeMillis();
        if (delayMilliseconds < 0L) {
            throw new IllegalStateException("Negative delayMilliseconds=" + delayMilliseconds);
        }
        long delaySeconds = OptionsUtils.roundUpToSeconds(java.time.Duration.ofMillis(delayMilliseconds)).getSeconds();
        if (this.timerCancellationHandler != null) {
            this.timerCancellationHandler.accept(null);
            this.timerCancellationHandler = null;
        }
        this.wakeUpTime = nextWakeUpTime;
        this.timerCancellationHandler = this.context.createTimer(delaySeconds, t -> {});
    }

    private void handleWorkflowExecutionCancelRequested(HistoryEvent event) {
        this.context.setCancelRequested(true);
        String cause = event.getWorkflowExecutionCancelRequestedEventAttributes().getCause();
        this.workflow.cancel(cause);
        this.cancelRequested = true;
    }

    private void handleTimerFired(HistoryEvent event) {
        TimerFiredEventAttributes attributes = event.getTimerFiredEventAttributes();
        String timerId = attributes.getTimerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.context.handleTimerFired(attributes);
    }

    private void handleWorkflowExecutionSignaled(HistoryEvent event) {
        assert (event.getEventType() == EventType.WorkflowExecutionSignaled);
        WorkflowExecutionSignaledEventAttributes signalAttributes = event.getWorkflowExecutionSignaledEventAttributes();
        if (this.completed) {
            throw new IllegalStateException("Signal received after workflow is closed.");
        }
        this.workflow.handleSignal(signalAttributes.getSignalName(), signalAttributes.getInput(), event.getEventId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Decider.DecisionResult decide(PollForDecisionTaskResponse decisionTask) throws Throwable {
        this.lock.lock();
        try {
            AtomicReference queryResults = new AtomicReference();
            boolean forceCreateNewDecisionTask = this.decideImpl(decisionTask, () -> queryResults.set(this.getQueryResults(decisionTask.getQueries())));
            Decider.DecisionResult decisionResult = new Decider.DecisionResult(this.decisionsHelper.getDecisions(), (Map)queryResults.get(), forceCreateNewDecisionTask);
            return decisionResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map<String, WorkflowQueryResult> getQueryResults(Map<String, WorkflowQuery> queries) {
        if (queries == null) {
            return null;
        }
        return queries.entrySet().stream().collect(Collectors.toMap(q -> (String)q.getKey(), q -> this.queryWorkflow((WorkflowQuery)q.getValue())));
    }

    private WorkflowQueryResult queryWorkflow(WorkflowQuery query) {
        try {
            return new WorkflowQueryResult().setResultType(QueryResultType.ANSWERED).setAnswer(this.workflow.query(query));
        }
        catch (Throwable e) {
            return new WorkflowQueryResult().setResultType(QueryResultType.FAILED).setErrorMessage(e.getMessage());
        }
    }

    private boolean decideImpl(PollForDecisionTaskResponse decisionTask, Functions.Proc query) throws Throwable {
        boolean forceCreateNewDecisionTask = false;
        try {
            long startTime = System.currentTimeMillis();
            DecisionTaskWithHistoryIteratorImpl decisionTaskWithHistoryIterator = new DecisionTaskWithHistoryIteratorImpl(decisionTask, java.time.Duration.ofSeconds(this.startedEvent.getTaskStartToCloseTimeoutSeconds()));
            HistoryHelper historyHelper = new HistoryHelper(decisionTaskWithHistoryIterator, this.context.getReplayCurrentTimeMilliseconds());
            HistoryHelper.DecisionEventsIterator iterator = historyHelper.getIterator();
            if (this.decisionsHelper.getNextDecisionEventId() != historyHelper.getPreviousStartedEventId() + 2L && this.decisionsHelper.getNextDecisionEventId() != 0L && historyHelper.getPreviousStartedEventId() != 0L && decisionTask.getHistory().getEventsSize() > 0) {
                throw new IllegalStateException(String.format("ReplayDecider expects next event id at %d. History's previous started event id is %d", this.decisionsHelper.getNextDecisionEventId(), historyHelper.getPreviousStartedEventId()));
            }
            while (iterator.hasNext()) {
                HistoryHelper.DecisionEvents decision = iterator.next();
                this.context.setReplaying(decision.isReplay());
                this.context.setReplayCurrentTimeMilliseconds(decision.getReplayCurrentTimeMilliseconds());
                this.decisionsHelper.handleDecisionTaskStartedEvent(decision);
                for (HistoryEvent event : decision.getMarkers()) {
                    if (event.getMarkerRecordedEventAttributes().getMarkerName().equals("LocalActivity")) continue;
                    this.processEvent(event);
                }
                for (HistoryEvent event : decision.getEvents()) {
                    this.processEvent(event);
                }
                forceCreateNewDecisionTask = this.processEventLoop(startTime, this.startedEvent.getTaskStartToCloseTimeoutSeconds(), decision, decisionTask.getQuery() != null);
                this.mayBeCompleteWorkflow();
                if (decision.isReplay()) {
                    this.decisionsHelper.notifyDecisionSent();
                }
                for (HistoryEvent event : decision.getDecisionEvents()) {
                    this.processEvent(event);
                }
                this.decisionsHelper.handleDecisionTaskStartedEvent(decision);
            }
            if (forceCreateNewDecisionTask) {
                this.metricsScope.counter("cadence-decision-task-force-completed").inc(1L);
            }
            boolean bl = forceCreateNewDecisionTask;
            return bl;
        }
        catch (Error e) {
            if (this.workflow.getWorkflowImplementationOptions().getNonDeterministicWorkflowPolicy() == NonDeterministicWorkflowPolicy.FailWorkflow) {
                this.failure = this.workflow.mapError(e);
                this.completed = true;
                this.completeWorkflow();
                boolean bl = false;
                return bl;
            }
            this.metricsScope.counter("cadence-decision-task-error").inc(1L);
            throw e;
        }
        finally {
            if (query != null) {
                query.apply();
            }
            if (this.completed) {
                this.close();
            }
        }
    }

    private boolean processEventLoop(long startTime, int decisionTimeoutSecs, HistoryHelper.DecisionEvents decision, boolean isQuery) throws Throwable {
        this.eventLoop();
        if (decision.isReplay() || isQuery) {
            return this.replayLocalActivities(decision);
        }
        return this.executeLocalActivities(startTime, decisionTimeoutSecs);
    }

    private boolean replayLocalActivities(HistoryHelper.DecisionEvents decision) throws Throwable {
        ArrayList<HistoryEvent> localActivityMarkers = new ArrayList<HistoryEvent>();
        for (HistoryEvent event : decision.getMarkers()) {
            if (!event.getMarkerRecordedEventAttributes().getMarkerName().equals("LocalActivity")) continue;
            localActivityMarkers.add(event);
        }
        if (localActivityMarkers.isEmpty()) {
            return false;
        }
        int processed = 0;
        while (this.context.numPendingLaTasks() > 0) {
            int numTasks = this.context.numPendingLaTasks();
            for (HistoryEvent event : localActivityMarkers) {
                this.processEvent(event);
            }
            this.eventLoop();
            if ((processed += numTasks) != localActivityMarkers.size()) continue;
            return false;
        }
        return false;
    }

    private boolean executeLocalActivities(long startTime, int decisionTimeoutSecs) {
        java.time.Duration maxProcessingTime = java.time.Duration.ofSeconds((long)(0.8 * (double)decisionTimeoutSecs));
        while (this.context.numPendingLaTasks() > 0) {
            java.time.Duration processingTime = java.time.Duration.ofMillis(System.currentTimeMillis() - startTime);
            java.time.Duration maxWaitAllowed = maxProcessingTime.minus(processingTime);
            boolean started = this.context.startUnstartedLaTasks(maxWaitAllowed);
            if (!started) {
                return true;
            }
            try {
                this.context.awaitTaskCompletion(maxWaitAllowed);
            }
            catch (InterruptedException e) {
                return true;
            }
            this.eventLoop();
            if (this.context.numPendingLaTasks() == 0) {
                return false;
            }
            processingTime = java.time.Duration.ofMillis(System.currentTimeMillis() - startTime);
            if (processingTime.compareTo(maxProcessingTime) <= 0) continue;
            return true;
        }
        return false;
    }

    int getDecisionTimeoutSeconds() {
        return this.startedEvent.getTaskStartToCloseTimeoutSeconds();
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.workflow.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] query(PollForDecisionTaskResponse response, WorkflowQuery query) throws Throwable {
        this.lock.lock();
        try {
            AtomicReference result = new AtomicReference();
            this.decideImpl(response, () -> result.set(this.workflow.query(query)));
            byte[] byArray = (byte[])result.get();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Consumer<HistoryEvent> getLocalActivityCompletionSink() {
        return this.localActivityCompletionSink;
    }

    private class DecisionTaskWithHistoryIteratorImpl
    implements DecisionTaskWithHistoryIterator {
        private final java.time.Duration retryServiceOperationInitialInterval = java.time.Duration.ofMillis(200L);
        private final java.time.Duration retryServiceOperationMaxInterval = java.time.Duration.ofSeconds(4L);
        private final java.time.Duration paginationStart = java.time.Duration.ofMillis(System.currentTimeMillis());
        private java.time.Duration decisionTaskStartToCloseTimeout;
        private final PollForDecisionTaskResponse task;
        private Iterator<HistoryEvent> current;
        private byte[] nextPageToken;

        private final java.time.Duration decisionTaskRemainingTime() {
            java.time.Duration passed = java.time.Duration.ofMillis(System.currentTimeMillis()).minus(this.paginationStart);
            return this.decisionTaskStartToCloseTimeout.minus(passed);
        }

        DecisionTaskWithHistoryIteratorImpl(PollForDecisionTaskResponse task, java.time.Duration decisionTaskStartToCloseTimeout) {
            this.task = Objects.requireNonNull(task);
            this.decisionTaskStartToCloseTimeout = Objects.requireNonNull(decisionTaskStartToCloseTimeout);
            History history = task.getHistory();
            this.current = history.getEventsIterator();
            this.nextPageToken = task.getNextPageToken();
        }

        @Override
        public PollForDecisionTaskResponse getDecisionTask() {
            ReplayDecider.this.lock.lock();
            try {
                PollForDecisionTaskResponse pollForDecisionTaskResponse = this.task;
                return pollForDecisionTaskResponse;
            }
            finally {
                ReplayDecider.this.lock.unlock();
            }
        }

        @Override
        public Iterator<HistoryEvent> getHistory() {
            return new Iterator<HistoryEvent>(){

                @Override
                public boolean hasNext() {
                    return DecisionTaskWithHistoryIteratorImpl.this.current.hasNext() || DecisionTaskWithHistoryIteratorImpl.this.nextPageToken != null;
                }

                @Override
                public HistoryEvent next() {
                    if (DecisionTaskWithHistoryIteratorImpl.this.current.hasNext()) {
                        return (HistoryEvent)DecisionTaskWithHistoryIteratorImpl.this.current.next();
                    }
                    java.time.Duration decisionTaskRemainingTime = DecisionTaskWithHistoryIteratorImpl.this.decisionTaskRemainingTime();
                    if (decisionTaskRemainingTime.isNegative() || decisionTaskRemainingTime.isZero()) {
                        throw new Error("Decision task timed out while querying history. If this happens consistently please consider increase decision task timeout or reduce history size.");
                    }
                    ReplayDecider.this.metricsScope.counter("cadence-workflow-get-history-total").inc(1L);
                    Stopwatch sw = ReplayDecider.this.metricsScope.timer("cadence-workflow-get-history-latency").start();
                    RetryOptions retryOptions = new RetryOptions.Builder().setExpiration(decisionTaskRemainingTime).setInitialInterval(DecisionTaskWithHistoryIteratorImpl.this.retryServiceOperationInitialInterval).setMaximumInterval(DecisionTaskWithHistoryIteratorImpl.this.retryServiceOperationMaxInterval).build();
                    GetWorkflowExecutionHistoryRequest request = new GetWorkflowExecutionHistoryRequest();
                    request.setDomain(ReplayDecider.this.context.getDomain()).setExecution(DecisionTaskWithHistoryIteratorImpl.this.task.getWorkflowExecution()).setMaximumPageSize(10000).setNextPageToken(DecisionTaskWithHistoryIteratorImpl.this.nextPageToken);
                    try {
                        GetWorkflowExecutionHistoryResponse r = RpcRetryer.retryWithResult(retryOptions, () -> ReplayDecider.this.service.GetWorkflowExecutionHistory(request));
                        DecisionTaskWithHistoryIteratorImpl.this.current = r.getHistory().getEventsIterator();
                        DecisionTaskWithHistoryIteratorImpl.access$202(DecisionTaskWithHistoryIteratorImpl.this, r.getNextPageToken());
                        ReplayDecider.this.metricsScope.counter("cadence-workflow-get-history-succeed").inc(1L);
                        sw.stop();
                    }
                    catch (TException e) {
                        ReplayDecider.this.metricsScope.counter("cadence-workflow-get-history-failed").inc(1L);
                        throw new Error(e);
                    }
                    if (!DecisionTaskWithHistoryIteratorImpl.this.current.hasNext()) {
                        log.error("GetWorkflowExecutionHistory returns an empty history, maybe a bug in server, workflowID:" + request.execution.workflowId + ", runID:" + request.execution.runId + ", domain:" + request.domain + " token:" + Arrays.toString(request.getNextPageToken()));
                        throw new Error("GetWorkflowExecutionHistory return empty history, maybe a bug in server");
                    }
                    return (HistoryEvent)DecisionTaskWithHistoryIteratorImpl.this.current.next();
                }
            };
        }

        static /* synthetic */ byte[] access$202(DecisionTaskWithHistoryIteratorImpl x0, byte[] x1) {
            x0.nextPageToken = x1;
            return x1;
        }
    }
}

