/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.CancelTimerDecisionAttributes;
import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.StartTimerDecisionAttributes;
import com.uber.cadence.internal.replay.DecisionId;
import com.uber.cadence.internal.replay.DecisionState;
import com.uber.cadence.internal.replay.DecisionStateMachineBase;

class TimerDecisionStateMachine
extends DecisionStateMachineBase {
    private StartTimerDecisionAttributes attributes;
    private boolean canceled;

    public TimerDecisionStateMachine(DecisionId id, StartTimerDecisionAttributes attributes) {
        super(id);
        this.attributes = attributes;
    }

    TimerDecisionStateMachine(DecisionId id, StartTimerDecisionAttributes attributes, DecisionState state) {
        super(id, state);
        this.attributes = attributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createStartTimerDecision();
            }
            case CANCELED_AFTER_INITIATED: {
                return this.createCancelTimerDecision();
            }
        }
        return null;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_INITIATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.INITIATED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    @Override
    public boolean cancel(Runnable immediateCancellationCallback) {
        this.canceled = true;
        immediateCancellationCallback.run();
        return super.cancel(null);
    }

    @Override
    public boolean isDone() {
        return this.state == DecisionState.COMPLETED || this.canceled;
    }

    private Decision createCancelTimerDecision() {
        CancelTimerDecisionAttributes tryCancel = new CancelTimerDecisionAttributes();
        tryCancel.setTimerId(this.attributes.getTimerId());
        Decision decision = new Decision();
        decision.setCancelTimerDecisionAttributes(tryCancel);
        decision.setDecisionType(DecisionType.CancelTimer);
        return decision;
    }

    private Decision createStartTimerDecision() {
        Decision decision = new Decision();
        decision.setStartTimerDecisionAttributes(this.attributes);
        decision.setDecisionType(DecisionType.StartTimer);
        return decision;
    }
}

