/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.client.ActivityCompletionClient;
import com.uber.cadence.client.ActivityCompletionException;
import com.uber.cadence.internal.external.ManualActivityCompletionClientFactory;

class ActivityCompletionClientImpl
implements ActivityCompletionClient {
    private final ManualActivityCompletionClientFactory factory;

    public ActivityCompletionClientImpl(ManualActivityCompletionClientFactory manualActivityCompletionClientFactory) {
        this.factory = manualActivityCompletionClientFactory;
    }

    @Override
    public <R> void complete(byte[] taskToken, R result) {
        this.factory.getClient(taskToken).complete(result);
    }

    @Override
    public <R> void complete(WorkflowExecution execution, String activityId, R result) {
        this.factory.getClient(execution, activityId).complete(result);
    }

    @Override
    public void completeExceptionally(byte[] taskToken, Exception result) {
        this.factory.getClient(taskToken).fail(result);
    }

    @Override
    public void completeExceptionally(WorkflowExecution execution, String activityId, Exception result) {
        this.factory.getClient(execution, activityId).fail(result);
    }

    @Override
    public <V> void reportCancellation(byte[] taskToken, V details) {
        this.factory.getClient(taskToken).reportCancellation(details);
    }

    @Override
    public <V> void reportCancellation(WorkflowExecution execution, String activityId, V details) {
        this.factory.getClient(execution, activityId).reportCancellation(details);
    }

    @Override
    public <V> void heartbeat(byte[] taskToken, V details) throws ActivityCompletionException {
        this.factory.getClient(taskToken).recordHeartbeat(details);
    }

    @Override
    public <V> void heartbeat(WorkflowExecution execution, String activityId, V details) throws ActivityCompletionException {
        this.factory.getClient(execution, activityId).recordHeartbeat(details);
    }
}

