/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionAlreadyCompletedError;
import com.uber.cadence.activity.ActivityTask;
import com.uber.cadence.client.ActivityCancelledException;
import com.uber.cadence.client.ActivityCompletionException;
import com.uber.cadence.client.ActivityCompletionFailureException;
import com.uber.cadence.client.ActivityNotExistsException;
import com.uber.cadence.client.ActivityWorkerShutdownException;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.sync.ActivityExecutionContext;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActivityExecutionContextImpl
implements ActivityExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(ActivityExecutionContextImpl.class);
    private static final long HEARTBEAT_RETRY_WAIT_MILLIS = 1000L;
    private static final long MAX_HEARTBEAT_INTERVAL_MILLIS = 30000L;
    private final IWorkflowService service;
    private final String domain;
    private final ActivityTask task;
    private final DataConverter dataConverter;
    private boolean doNotCompleteOnReturn;
    private final long heartbeatIntervalMillis;
    private Optional<Object> lastDetails;
    private boolean hasOutstandingHeartbeat;
    private final ScheduledExecutorService heartbeatExecutor;
    private Lock lock = new ReentrantLock();
    private ScheduledFuture future;
    private ActivityCompletionException lastException;

    ActivityExecutionContextImpl(IWorkflowService service, String domain, ActivityTask task, DataConverter dataConverter, ScheduledExecutorService heartbeatExecutor) {
        this.domain = domain;
        this.service = service;
        this.task = task;
        this.dataConverter = dataConverter;
        this.heartbeatIntervalMillis = Math.min((long)(0.8 * (double)task.getHeartbeatTimeout().toMillis()), 30000L);
        this.heartbeatExecutor = heartbeatExecutor;
    }

    @Override
    public <V> void recordActivityHeartbeat(V details) throws ActivityCompletionException {
        if (this.heartbeatExecutor.isShutdown()) {
            throw new ActivityWorkerShutdownException(this.task);
        }
        this.lock.lock();
        try {
            this.lastDetails = Optional.ofNullable(details);
            this.hasOutstandingHeartbeat = true;
            if (this.future == null) {
                this.doHeartBeat(details);
            }
            if (this.lastException != null) {
                throw this.lastException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Optional<V> getHeartbeatDetails(Class<V> detailsClass, Type detailsType) {
        this.lock.lock();
        try {
            if (this.lastDetails != null) {
                Optional<Object> result;
                Optional<Object> optional = result = this.lastDetails;
                return optional;
            }
            byte[] details = this.task.getHeartbeatDetails();
            if (details == null) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<V> optional = Optional.of(this.dataConverter.fromData(details, detailsClass, detailsType));
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doHeartBeat(Object details) {
        long nextHeartbeatDelay;
        try {
            this.sendHeartbeatRequest(details);
            this.hasOutstandingHeartbeat = false;
            nextHeartbeatDelay = this.heartbeatIntervalMillis;
        }
        catch (TException e) {
            log.warn("Heartbeat failed.", (Throwable)e);
            nextHeartbeatDelay = 1000L;
        }
        this.scheduleNextHeartbeat(nextHeartbeatDelay);
    }

    private void scheduleNextHeartbeat(long delay) {
        this.future = this.heartbeatExecutor.schedule(() -> {
            this.lock.lock();
            try {
                if (this.hasOutstandingHeartbeat) {
                    Object details = this.lastDetails.orElse(null);
                    this.doHeartBeat(details);
                } else {
                    this.future = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void sendHeartbeatRequest(Object details) throws TException {
        RecordActivityTaskHeartbeatRequest r = new RecordActivityTaskHeartbeatRequest();
        r.setTaskToken(this.task.getTaskToken());
        byte[] serialized = this.dataConverter.toData(details);
        r.setDetails(serialized);
        try {
            RecordActivityTaskHeartbeatResponse status = this.service.RecordActivityTaskHeartbeat(r);
            this.lastException = status.isCancelRequested() ? new ActivityCancelledException(this.task) : null;
        }
        catch (EntityNotExistsError e) {
            this.lastException = new ActivityNotExistsException(this.task, (Throwable)((Object)e));
        }
        catch (WorkflowExecutionAlreadyCompletedError e) {
            throw new ActivityNotExistsException(this.task, (Throwable)((Object)e));
        }
        catch (BadRequestError e) {
            this.lastException = new ActivityCompletionFailureException(this.task, (Throwable)((Object)e));
        }
    }

    @Override
    public void doNotCompleteOnReturn() {
        this.doNotCompleteOnReturn = true;
    }

    @Override
    public boolean isDoNotCompleteOnReturn() {
        return this.doNotCompleteOnReturn;
    }

    @Override
    public ActivityTask getTask() {
        return this.task;
    }

    @Override
    public IWorkflowService getService() {
        return this.service;
    }

    @Override
    public byte[] getTaskToken() {
        return this.task.getTaskToken();
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.task.getWorkflowExecution();
    }

    @Override
    public String getDomain() {
        return this.domain;
    }
}

