/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.activity.ActivityTask;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

final class ActivityTaskImpl
implements ActivityTask {
    private final PollForActivityTaskResponse response;

    ActivityTaskImpl(PollForActivityTaskResponse response) {
        this.response = response;
    }

    @Override
    public byte[] getTaskToken() {
        return this.response.getTaskToken();
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.response.getWorkflowExecution();
    }

    @Override
    public String getActivityId() {
        return this.response.getActivityId();
    }

    @Override
    public String getActivityType() {
        return this.response.getActivityType().getName();
    }

    @Override
    public long getScheduledTimestamp() {
        return TimeUnit.MICROSECONDS.toMillis(this.response.getScheduledTimestamp());
    }

    @Override
    public Duration getScheduleToCloseTimeout() {
        return Duration.ofSeconds(this.response.getScheduleToCloseTimeoutSeconds());
    }

    @Override
    public Duration getStartToCloseTimeout() {
        return Duration.ofSeconds(this.response.getStartToCloseTimeoutSeconds());
    }

    @Override
    public Duration getHeartbeatTimeout() {
        return Duration.ofSeconds(this.response.getHeartbeatTimeoutSeconds());
    }

    @Override
    public byte[] getHeartbeatDetails() {
        return this.response.getHeartbeatDetails();
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.response.getWorkflowType();
    }

    @Override
    public String getWorkflowDomain() {
        return this.response.getWorkflowDomain();
    }

    @Override
    public int getAttempt() {
        return this.response.getAttempt();
    }

    public byte[] getInput() {
        return this.response.getInput();
    }
}

