/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.RateLimiter;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.activity.ActivityMethod;
import com.uber.cadence.client.ActivityCancelledException;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.sync.ActivityExecutionContextImpl;
import com.uber.cadence.internal.sync.ActivityTaskImpl;
import com.uber.cadence.internal.sync.CurrentActivityExecutionContext;
import com.uber.cadence.internal.sync.LocalActivityExecutionContextImpl;
import com.uber.cadence.internal.sync.SimulatedTimeoutExceptionInternal;
import com.uber.cadence.internal.worker.ActivityTaskHandler;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.testing.SimulatedTimeoutException;
import com.uber.m3.tally.Scope;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;

class POJOActivityTaskHandler
implements ActivityTaskHandler {
    private static final RateLimiter metricsRateLimiter = RateLimiter.create((double)1.0);
    private final DataConverter dataConverter;
    private final ScheduledExecutorService heartbeatExecutor;
    private final Map<String, ActivityTaskExecutor> activities = Collections.synchronizedMap(new HashMap());
    private IWorkflowService service;
    private final String domain;

    POJOActivityTaskHandler(IWorkflowService service, String domain, DataConverter dataConverter, ScheduledExecutorService heartbeatExecutor) {
        this.service = service;
        this.domain = domain;
        this.dataConverter = dataConverter;
        this.heartbeatExecutor = heartbeatExecutor;
    }

    private void addActivityImplementation(Object activity, BiFunction<Method, Object, ActivityTaskExecutor> newTaskExecutor) {
        if (activity instanceof Class) {
            throw new IllegalArgumentException("Activity object instance expected, not the class");
        }
        Class<?> cls = activity.getClass();
        for (Method method : cls.getMethods()) {
            if (method.getAnnotation(ActivityMethod.class) != null) {
                throw new IllegalArgumentException("Found @ActivityMethod annotation on \"" + method + "\" This annotation can be used only on the interface method it implements.");
            }
            if (method.getAnnotation(MethodRetry.class) == null) continue;
            throw new IllegalArgumentException("Found @MethodRetry annotation on \"" + method + "\" This annotation can be used only on the interface method it implements.");
        }
        TypeToken.TypeSet interfaces = TypeToken.of(cls).getTypes().interfaces();
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException("Activity must implement at least one interface");
        }
        for (TypeToken i : interfaces) {
            if (i.getType().getTypeName().startsWith("org.mockito")) continue;
            for (Method method : i.getRawType().getMethods()) {
                ActivityMethod annotation = method.getAnnotation(ActivityMethod.class);
                String activityType = annotation != null && !annotation.name().isEmpty() ? annotation.name() : InternalUtils.getSimpleName(method);
                if (this.activities.containsKey(activityType)) {
                    throw new IllegalStateException(activityType + " activity type is already registered with the worker");
                }
                ActivityTaskExecutor implementation = newTaskExecutor.apply(method, activity);
                this.activities.put(activityType, implementation);
            }
        }
    }

    private ActivityTaskHandler.Result mapToActivityFailure(Throwable failure, Scope metricsScope, boolean isLocalActivity) {
        if (failure instanceof ActivityCancelledException) {
            if (isLocalActivity) {
                metricsScope.counter("cadence-local-activity-canceled").inc(1L);
            }
            throw new CancellationException(failure.getMessage());
        }
        if (failure instanceof SimulatedTimeoutException) {
            SimulatedTimeoutException timeoutException = (SimulatedTimeoutException)failure;
            failure = new SimulatedTimeoutExceptionInternal(timeoutException.getTimeoutType(), this.dataConverter.toData(timeoutException.getDetails()));
        }
        if (failure instanceof Error) {
            if (isLocalActivity) {
                metricsScope.counter("cadence-local-activity-panic").inc(1L);
            } else {
                metricsScope.counter("cadence-activity-task-error").inc(1L);
            }
            throw (Error)failure;
        }
        if (isLocalActivity) {
            metricsScope.counter("cadence-local-activity-failed").inc(1L);
        } else {
            metricsScope.counter("cadence-activity-execution-failed").inc(1L);
        }
        RespondActivityTaskFailedRequest result = new RespondActivityTaskFailedRequest();
        failure = CheckedExceptionWrapper.unwrap(failure);
        result.setReason(failure.getClass().getName());
        result.setDetails(this.dataConverter.toData(failure));
        return new ActivityTaskHandler.Result(null, new ActivityTaskHandler.Result.TaskFailedResult(result, failure), null);
    }

    @Override
    public boolean isAnyTypeSupported() {
        return !this.activities.isEmpty();
    }

    void setActivitiesImplementation(Object[] activitiesImplementation) {
        this.activities.clear();
        for (Object activity : activitiesImplementation) {
            this.addActivityImplementation(activity, (x$0, x$1) -> new POJOActivityImplementation((Method)x$0, x$1));
        }
    }

    void setLocalActivitiesImplementation(Object[] activitiesImplementation) {
        this.activities.clear();
        for (Object activity : activitiesImplementation) {
            this.addActivityImplementation(activity, (x$0, x$1) -> new POJOLocalActivityImplementation((Method)x$0, x$1));
        }
    }

    @Override
    public ActivityTaskHandler.Result handle(PollForActivityTaskResponse pollResponse, Scope metricsScope, boolean isLocalActivity) {
        String activityType = pollResponse.getActivityType().getName();
        ActivityTaskImpl activityTask = new ActivityTaskImpl(pollResponse);
        ActivityTaskExecutor activity = this.activities.get(activityType);
        if (activity == null) {
            String knownTypes = Joiner.on((String)", ").join(this.activities.keySet());
            return this.mapToActivityFailure(new IllegalArgumentException("Activity Type \"" + activityType + "\" is not registered with a worker. Known types are: " + knownTypes), metricsScope, isLocalActivity);
        }
        if (metricsRateLimiter.tryAcquire(1)) {
            if (isLocalActivity) {
                metricsScope.gauge("cadence-local_activity_active_thread_count").update((double)Thread.activeCount());
            } else {
                metricsScope.gauge("cadence-activity_active_thread_count").update((double)Thread.activeCount());
            }
        }
        return activity.execute(activityTask, metricsScope);
    }

    void setWorkflowService(IWorkflowService service) {
        this.service = service;
    }

    private class POJOLocalActivityImplementation
    implements ActivityTaskExecutor {
        private final Method method;
        private final Object activity;

        POJOLocalActivityImplementation(Method interfaceMethod, Object activity) {
            this.method = interfaceMethod;
            this.activity = activity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityTaskHandler.Result execute(ActivityTaskImpl task, Scope metricsScope) {
            LocalActivityExecutionContextImpl context = new LocalActivityExecutionContextImpl(POJOActivityTaskHandler.this.service, POJOActivityTaskHandler.this.domain, task);
            CurrentActivityExecutionContext.set(context);
            byte[] input = task.getInput();
            try {
                Object[] args = POJOActivityTaskHandler.this.dataConverter.fromDataArray(input, this.method.getGenericParameterTypes());
                Object result = this.method.invoke(this.activity, args);
                RespondActivityTaskCompletedRequest request = new RespondActivityTaskCompletedRequest();
                if (this.method.getReturnType() != Void.TYPE) {
                    request.setResult(POJOActivityTaskHandler.this.dataConverter.toData(result));
                }
                ActivityTaskHandler.Result result2 = new ActivityTaskHandler.Result(request, null, null);
                return result2;
            }
            catch (IllegalAccessException | RuntimeException e) {
                ActivityTaskHandler.Result result = POJOActivityTaskHandler.this.mapToActivityFailure(e, metricsScope, true);
                return result;
            }
            catch (InvocationTargetException e) {
                ActivityTaskHandler.Result result = POJOActivityTaskHandler.this.mapToActivityFailure(e.getTargetException(), metricsScope, true);
                return result;
            }
            finally {
                CurrentActivityExecutionContext.unset();
            }
        }
    }

    private class POJOActivityImplementation
    implements ActivityTaskExecutor {
        private final Method method;
        private final Object activity;

        POJOActivityImplementation(Method interfaceMethod, Object activity) {
            this.method = interfaceMethod;
            this.activity = activity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityTaskHandler.Result execute(ActivityTaskImpl task, Scope metricsScope) {
            ActivityTaskHandler.Result result;
            ActivityExecutionContextImpl context = new ActivityExecutionContextImpl(POJOActivityTaskHandler.this.service, POJOActivityTaskHandler.this.domain, task, POJOActivityTaskHandler.this.dataConverter, POJOActivityTaskHandler.this.heartbeatExecutor);
            byte[] input = task.getInput();
            CurrentActivityExecutionContext.set(context);
            try {
                Object[] args = POJOActivityTaskHandler.this.dataConverter.fromDataArray(input, this.method.getGenericParameterTypes());
                Object result2 = this.method.invoke(this.activity, args);
                RespondActivityTaskCompletedRequest request = new RespondActivityTaskCompletedRequest();
                if (context.isDoNotCompleteOnReturn()) {
                    ActivityTaskHandler.Result result3 = new ActivityTaskHandler.Result(null, null, null);
                    return result3;
                }
                if (this.method.getReturnType() != Void.TYPE) {
                    request.setResult(POJOActivityTaskHandler.this.dataConverter.toData(result2));
                }
                ActivityTaskHandler.Result result4 = new ActivityTaskHandler.Result(request, null, null);
                return result4;
            }
            catch (IllegalAccessException | RuntimeException e) {
                result = POJOActivityTaskHandler.this.mapToActivityFailure(e, metricsScope, false);
                return result;
            }
            catch (InvocationTargetException e) {
                result = POJOActivityTaskHandler.this.mapToActivityFailure(e.getTargetException(), metricsScope, false);
                return result;
            }
            finally {
                CurrentActivityExecutionContext.unset();
            }
        }
    }

    static interface ActivityTaskExecutor {
        public ActivityTaskHandler.Result execute(ActivityTaskImpl var1, Scope var2);
    }
}

