/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.workflow.ActivityFailureException;
import com.uber.cadence.workflow.CompletablePromise;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import java.time.Duration;

final class WorkflowRetryerInternal {
    public static void retry(RetryOptions options, Functions.Proc proc) {
        WorkflowRetryerInternal.retry(options, () -> {
            proc.apply();
            return null;
        });
    }

    public static <R> R validateOptionsAndRetry(RetryOptions options, Functions.Func<R> func) {
        return WorkflowRetryerInternal.retry(RetryOptions.merge(null, options), func);
    }

    public static <R> R retry(RetryOptions options, Functions.Func<R> func) {
        options.validate();
        int attempt = 1;
        long startTime = WorkflowInternal.currentTimeMillis();
        String retryId = WorkflowInternal.randomUUID().toString();
        RetryOptions retryOptions = WorkflowInternal.mutableSideEffect(retryId, RetryOptions.class, RetryOptions.class, Object::equals, () -> options);
        while (true) {
            long nextSleepTime = retryOptions.calculateSleepTime(attempt);
            try {
                return func.apply();
            }
            catch (Exception e) {
                long elapsed = WorkflowInternal.currentTimeMillis() - startTime;
                if (retryOptions.shouldRethrow(e, attempt, elapsed, nextSleepTime)) {
                    throw WorkflowInternal.wrap(e);
                }
                ++attempt;
                WorkflowInternal.sleep(Duration.ofMillis(nextSleepTime));
                continue;
            }
            break;
        }
    }

    public static <R> Promise<R> retryAsync(RetryOptions options, Functions.Func<Promise<R>> func) {
        String retryId = WorkflowInternal.randomUUID().toString();
        long startTime = WorkflowInternal.currentTimeMillis();
        return WorkflowRetryerInternal.retryAsync(retryId, options, func, startTime, 1L);
    }

    private static <R> Promise<R> retryAsync(String retryId, RetryOptions options, Functions.Func<Promise<R>> func, long startTime, long attempt) {
        options.validate();
        RetryOptions retryOptions = WorkflowInternal.mutableSideEffect(retryId, RetryOptions.class, RetryOptions.class, Object::equals, () -> options);
        CompletablePromise funcResult = WorkflowInternal.newCompletablePromise();
        try {
            funcResult.completeFrom(func.apply());
        }
        catch (RuntimeException e2) {
            funcResult.completeExceptionally(e2);
        }
        return funcResult.handle((r, e) -> {
            long sleepTime;
            if (e == null) {
                return WorkflowInternal.newPromise(r);
            }
            long elapsed = WorkflowInternal.currentTimeMillis() - startTime;
            if (retryOptions.shouldRethrow((Throwable)e, attempt, elapsed, sleepTime = retryOptions.calculateSleepTime(attempt))) {
                throw e;
            }
            return WorkflowInternal.newTimer(Duration.ofMillis(sleepTime)).thenCompose(nil -> WorkflowRetryerInternal.retryAsync(retryId, retryOptions, func, startTime, attempt + 1L));
        }).thenCompose(r -> r);
    }

    static <R> Promise<R> retryAsync(Functions.Func2<Integer, Long, Promise<R>> func, int attempt, long startTime) {
        CompletablePromise funcResult = WorkflowInternal.newCompletablePromise();
        try {
            funcResult.completeFrom(func.apply(attempt, startTime));
        }
        catch (RuntimeException e2) {
            funcResult.completeExceptionally(e2);
        }
        return funcResult.handle((r, e) -> {
            if (e == null) {
                return WorkflowInternal.newPromise(r);
            }
            if (!(e instanceof ActivityFailureException)) {
                throw e;
            }
            ActivityFailureException afe = (ActivityFailureException)e;
            if (afe.getBackoff() == null) {
                throw e;
            }
            long nextStart = WorkflowInternal.currentTimeMillis() + afe.getBackoff().toMillis();
            return WorkflowInternal.newTimer(afe.getBackoff()).thenCompose(nil -> WorkflowRetryerInternal.retryAsync(func, afe.getAttempt() + 1, nextStart));
        }).thenCompose(r -> r);
    }

    private WorkflowRetryerInternal() {
    }
}

