/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.util.concurrent.RateLimiter;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.internal.context.ContextThreadLocal;
import com.uber.cadence.internal.replay.DeciderCache;
import com.uber.cadence.internal.replay.DecisionContext;
import com.uber.cadence.internal.sync.CancellationScopeImpl;
import com.uber.cadence.internal.sync.DestroyWorkflowThreadError;
import com.uber.cadence.internal.sync.DeterministicRunnerImpl;
import com.uber.cadence.internal.sync.Status;
import com.uber.cadence.internal.sync.SyncDecisionContext;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.internal.sync.WorkflowRejectedExecutionError;
import com.uber.cadence.internal.sync.WorkflowThread;
import com.uber.cadence.internal.sync.WorkflowThreadContext;
import com.uber.cadence.internal.sync.WorkflowThreadLocalInternal;
import com.uber.cadence.workflow.Promise;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class WorkflowThreadImpl
implements WorkflowThread {
    private static final RateLimiter metricsRateLimiter = RateLimiter.create((double)1.0);
    private static final Logger log = LoggerFactory.getLogger(WorkflowThreadImpl.class);
    private final boolean root;
    private final ExecutorService threadPool;
    private final WorkflowThreadContext context;
    private DeciderCache cache;
    private final DeterministicRunnerImpl runner;
    private final RunnableWrapper task;
    private Thread thread;
    private Future<?> taskFuture;
    private final Map<WorkflowThreadLocalInternal<?>, Object> threadLocalMap = new HashMap();
    private long blockedUntil;

    WorkflowThreadImpl(boolean root, ExecutorService threadPool, DeterministicRunnerImpl runner, String name, boolean detached, CancellationScopeImpl parentCancellationScope, Runnable runnable, DeciderCache cache, List<ContextPropagator> contextPropagators, Map<String, Object> propagatedContexts) {
        this.root = root;
        this.threadPool = threadPool;
        this.runner = runner;
        this.context = new WorkflowThreadContext(runner.getLock());
        this.cache = cache;
        if (name == null) {
            name = "workflow-" + super.hashCode();
        }
        this.task = new RunnableWrapper(this.context, runner.getDecisionContext().getContext(), name, detached, parentCancellationScope, runnable, contextPropagators, propagatedContexts);
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("not used");
    }

    @Override
    public boolean isDetached() {
        return this.task.cancellationScope.isDetached();
    }

    @Override
    public void cancel() {
        this.task.cancellationScope.cancel();
    }

    @Override
    public void cancel(String reason) {
        this.task.cancellationScope.cancel(reason);
    }

    @Override
    public String getCancellationReason() {
        return this.task.cancellationScope.getCancellationReason();
    }

    @Override
    public boolean isCancelRequested() {
        return this.task.cancellationScope.isCancelRequested();
    }

    @Override
    public Promise<String> getCancellationRequest() {
        return this.task.cancellationScope.getCancellationRequest();
    }

    @Override
    public void start() {
        if (this.context.getStatus() != Status.CREATED) {
            throw new IllegalThreadStateException("already started");
        }
        this.context.setStatus(Status.RUNNING);
        if (metricsRateLimiter.tryAcquire(1)) {
            this.getDecisionContext().getMetricsScope().gauge("cadence-workflow_active_thread_count").update((double)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        }
        while (true) {
            try {
                this.taskFuture = this.threadPool.submit(this.task);
                return;
            }
            catch (RejectedExecutionException e) {
                this.getDecisionContext().getMetricsScope().counter("cadence-sticky-cache-thread-forced-eviction").inc(1L);
                if (this.cache != null) {
                    boolean evicted;
                    if (evicted = this.cache.evictAnyNotInProcessing(this.runner.getDecisionContext().getContext().getRunId())) continue;
                    throw new WorkflowRejectedExecutionError(e);
                }
                throw new WorkflowRejectedExecutionError(e);
            }
            break;
        }
    }

    public WorkflowThreadContext getContext() {
        return this.context;
    }

    @Override
    public DeterministicRunnerImpl getRunner() {
        return this.runner;
    }

    @Override
    public SyncDecisionContext getDecisionContext() {
        return this.runner.getDecisionContext();
    }

    @Override
    public void setName(String name) {
        this.task.setName(name);
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public long getId() {
        return this.hashCode();
    }

    @Override
    public long getBlockedUntil() {
        return this.blockedUntil;
    }

    private void setBlockedUntil(long blockedUntil) {
        this.blockedUntil = blockedUntil;
    }

    @Override
    public boolean runUntilBlocked() {
        if (this.taskFuture == null) {
            this.start();
        }
        return this.context.runUntilBlocked();
    }

    @Override
    public boolean isDone() {
        return this.context.isDone();
    }

    public Thread.State getState() {
        if (this.context.getStatus() == Status.YIELDED) {
            return Thread.State.BLOCKED;
        }
        if (this.context.getStatus() == Status.DONE) {
            return Thread.State.TERMINATED;
        }
        return Thread.State.RUNNABLE;
    }

    @Override
    public Throwable getUnhandledException() {
        return this.context.getUnhandledException();
    }

    public void evaluateInCoroutineContext(Consumer<String> function) {
        this.context.evaluateInCoroutineContext(function);
    }

    @Override
    public Future<?> stopNow() {
        if (this.thread == Thread.currentThread()) {
            throw new Error("Cannot call destroy on itself: " + this.thread.getName());
        }
        this.context.destroy();
        if (!this.context.isDone()) {
            throw new RuntimeException("Couldn't destroy the thread. The blocked thread stack trace: " + this.getStackTrace());
        }
        if (this.taskFuture == null) {
            return this.getCompletedFuture();
        }
        return this.taskFuture;
    }

    private Future<?> getCompletedFuture() {
        CompletableFuture<String> f = new CompletableFuture<String>();
        f.complete("done");
        return f;
    }

    @Override
    public void addStackTrace(StringBuilder result) {
        result.append(this.getName());
        if (this.thread == null) {
            result.append("(NEW)");
            return;
        }
        result.append(": (BLOCKED on ").append(this.getContext().getYieldReason()).append(")\n");
        int omitTop = 5;
        int omitBottom = 7;
        if ("workflow-root".equals(this.getName())) {
            omitBottom = 11;
        }
        StackTraceElement[] stackTrace = this.thread.getStackTrace();
        for (int i = omitTop; i < stackTrace.length - omitBottom; ++i) {
            StackTraceElement e = stackTrace[i];
            if (i == omitTop && "await".equals(e.getMethodName())) continue;
            result.append(e);
            result.append("\n");
        }
    }

    @Override
    public void yield(String reason, Supplier<Boolean> unblockCondition) {
        this.context.yield(reason, unblockCondition);
    }

    @Override
    public boolean yield(long timeoutMillis, String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        if (timeoutMillis == 0L) {
            return unblockCondition.get();
        }
        long blockedUntil = WorkflowInternal.currentTimeMillis() + timeoutMillis;
        this.setBlockedUntil(blockedUntil);
        YieldWithTimeoutCondition condition = new YieldWithTimeoutCondition(unblockCondition, blockedUntil);
        WorkflowThread.await(reason, condition);
        return !condition.isTimedOut();
    }

    @Override
    public <R> void exitThread(R value) {
        this.runner.exit(value);
        throw new DestroyWorkflowThreadError("exit");
    }

    @Override
    public <T> void setThreadLocal(WorkflowThreadLocalInternal<T> key, T value) {
        this.threadLocalMap.put(key, value);
    }

    @Override
    public <T> Optional<T> getThreadLocal(WorkflowThreadLocalInternal<T> key) {
        if (!this.threadLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.threadLocalMap.get(key));
    }

    @Override
    public String getStackTrace() {
        StackTraceElement[] st = this.task.getStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement se : st) {
            pw.println("\tat " + se);
        }
        return sw.toString();
    }

    static class YieldWithTimeoutCondition
    implements Supplier<Boolean> {
        private final Supplier<Boolean> unblockCondition;
        private final long blockedUntil;
        private boolean timedOut;

        YieldWithTimeoutCondition(Supplier<Boolean> unblockCondition, long blockedUntil) {
            this.unblockCondition = unblockCondition;
            this.blockedUntil = blockedUntil;
        }

        boolean isTimedOut() {
            return this.timedOut;
        }

        @Override
        public Boolean get() {
            boolean result = this.unblockCondition.get();
            if (result) {
                return true;
            }
            this.timedOut = WorkflowInternal.currentTimeMillis() >= this.blockedUntil;
            return this.timedOut;
        }
    }

    class RunnableWrapper
    implements Runnable {
        private final WorkflowThreadContext threadContext;
        private final DecisionContext decisionContext;
        private String originalName;
        private String name;
        private CancellationScopeImpl cancellationScope;
        private List<ContextPropagator> contextPropagators;
        private Map<String, Object> propagatedContexts;

        RunnableWrapper(WorkflowThreadContext threadContext, DecisionContext decisionContext, String name, boolean detached, CancellationScopeImpl parent, Runnable runnable, List<ContextPropagator> contextPropagators, Map<String, Object> propagatedContexts) {
            this.threadContext = threadContext;
            this.decisionContext = decisionContext;
            this.name = name;
            this.cancellationScope = new CancellationScopeImpl(detached, runnable, parent);
            if (WorkflowThreadImpl.this.context.getStatus() != Status.CREATED) {
                throw new IllegalStateException("threadContext not in CREATED state");
            }
            this.contextPropagators = contextPropagators;
            this.propagatedContexts = propagatedContexts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkflowThreadImpl.this.thread = Thread.currentThread();
            this.originalName = WorkflowThreadImpl.this.thread.getName();
            WorkflowThreadImpl.this.thread.setName(this.name);
            DeterministicRunnerImpl.setCurrentThreadInternal(WorkflowThreadImpl.this);
            this.decisionContext.getWorkflowId();
            MDC.put((String)"WorkflowID", (String)this.decisionContext.getWorkflowId());
            MDC.put((String)"WorkflowType", (String)this.decisionContext.getWorkflowType().getName());
            MDC.put((String)"RunID", (String)this.decisionContext.getRunId());
            MDC.put((String)"TaskList", (String)this.decisionContext.getTaskList());
            MDC.put((String)"Domain", (String)this.decisionContext.getDomain());
            ContextThreadLocal.setContextPropagators(this.contextPropagators);
            ContextThreadLocal.propagateContextToCurrentThread(this.propagatedContexts);
            try {
                this.threadContext.initialYield();
                this.cancellationScope.run();
            }
            catch (DestroyWorkflowThreadError e) {
                if (!this.threadContext.isDestroyRequested()) {
                    this.threadContext.setUnhandledException(e);
                }
            }
            catch (Error e) {
                if (log.isErrorEnabled() && !WorkflowThreadImpl.this.root) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    e.printStackTrace(pw);
                    String stackTrace = sw.getBuffer().toString();
                    log.error(String.format("Workflow thread \"%s\" run failed with Error:\n%s", this.name, stackTrace));
                }
                this.threadContext.setUnhandledException(e);
            }
            catch (CancellationException e) {
                if (!WorkflowThreadImpl.this.isCancelRequested()) {
                    this.threadContext.setUnhandledException(e);
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Workflow thread \"%s\" run cancelled", this.name));
                }
            }
            catch (Throwable e) {
                if (log.isWarnEnabled() && !WorkflowThreadImpl.this.root) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    e.printStackTrace(pw);
                    String stackTrace = sw.getBuffer().toString();
                    log.warn(String.format("Workflow thread \"%s\" run failed with unhandled exception:\n%s", this.name, stackTrace));
                }
                this.threadContext.setUnhandledException(e);
            }
            finally {
                DeterministicRunnerImpl.setCurrentThreadInternal(null);
                this.threadContext.setStatus(Status.DONE);
                WorkflowThreadImpl.this.thread.setName(this.originalName);
                WorkflowThreadImpl.this.thread = null;
                MDC.clear();
            }
        }

        public String getName() {
            return this.name;
        }

        StackTraceElement[] getStackTrace() {
            if (WorkflowThreadImpl.this.thread != null) {
                return WorkflowThreadImpl.this.thread.getStackTrace();
            }
            return new StackTraceElement[0];
        }

        public void setName(String name) {
            this.name = name;
            if (WorkflowThreadImpl.this.thread != null) {
                WorkflowThreadImpl.this.thread.setName(name);
            }
        }
    }
}

