/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.WorkflowExecutionInfo;
import com.uber.cadence.internal.testservice.ExecutionId;
import com.uber.cadence.internal.testservice.RequestContext;
import com.uber.cadence.internal.testservice.SelfAdvancingTimer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

interface TestWorkflowStore {
    public SelfAdvancingTimer getTimer();

    public long currentTimeMillis();

    public long save(RequestContext var1) throws InternalServiceError, EntityNotExistsError, BadRequestError;

    public void applyTimersAndLocks(RequestContext var1);

    public void registerDelayedCallback(Duration var1, Runnable var2);

    public PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest var1) throws InterruptedException;

    public PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest var1) throws InterruptedException;

    public void sendQueryTask(ExecutionId var1, TaskListId var2, PollForDecisionTaskResponse var3) throws EntityNotExistsError;

    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(ExecutionId var1, GetWorkflowExecutionHistoryRequest var2) throws EntityNotExistsError;

    public void getDiagnostics(StringBuilder var1);

    public List<WorkflowExecutionInfo> listWorkflows(WorkflowState var1, Optional<String> var2);

    public void close();

    public static class ActivityTask {
        private final TaskListId taskListId;
        private final PollForActivityTaskResponse task;

        public ActivityTask(TaskListId taskListId, PollForActivityTaskResponse task) {
            this.taskListId = taskListId;
            this.task = task;
        }

        public TaskListId getTaskListId() {
            return this.taskListId;
        }

        public PollForActivityTaskResponse getTask() {
            return this.task;
        }
    }

    public static class DecisionTask {
        private final TaskListId taskListId;
        private final PollForDecisionTaskResponse task;

        public DecisionTask(TaskListId taskListId, PollForDecisionTaskResponse task) {
            this.taskListId = taskListId;
            this.task = task;
        }

        public TaskListId getTaskListId() {
            return this.taskListId;
        }

        public PollForDecisionTaskResponse getTask() {
            return this.task;
        }
    }

    public static class TaskListId {
        private final String domain;
        private final String taskListName;

        public TaskListId(String domain, String taskListName) {
            this.domain = Objects.requireNonNull(domain);
            this.taskListName = Objects.requireNonNull(taskListName);
        }

        public String getDomain() {
            return this.domain;
        }

        public String getTaskListName() {
            return this.taskListName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof TaskListId)) {
                return false;
            }
            TaskListId that = (TaskListId)o;
            if (!this.domain.equals(that.domain)) {
                return false;
            }
            return this.taskListName.equals(that.taskListName);
        }

        public int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + this.taskListName.hashCode();
            return result;
        }

        public String toString() {
            return "TaskListId{domain='" + this.domain + '\'' + ", taskListName='" + this.taskListName + '\'' + '}';
        }
    }

    public static enum WorkflowState {
        OPEN,
        CLOSED;

    }
}

