/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.InternalServiceError;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.TaskList;
import com.uber.cadence.common.BinaryChecksum;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.WorkflowWorker;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowPollTask
implements Poller.PollTask<PollForDecisionTaskResponse> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowWorker.class);
    private final Scope metricScope;
    private final IWorkflowService service;
    private final String domain;
    private final String taskList;
    private final String identity;

    WorkflowPollTask(IWorkflowService service, String domain, String taskList, Scope metricScope, String identity) {
        this.identity = Objects.requireNonNull(identity);
        this.service = Objects.requireNonNull(service);
        this.domain = Objects.requireNonNull(domain);
        this.taskList = Objects.requireNonNull(taskList);
        this.metricScope = Objects.requireNonNull(metricScope);
    }

    @Override
    public PollForDecisionTaskResponse poll() throws TException {
        PollForDecisionTaskResponse result;
        this.metricScope.counter("cadence-decision-poll-total").inc(1L);
        Stopwatch sw = this.metricScope.timer("cadence-decision-poll-latency").start();
        PollForDecisionTaskRequest pollRequest = new PollForDecisionTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.identity);
        pollRequest.setBinaryChecksum(BinaryChecksum.getBinaryChecksum());
        TaskList tl = new TaskList();
        tl.setName(this.taskList);
        pollRequest.setTaskList(tl);
        if (log.isDebugEnabled()) {
            log.debug("poll request begin: " + pollRequest);
        }
        try {
            result = this.service.PollForDecisionTask(pollRequest);
        }
        catch (InternalServiceError | ServiceBusyError e) {
            this.metricScope.counter("cadence-decision-poll-transient-failed").inc(1L);
            throw e;
        }
        catch (TException e) {
            this.metricScope.counter("cadence-decision-poll-failed").inc(1L);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug("poll request returned decision task: workflowType=" + result.getWorkflowType() + ", workflowExecution=" + result.getWorkflowExecution() + ", startedEventId=" + result.getStartedEventId() + ", previousStartedEventId=" + result.getPreviousStartedEventId() + (result.getQuery() != null ? ", queryType=" + result.getQuery().getQueryType() : ""));
        }
        if (result == null || result.getTaskToken() == null) {
            this.metricScope.counter("cadence-decision-poll-no-task").inc(1L);
            return null;
        }
        Scope metricsScope = this.metricScope.tagged((Map)ImmutableMap.of((Object)"WorkflowType", (Object)result.getWorkflowType().getName()));
        metricsScope.counter("cadence-decision-poll-succeed").inc(1L);
        metricsScope.timer("cadence-decision-scheduled-to-start-latency").record(Duration.ofNanos((long)(result.getStartedTimestamp() - result.getScheduledTimestamp())));
        sw.stop();
        return result;
    }
}

