/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.reporter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AtomicDouble;
import com.uber.m3.tally.Buckets;
import com.uber.m3.tally.Capabilities;
import com.uber.m3.tally.CapableOf;
import com.uber.m3.tally.StatsReporter;
import com.uber.m3.util.Duration;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CadenceClientStatsReporter
implements StatsReporter {
    private final Map<String, AtomicDouble> gauges = new ConcurrentHashMap<String, AtomicDouble>();

    public Capabilities capabilities() {
        return CapableOf.REPORTING;
    }

    public void flush() {
    }

    public void close() {
    }

    public void reportCounter(String name, Map<String, String> tags, long value) {
        Metrics.counter((String)name, this.getTags(tags)).increment((double)value);
    }

    public void reportGauge(String name, Map<String, String> tags, double value) {
        AtomicDouble gauge = this.gauges.computeIfAbsent(name, metricName -> {
            AtomicDouble result = (AtomicDouble)Metrics.gauge((String)name, this.getTags(tags), (Number)new AtomicDouble());
            Preconditions.checkNotNull((Object)result, (Object)"Metrics.gauge should not return null ever");
            return result;
        });
        gauge.set(value);
    }

    public void reportTimer(String name, Map<String, String> tags, Duration interval) {
        Metrics.timer((String)name, this.getTags(tags)).record(interval.getNanos(), TimeUnit.NANOSECONDS);
    }

    public void reportHistogramValueSamples(String name, Map<String, String> tags, Buckets buckets, double bucketLowerBound, double bucketUpperBound, long samples) {
    }

    public void reportHistogramDurationSamples(String name, Map<String, String> tags, Buckets buckets, Duration bucketLowerBound, Duration bucketUpperBound, long samples) {
    }

    private Iterable<Tag> getTags(Map<String, String> tags) {
        HashMap<String, String> tmpMap = new HashMap<String, String>(tags);
        tmpMap.put("ActivityType", Strings.nullToEmpty((String)tags.get("ActivityType")));
        tmpMap.put("Domain", Strings.nullToEmpty((String)tags.get("Domain")));
        tmpMap.put("TaskList", Strings.nullToEmpty((String)tags.get("TaskList")));
        tmpMap.put("WorkflowType", Strings.nullToEmpty((String)tags.get("WorkflowType")));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, String> entry : tmpMap.entrySet()) {
            Tag tag = Tag.of((String)entry.getKey(), (String)entry.getValue());
            builder.add((Object)tag);
        }
        return builder.build();
    }
}

