/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.serviceclient.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.uber.cadence.serviceclient.auth.IAuthorizationProvider;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.sql.Date;
import java.time.Clock;

public class AdminJwtAuthorizationProvider
implements IAuthorizationProvider {
    private final RSAPrivateKey rsaPrivateKey;
    private final RSAPublicKey rsaPublicKey;

    public AdminJwtAuthorizationProvider(RSAPublicKey publicKey, RSAPrivateKey privateKey) {
        this.rsaPrivateKey = privateKey;
        this.rsaPublicKey = publicKey;
    }

    @Override
    public byte[] getAuthToken() {
        JWTCreator.Builder jwtBuilder = JWT.create();
        jwtBuilder.withClaim("admin", Boolean.valueOf(true));
        jwtBuilder.withClaim("ttl", Integer.valueOf(600));
        jwtBuilder.withIssuedAt(Date.from(Clock.systemUTC().instant()));
        return jwtBuilder.sign(Algorithm.RSA256((RSAPublicKey)this.rsaPublicKey, (RSAPrivateKey)this.rsaPrivateKey)).getBytes(StandardCharsets.UTF_8);
    }
}

