/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.testing;

import com.google.common.annotations.VisibleForTesting;
import com.uber.cadence.client.WorkflowClientOptions;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.worker.WorkerFactoryOptions;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.util.Objects;
import java.util.function.Function;

@VisibleForTesting
public final class TestEnvironmentOptions {
    private final DataConverter dataConverter;
    private final Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory;
    private final boolean enableLoggingInReplay;
    private final WorkerFactoryOptions workerFactoryOptions;
    private final WorkflowClientOptions workflowClientOptions;

    private TestEnvironmentOptions(DataConverter dataConverter, Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory, WorkerFactoryOptions options, WorkflowClientOptions workflowClientOptions, boolean enableLoggingInReplay) {
        this.dataConverter = dataConverter;
        this.interceptorFactory = interceptorFactory;
        this.workerFactoryOptions = options;
        this.workflowClientOptions = workflowClientOptions;
        this.enableLoggingInReplay = enableLoggingInReplay;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public Function<WorkflowInterceptor, WorkflowInterceptor> getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public boolean isLoggingEnabledInReplay() {
        return this.enableLoggingInReplay;
    }

    public WorkerFactoryOptions getWorkerFactoryOptions() {
        return this.workerFactoryOptions;
    }

    public WorkflowClientOptions getWorkflowClientOptions() {
        return this.workflowClientOptions;
    }

    public String toString() {
        return "TestEnvironmentOptions{dataConverter=" + this.dataConverter + ", workerFactoryOptions=" + this.workerFactoryOptions + ", workflowClientOptions=" + this.workflowClientOptions + '}';
    }

    public static final class Builder {
        private DataConverter dataConverter = JsonDataConverter.getInstance();
        private Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory = n -> n;
        private boolean enableLoggingInReplay;
        private WorkerFactoryOptions factoryOptions;
        private WorkflowClientOptions workflowClientOptions = WorkflowClientOptions.defaultInstance();

        public Builder setWorkflowClientOptions(WorkflowClientOptions workflowClientOptions) {
            this.workflowClientOptions = workflowClientOptions;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = Objects.requireNonNull(dataConverter);
            return this;
        }

        public Builder setInterceptorFactory(Function<WorkflowInterceptor, WorkflowInterceptor> interceptorFactory) {
            this.interceptorFactory = Objects.requireNonNull(interceptorFactory);
            return this;
        }

        public Builder setWorkerFactoryOptions(WorkerFactoryOptions options) {
            this.factoryOptions = options;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public TestEnvironmentOptions build() {
            if (this.factoryOptions == null) {
                this.factoryOptions = WorkerFactoryOptions.newBuilder().setDisableStickyExecution(false).build();
            }
            return new TestEnvironmentOptions(this.dataConverter, this.interceptorFactory, this.factoryOptions, this.workflowClientOptions, this.enableLoggingInReplay);
        }
    }
}

