/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.google.common.collect.Sets;
import com.uber.cadence.internal.shadowing.QueryBuilder;
import com.uber.cadence.shadower.ExitCondition;
import com.uber.cadence.shadower.Mode;
import com.uber.cadence.worker.TimeFilter;
import com.uber.cadence.worker.WorkflowStatus;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public final class ShadowingOptions {
    private static final ShadowingOptions DEFAULT_INSTANCE = ShadowingOptions.newBuilder().build();
    private final String domain;
    private final Mode shadowMode;
    private final String workflowQuery;
    private final Set<String> workflowTypes;
    private final TimeFilter workflowStartTimeFilter;
    private final Set<WorkflowStatus> workflowStatuses;
    private final double samplingRate;
    private final ExitCondition exitCondition;
    private int concurrency;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ShadowingOptions options) {
        return new Builder(options);
    }

    public static ShadowingOptions defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private ShadowingOptions(String domain, Mode shadowMode, String workflowQuery, Set<String> workflowTypes, TimeFilter workflowStartTimeFilter, Set<WorkflowStatus> workflowStatuses, double samplingRate, ExitCondition exitCondition, int concurrency) {
        this.domain = domain;
        this.shadowMode = shadowMode;
        this.workflowQuery = workflowQuery;
        this.workflowTypes = workflowTypes;
        this.workflowStartTimeFilter = workflowStartTimeFilter;
        this.workflowStatuses = workflowStatuses;
        this.samplingRate = samplingRate;
        this.exitCondition = exitCondition;
        this.concurrency = concurrency;
    }

    public String getDomain() {
        return this.domain;
    }

    public Mode getShadowMode() {
        return this.shadowMode;
    }

    public String getWorkflowQuery() {
        return this.workflowQuery;
    }

    public Collection<String> getWorkflowTypes() {
        return this.workflowTypes;
    }

    public TimeFilter getWorkflowStartTimeFilter() {
        return this.workflowStartTimeFilter;
    }

    public Collection<WorkflowStatus> getWorkflowStatuses() {
        return this.workflowStatuses;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public ExitCondition getExitCondition() {
        return this.exitCondition;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public String toString() {
        return "ShadowOptions{, domain=" + this.domain + ", shadowMode=" + (Object)((Object)this.shadowMode) + ", workflowQuery=" + this.workflowQuery + ", workflowTypes=" + this.workflowTypes.toString() + ", workflowStatusesFilter=" + this.workflowStatuses.toString() + ", samplingRate=" + this.samplingRate + ", exitCondition=" + this.exitCondition.toString() + ", concurrency=" + this.concurrency + '}';
    }

    public static final class Builder {
        private String domain = "";
        private Mode shadowMode = Mode.Normal;
        private String workflowQuery = "";
        private Set<String> workflowTypes = Sets.newHashSet();
        private TimeFilter workflowStartTimeFilter = TimeFilter.defaultInstance();
        private Set<WorkflowStatus> workflowStatuses = Sets.newHashSet((Object[])new WorkflowStatus[]{WorkflowStatus.OPEN});
        private double samplingRate = 1.0;
        private ExitCondition exitCondition = new ExitCondition();
        private int concurrency = 1;

        private Builder() {
        }

        private Builder(ShadowingOptions options) {
            this.domain = options.domain;
            this.shadowMode = options.shadowMode;
            this.workflowQuery = options.getWorkflowQuery();
            this.workflowTypes = options.workflowTypes;
            this.workflowStartTimeFilter = options.workflowStartTimeFilter;
            this.workflowStatuses = options.workflowStatuses;
            this.samplingRate = options.samplingRate;
            this.exitCondition = options.exitCondition;
            this.concurrency = options.concurrency;
        }

        public Builder setDomain(String domain) {
            Objects.requireNonNull(domain);
            if (domain.length() == 0) {
                throw new IllegalArgumentException("Empty domain value");
            }
            this.domain = domain;
            return this;
        }

        public Builder setShadowMode(Mode mode) {
            this.shadowMode = Objects.requireNonNull(mode);
            return this;
        }

        public Builder setWorkflowQuery(String workflowQuery) {
            this.workflowQuery = Objects.requireNonNull(workflowQuery);
            return this;
        }

        public Builder setWorkflowTypes(Collection<String> workflowTypes) {
            Objects.requireNonNull(workflowTypes);
            this.workflowTypes = Sets.newHashSet(workflowTypes);
            return this;
        }

        public Builder setWorkflowStartTimeFilter(TimeFilter workflowStartTimeFilter) {
            this.workflowStartTimeFilter = Objects.requireNonNull(workflowStartTimeFilter);
            return this;
        }

        public Builder setWorkflowStatuses(Collection<WorkflowStatus> workflowStatuses) {
            Objects.requireNonNull(workflowStatuses);
            this.workflowStatuses = Sets.newHashSet(workflowStatuses);
            if (workflowStatuses.size() == 0) {
                this.workflowStatuses.add(WorkflowStatus.OPEN);
            }
            return this;
        }

        public Builder setWorkflowSamplingRate(double samplingRate) {
            if (samplingRate <= 0.0 || samplingRate > 1.0) {
                throw new IllegalArgumentException("Negative or larger than one: " + samplingRate);
            }
            this.samplingRate = samplingRate;
            return this;
        }

        public Builder setExitCondition(ExitCondition exitCondition) {
            this.exitCondition = Objects.requireNonNull(exitCondition);
            return this;
        }

        public Builder setConcurrency(int concurrency) {
            if ((double)concurrency <= 0.0 || this.samplingRate > 1.0) {
                throw new IllegalArgumentException("Negative or zero: " + concurrency);
            }
            this.concurrency = concurrency;
            return this;
        }

        public ShadowingOptions build() {
            if (this.shadowMode == Mode.Continuous && this.exitCondition.getShadowCount() == 0 && this.exitCondition.getExpirationIntervalInSeconds() == 0) {
                throw new IllegalArgumentException("exit condition must be specified if shadow mode is set to continuous");
            }
            if (!(this.workflowQuery.isEmpty() || this.workflowTypes.isEmpty() && this.workflowStartTimeFilter.isEmpty() && this.workflowStatuses.size() == 1 && this.workflowStatuses.contains((Object)WorkflowStatus.OPEN))) {
                throw new IllegalArgumentException("workflow types, status and start time filter can't be specified when workflow query is specified");
            }
            if (this.workflowQuery.isEmpty()) {
                this.workflowQuery = QueryBuilder.newQueryBuilder().setWorkflowStatuses(this.workflowStatuses).setWorkflowStartTime(this.workflowStartTimeFilter).setWorkflowTypes(this.workflowTypes).build();
            }
            return new ShadowingOptions(this.domain, this.shadowMode, this.workflowQuery, this.workflowTypes, this.workflowStartTimeFilter, this.workflowStatuses, this.samplingRate, this.exitCondition, this.concurrency);
        }
    }
}

