/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.google.common.base.MoreObjects;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.TaskList;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivity;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivityImpl;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivityImpl;
import com.uber.cadence.internal.sync.SyncActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.Suspendable;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.shadower.WorkflowParams;
import com.uber.cadence.testing.TestEnvironmentOptions;
import com.uber.cadence.worker.ShadowingOptions;
import com.uber.cadence.worker.WorkerOptions;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSimpleJSONProtocol;

public final class ShadowingWorker
implements Suspendable {
    private final IWorkflowService service;
    private final SyncActivityWorker activityWorker;
    private final ReplayWorkflowActivity replayActivity;
    private final String taskList;
    private final ShadowingOptions shadowingOptions;
    private final AtomicBoolean started = new AtomicBoolean();

    public ShadowingWorker(WorkflowClient client, String taskList, WorkerOptions options, ShadowingOptions shadowingOptions) {
        this(client, taskList, options, shadowingOptions, new TestEnvironmentOptions.Builder().build());
    }

    public ShadowingWorker(WorkflowClient client, String taskList, WorkerOptions options, ShadowingOptions shadowingOptions, TestEnvironmentOptions testOptions) {
        options = (WorkerOptions)MoreObjects.firstNonNull((Object)options, (Object)WorkerOptions.defaultInstance());
        this.shadowingOptions = Objects.requireNonNull(shadowingOptions);
        this.taskList = shadowingOptions.getDomain() + "-" + taskList;
        this.service = client.getService();
        Scope metricsScope = client.getOptions().getMetricsScope().tagged((Map)ImmutableMap.of((Object)"Domain", (Object)shadowingOptions.getDomain(), (Object)"TaskList", (Object)this.taskList));
        ScanWorkflowActivityImpl scanActivity = new ScanWorkflowActivityImpl(client.getService());
        this.replayActivity = new ReplayWorkflowActivityImpl(client.getService(), metricsScope, taskList, testOptions);
        SingleWorkerOptions activityOptions = SingleWorkerOptions.newBuilder().setIdentity(client.getOptions().getIdentity()).setDataConverter(client.getOptions().getDataConverter()).setTaskExecutorThreadPoolSize(options.getMaxConcurrentActivityExecutionSize()).setTaskListActivitiesPerSecond(options.getTaskListActivitiesPerSecond()).setPollerOptions(options.getActivityPollerOptions()).setMetricsScope(metricsScope).build();
        this.activityWorker = new SyncActivityWorker(client.getService(), "cadence-shadower", this.taskList, activityOptions);
        this.activityWorker.setActivitiesImplementation(scanActivity, this.replayActivity);
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.startShadowingWorkflow();
        this.activityWorker.start();
    }

    public void shutdown() {
        this.activityWorker.shutdown();
    }

    public void shutdownNow() {
        this.activityWorker.shutdownNow();
    }

    public boolean isTerminated() {
        return this.activityWorker.isTerminated();
    }

    public void awaitTermination(long timeout, TimeUnit unit) {
        InternalUtils.awaitTermination(this.activityWorker, unit.toMillis(timeout));
    }

    @Override
    public void suspendPolling() {
        this.activityWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.activityWorker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.activityWorker.isSuspended();
    }

    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        this.replayActivity.registerWorkflowImplementationTypes(workflowImplementationClasses);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        this.replayActivity.registerWorkflowImplementationTypesWithOptions(options, workflowImplementationClasses);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.replayActivity.addWorkflowImplementationFactoryWithOptions(options, workflowInterface, factory);
    }

    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.replayActivity.addWorkflowImplementationFactory(workflowInterface, factory);
    }

    protected void startShadowingWorkflow() throws Exception {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TSimpleJSONProtocol.Factory());
        WorkflowParams params = new WorkflowParams().setDomain(this.shadowingOptions.getDomain()).setConcurrency(this.shadowingOptions.getConcurrency()).setExitCondition(this.shadowingOptions.getExitCondition()).setShadowMode(this.shadowingOptions.getShadowMode()).setSamplingRate(this.shadowingOptions.getSamplingRate()).setTaskList(this.taskList).setWorkflowQuery(this.shadowingOptions.getWorkflowQuery());
        StartWorkflowExecutionRequest request = new StartWorkflowExecutionRequest().setDomain("cadence-shadower").setWorkflowId(this.shadowingOptions.getDomain() + "-shadow-workflow").setTaskList(new TaskList().setName("cadence-shadower-tl")).setInput(serializer.serialize((TBase)params)).setWorkflowType(new WorkflowType().setName("cadence-shadow-workflow")).setWorkflowIdReusePolicy(WorkflowIdReusePolicy.AllowDuplicate).setRequestId(UUID.randomUUID().toString()).setExecutionStartToCloseTimeoutSeconds(864000).setTaskStartToCloseTimeoutSeconds(60);
        try {
            RpcRetryer.retryWithResult(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, () -> this.service.StartWorkflowExecution(request));
        }
        catch (WorkflowExecutionAlreadyStartedError workflowExecutionAlreadyStartedError) {
            // empty catch block
        }
    }
}

