/*
 * Decompiled with CFR 0.152.
 */
package com.uber.h3core;

import com.uber.h3core.AreaUnit;
import com.uber.h3core.H3CoreLoader;
import com.uber.h3core.LengthUnit;
import com.uber.h3core.NativeMethods;
import com.uber.h3core.exceptions.PentagonEncounteredException;
import com.uber.h3core.util.GeoCoord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class H3Core {
    private static final int MAX_CELL_BNDRY_VERTS = 10;
    private static final long H3_RES_OFFSET = 52L;
    private static final long H3_RES_MASK = 0xF0000000000000L;
    private static final long H3_RES_MASK_NEGATIVE = -67553994410557441L;
    private static final long H3_DIGIT_MASK = 0x1FFFFFFFFFFFL;
    private final NativeMethods h3Api;

    public static H3Core newInstance() throws IOException {
        NativeMethods h3Api = H3CoreLoader.loadNatives();
        return new H3Core(h3Api);
    }

    public static H3Core newSystemInstance() {
        NativeMethods h3Api = H3CoreLoader.loadSystemNatives();
        return new H3Core(h3Api);
    }

    private H3Core(NativeMethods h3Api) {
        this.h3Api = h3Api;
    }

    private static double constrainLat(double lat) {
        return lat > 90.0 ? lat - 180.0 : lat;
    }

    private static double constrainLng(double lng) {
        return lng > 180.0 ? lng - 360.0 : lng;
    }

    public boolean h3IsValid(long h3) {
        return this.h3Api.h3IsValid(h3);
    }

    public boolean h3IsValid(String h3Address) {
        return this.h3IsValid(this.stringToH3(h3Address));
    }

    public int h3GetBaseCell(long h3) {
        return this.h3Api.h3GetBaseCell(h3);
    }

    public int h3GetBaseCell(String h3Address) {
        return this.h3GetBaseCell(this.stringToH3(h3Address));
    }

    public boolean h3IsPentagon(long h3) {
        return this.h3Api.h3IsPentagon(h3);
    }

    public boolean h3IsPentagon(String h3Address) {
        return this.h3IsPentagon(this.stringToH3(h3Address));
    }

    public long geoToH3(double lat, double lng, int res) {
        H3Core.checkResolution(res);
        long result = this.h3Api.geoToH3(Math.toRadians(lat), Math.toRadians(lng), res);
        if (result == 0L) {
            throw new IllegalArgumentException("Latitude or longitude were invalid.");
        }
        return result;
    }

    public String geoToH3Address(double lat, double lng, int res) {
        return this.h3ToString(this.geoToH3(lat, lng, res));
    }

    public GeoCoord h3ToGeo(long h3) {
        double[] coords = new double[2];
        this.h3Api.h3ToGeo(h3, coords);
        GeoCoord out = new GeoCoord(H3Core.constrainLat(Math.toDegrees(coords[0])), H3Core.constrainLng(Math.toDegrees(coords[1])));
        return out;
    }

    public GeoCoord h3ToGeo(String h3Address) {
        return this.h3ToGeo(this.stringToH3(h3Address));
    }

    public List<GeoCoord> h3ToGeoBoundary(long h3) {
        double[] verts = new double[20];
        int numVerts = this.h3Api.h3ToGeoBoundary(h3, verts);
        ArrayList<GeoCoord> out = new ArrayList<GeoCoord>(numVerts);
        for (int i = 0; i < numVerts; ++i) {
            GeoCoord coord = new GeoCoord(H3Core.constrainLat(Math.toDegrees(verts[i * 2])), H3Core.constrainLng(Math.toDegrees(verts[i * 2 + 1])));
            out.add(coord);
        }
        return out;
    }

    public List<GeoCoord> h3ToGeoBoundary(String h3Address) {
        return this.h3ToGeoBoundary(this.stringToH3(h3Address));
    }

    public List<String> kRing(String h3Address, int k) {
        return this.h3ToStringList(this.kRing(this.stringToH3(h3Address), k));
    }

    public List<List<String>> kRings(String h3Address, int k) {
        ArrayList<List<String>> result = new ArrayList<List<String>>(k + 1);
        result.add(Collections.singletonList(h3Address));
        for (int i = 1; i <= k; ++i) {
            result.add(this.kRing(h3Address, i));
        }
        return result;
    }

    public List<Long> kRing(long h3, int k) {
        int sz = this.h3Api.maxKringSize(k);
        long[] out = new long[sz];
        this.h3Api.kRing(h3, k, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public List<List<String>> kRingDistances(String h3Address, int k) {
        List<List<Long>> rings = this.kRingDistances(this.stringToH3(h3Address), k);
        return rings.stream().map(this::h3ToStringList).collect(Collectors.toList());
    }

    public List<List<Long>> kRingDistances(long h3, int k) {
        int i;
        int sz = this.h3Api.maxKringSize(k);
        long[] out = new long[sz];
        int[] distances = new int[sz];
        this.h3Api.kRingDistances(h3, k, out, distances);
        ArrayList<List<Long>> ret = new ArrayList<List<Long>>(k + 1);
        for (i = 0; i <= k; ++i) {
            ret.add(new ArrayList());
        }
        for (i = 0; i < sz; ++i) {
            long nextH3 = out[i];
            if (nextH3 == 0L) continue;
            ((List)ret.get(distances[i])).add(nextH3);
        }
        return ret;
    }

    public List<List<String>> hexRange(String h3Address, int k) throws PentagonEncounteredException {
        List<List<Long>> rings = this.hexRange(this.stringToH3(h3Address), k);
        return rings.stream().map(this::h3ToStringList).collect(Collectors.toList());
    }

    public List<List<Long>> hexRange(long h3, int k) throws PentagonEncounteredException {
        int sz = this.h3Api.maxKringSize(k);
        long[] out = new long[sz];
        if (this.h3Api.hexRange(h3, k, out) != 0) {
            throw new PentagonEncounteredException("A pentagon was encountered while computing hexRange.");
        }
        ArrayList<List<Long>> ret = new ArrayList<List<Long>>(k + 1);
        ArrayList<Long> ring = null;
        int currentK = 0;
        int nextRing = 0;
        for (int i = 0; i < sz; ++i) {
            if (i == nextRing) {
                ring = new ArrayList<Long>();
                ret.add(ring);
                nextRing = currentK == 0 ? 1 : (nextRing += 6 * currentK);
                ++currentK;
            }
            long h = out[i];
            ring.add(h);
        }
        return ret;
    }

    public List<String> hexRing(String h3Address, int k) throws PentagonEncounteredException {
        return this.h3ToStringList(this.hexRing(this.stringToH3(h3Address), k));
    }

    public List<Long> hexRing(long h3, int k) throws PentagonEncounteredException {
        int sz = k == 0 ? 1 : 6 * k;
        long[] out = new long[sz];
        if (this.h3Api.hexRing(h3, k, out) != 0) {
            throw new PentagonEncounteredException("A pentagon was encountered while computing hexRing.");
        }
        return H3Core.nonZeroLongArrayToList(out);
    }

    public List<String> polyfillAddress(List<GeoCoord> points, List<List<GeoCoord>> holes, int res) {
        return this.h3ToStringList(this.polyfill(points, holes, res));
    }

    public List<Long> polyfill(List<GeoCoord> points, List<List<GeoCoord>> holes, int res) {
        H3Core.checkResolution(res);
        double[] verts = new double[points.size() * 2];
        H3Core.packGeofenceVertices(verts, points, 0);
        int[] holeSizes = new int[]{};
        double[] holeVerts = new double[]{};
        if (holes != null) {
            holeSizes = new int[holes.size()];
            int totalSize = 0;
            for (int i = 0; i < holes.size(); ++i) {
                totalSize += holes.get(i).size() * 2;
                holeSizes[i] = holes.get(i).size() * 2;
            }
            holeVerts = new double[totalSize];
            int offset = 0;
            for (int i = 0; i < holes.size(); ++i) {
                offset = H3Core.packGeofenceVertices(holeVerts, holes.get(i), offset);
            }
        }
        int sz = this.h3Api.maxPolyfillSize(verts, holeSizes, holeVerts, res);
        long[] results = new long[sz];
        this.h3Api.polyfill(verts, holeSizes, holeVerts, res, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    private static int packGeofenceVertices(double[] arr, List<GeoCoord> original, int offset) {
        assert (arr.length >= original.size() * 2 + offset);
        for (int i = 0; i < original.size(); ++i) {
            GeoCoord coord = original.get(i);
            arr[i * 2 + offset] = Math.toRadians(H3Core.constrainLat(coord.lat));
            arr[i * 2 + 1 + offset] = Math.toRadians(H3Core.constrainLng(coord.lng));
        }
        return original.size() * 2 + offset;
    }

    public List<List<List<GeoCoord>>> h3AddressSetToMultiPolygon(Collection<String> h3Addresses, boolean geoJson) {
        List<Long> indices = this.stringToH3List(h3Addresses);
        return this.h3SetToMultiPolygon(indices, geoJson);
    }

    public List<List<List<GeoCoord>>> h3SetToMultiPolygon(Collection<Long> h3, boolean geoJson) {
        long[] h3AsArray = H3Core.collectionToLongArray(h3);
        ArrayList<List<List<GeoCoord>>> result = new ArrayList<List<List<GeoCoord>>>();
        this.h3Api.h3SetToLinkedGeo(h3AsArray, result);
        for (List<List<GeoCoord>> loops : result) {
            for (List<GeoCoord> loop : loops) {
                for (int vectorInLoop = 0; vectorInLoop < loop.size(); ++vectorInLoop) {
                    GeoCoord v = loop.get(vectorInLoop);
                    double origLat = H3Core.constrainLat(Math.toDegrees(v.lat));
                    double origLng = H3Core.constrainLng(Math.toDegrees(v.lng));
                    GeoCoord replacement = new GeoCoord(origLat, origLng);
                    loop.set(vectorInLoop, replacement);
                }
                if (!geoJson || loop.size() <= 0) continue;
                loop.add(loop.get(0));
            }
        }
        return result;
    }

    public int h3GetResolution(String h3Address) {
        return this.h3GetResolution(this.stringToH3(h3Address));
    }

    public int h3GetResolution(long h3) {
        return (int)((h3 & 0xF0000000000000L) >> 52);
    }

    public long h3ToParent(long h3, int res) {
        H3Core.checkResolution(res);
        int childRes = (int)((h3 & 0xF0000000000000L) >> 52);
        if (res < 0 || res > childRes) {
            throw new IllegalArgumentException(String.format("res (%d) must be between 0 and %d, inclusive", res, childRes));
        }
        if (res == childRes) {
            return h3;
        }
        long newRes = (long)res << 52;
        long digitMaskForRes = 0x1FFFFFFFFFFFL;
        for (int i = 0; i < res; ++i) {
            digitMaskForRes >>= 3;
        }
        return h3 & 0xFF0FFFFFFFFFFFFFL | newRes | digitMaskForRes;
    }

    public String h3ToParentAddress(String h3Address, int res) {
        long parent = this.h3ToParent(this.stringToH3(h3Address), res);
        return this.h3ToString(parent);
    }

    public List<String> h3ToChildren(String h3Address, int childRes) {
        return this.h3ToStringList(this.h3ToChildren(this.stringToH3(h3Address), childRes));
    }

    public List<Long> h3ToChildren(long h3, int childRes) {
        H3Core.checkResolution(childRes);
        int sz = this.h3Api.maxH3ToChildrenSize(h3, childRes);
        long[] out = new long[sz];
        this.h3Api.h3ToChildren(h3, childRes, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public boolean h3IsResClassIII(String h3Address) {
        return this.h3IsResClassIII(this.stringToH3(h3Address));
    }

    public boolean h3IsResClassIII(long h3) {
        return this.h3GetResolution(h3) % 2 != 0;
    }

    public List<String> compactAddress(Collection<String> h3Addresses) {
        List<Long> h3 = this.stringToH3List(h3Addresses);
        List<Long> compacted = this.compact(h3);
        return this.h3ToStringList(compacted);
    }

    public List<Long> compact(Collection<Long> h3) {
        long[] out;
        int sz = h3.size();
        long[] h3AsArray = H3Core.collectionToLongArray(h3);
        int success = this.h3Api.compact(h3AsArray, out = new long[sz]);
        if (success != 0) {
            throw new IllegalArgumentException("Bad input to compact");
        }
        return H3Core.nonZeroLongArrayToList(out);
    }

    public List<String> uncompactAddress(Collection<String> h3Addresses, int res) {
        List<Long> h3 = this.stringToH3List(h3Addresses);
        List<Long> uncompacted = this.uncompact(h3, res);
        return this.h3ToStringList(uncompacted);
    }

    public List<Long> uncompact(Collection<Long> h3, int res) {
        H3Core.checkResolution(res);
        long[] h3AsArray = H3Core.collectionToLongArray(h3);
        int sz = this.h3Api.maxUncompactSize(h3AsArray, res);
        long[] out = new long[sz];
        int success = this.h3Api.uncompact(h3AsArray, res, out);
        if (success != 0) {
            throw new IllegalArgumentException("Bad input to uncompact");
        }
        return H3Core.nonZeroLongArrayToList(out);
    }

    public String h3ToString(long h3) {
        return Long.toHexString(h3);
    }

    public long stringToH3(String h3Address) {
        return Long.parseUnsignedLong(h3Address, 16);
    }

    public double hexArea(int res, AreaUnit unit) {
        H3Core.checkResolution(res);
        if (unit == AreaUnit.km2) {
            return this.h3Api.hexAreaKm2(res);
        }
        if (unit == AreaUnit.m2) {
            return this.h3Api.hexAreaM2(res);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public double edgeLength(int res, LengthUnit unit) {
        H3Core.checkResolution(res);
        if (unit == LengthUnit.km) {
            return this.h3Api.edgeLengthKm(res);
        }
        if (unit == LengthUnit.m) {
            return this.h3Api.edgeLengthM(res);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public long numHexagons(int res) {
        H3Core.checkResolution(res);
        return this.h3Api.numHexagons(res);
    }

    public boolean h3IndexesAreNeighbors(long a, long b) {
        return this.h3Api.h3IndexesAreNeighbors(a, b);
    }

    public boolean h3IndexesAreNeighbors(String a, String b) {
        return this.h3IndexesAreNeighbors(this.stringToH3(a), this.stringToH3(b));
    }

    public long getH3UnidirectionalEdge(long a, long b) {
        long index = this.h3Api.getH3UnidirectionalEdge(a, b);
        if (index == 0L) {
            throw new IllegalArgumentException("Given indexes are not neighbors.");
        }
        return index;
    }

    public String getH3UnidirectionalEdge(String a, String b) {
        return this.h3ToString(this.getH3UnidirectionalEdge(this.stringToH3(a), this.stringToH3(b)));
    }

    public boolean h3UnidirectionalEdgeIsValid(long h3) {
        return this.h3Api.h3UnidirectionalEdgeIsValid(h3);
    }

    public boolean h3UnidirectionalEdgeIsValid(String h3) {
        return this.h3UnidirectionalEdgeIsValid(this.stringToH3(h3));
    }

    public long getOriginH3IndexFromUnidirectionalEdge(long h3) {
        return this.h3Api.getOriginH3IndexFromUnidirectionalEdge(h3);
    }

    public String getOriginH3IndexFromUnidirectionalEdge(String h3) {
        return this.h3ToString(this.getOriginH3IndexFromUnidirectionalEdge(this.stringToH3(h3)));
    }

    public long getDestinationH3IndexFromUnidirectionalEdge(long h3) {
        return this.h3Api.getDestinationH3IndexFromUnidirectionalEdge(h3);
    }

    public String getDestinationH3IndexFromUnidirectionalEdge(String h3) {
        return this.h3ToString(this.getDestinationH3IndexFromUnidirectionalEdge(this.stringToH3(h3)));
    }

    public List<Long> getH3IndexesFromUnidirectionalEdge(long h3) {
        long[] results = new long[2];
        this.h3Api.getH3IndexesFromUnidirectionalEdge(h3, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    public List<String> getH3IndexesFromUnidirectionalEdge(String h3) {
        return this.h3ToStringList(this.getH3IndexesFromUnidirectionalEdge(this.stringToH3(h3)));
    }

    public List<Long> getH3UnidirectionalEdgesFromHexagon(long h3) {
        long[] results = new long[6];
        this.h3Api.getH3UnidirectionalEdgesFromHexagon(h3, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    public List<String> getH3UnidirectionalEdgesFromHexagon(String h3) {
        return this.h3ToStringList(this.getH3UnidirectionalEdgesFromHexagon(this.stringToH3(h3)));
    }

    public List<GeoCoord> getH3UnidirectionalEdgeBoundary(long h3) {
        double[] verts = new double[20];
        int numVerts = this.h3Api.getH3UnidirectionalEdgeBoundary(h3, verts);
        ArrayList<GeoCoord> out = new ArrayList<GeoCoord>(numVerts);
        for (int i = 0; i < numVerts; ++i) {
            GeoCoord coord = new GeoCoord(H3Core.constrainLat(Math.toDegrees(verts[i * 2])), H3Core.constrainLng(Math.toDegrees(verts[i * 2 + 1])));
            out.add(coord);
        }
        return out;
    }

    public List<GeoCoord> getH3UnidirectionalEdgeBoundary(String h3) {
        return this.getH3UnidirectionalEdgeBoundary(this.stringToH3(h3));
    }

    private List<Long> stringToH3List(Collection<String> collection) {
        return collection.stream().map(this::stringToH3).collect(Collectors.toList());
    }

    private List<String> h3ToStringList(List<Long> list) {
        return list.stream().map(this::h3ToString).collect(Collectors.toList());
    }

    private static List<Long> nonZeroLongArrayToList(long[] out) {
        ArrayList<Long> ret = new ArrayList<Long>(out.length);
        for (int i = 0; i < out.length; ++i) {
            long h = out[i];
            if (h == 0L) continue;
            ret.add(h);
        }
        return ret;
    }

    private static long[] collectionToLongArray(Collection<Long> collection) {
        return collection.stream().mapToLong(Long::longValue).toArray();
    }

    private static void checkResolution(int res) {
        if (res < 0 || res > 15) {
            throw new IllegalArgumentException(String.format("resolution %d is out of range (must be 0 <= res <= 15)", res));
        }
    }
}

