/*
 * Decompiled with CFR 0.152.
 */
package com.uber.h3core;

import com.uber.h3core.AreaUnit;
import com.uber.h3core.H3CoreLoader;
import com.uber.h3core.LengthUnit;
import com.uber.h3core.NativeMethods;
import com.uber.h3core.util.CoordIJ;
import com.uber.h3core.util.LatLng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class H3Core {
    private static final int MAX_CELL_BNDRY_VERTS = 10;
    private static final int NUM_BASE_CELLS = 122;
    private static final int NUM_PENTAGONS = 12;
    private static final long H3_RES_OFFSET = 52L;
    private static final long H3_RES_MASK = 0xF0000000000000L;
    private static final long H3_RES_MASK_NEGATIVE = -67553994410557441L;
    private static final long H3_DIGIT_MASK = 0x1FFFFFFFFFFFL;
    private static final long INVALID_INDEX = 0L;
    private final NativeMethods h3Api;

    public static H3Core newInstance() throws IOException {
        NativeMethods h3Api = H3CoreLoader.loadNatives();
        return new H3Core(h3Api);
    }

    public static H3Core newInstance(H3CoreLoader.OperatingSystem os, String arch) throws IOException {
        NativeMethods h3Api = H3CoreLoader.loadNatives(os, arch);
        return new H3Core(h3Api);
    }

    public static H3Core newSystemInstance() {
        NativeMethods h3Api = H3CoreLoader.loadSystemNatives();
        return new H3Core(h3Api);
    }

    private H3Core(NativeMethods h3Api) {
        this.h3Api = h3Api;
    }

    public boolean isValidCell(long h3) {
        return this.h3Api.isValidCell(h3);
    }

    public boolean isValidCell(String h3Address) {
        return this.isValidCell(this.stringToH3(h3Address));
    }

    public int getBaseCellNumber(long h3) {
        return this.h3Api.getBaseCellNumber(h3);
    }

    public int getBaseCellNumber(String h3Address) {
        return this.getBaseCellNumber(this.stringToH3(h3Address));
    }

    public boolean isPentagon(long h3) {
        return this.h3Api.isPentagon(h3);
    }

    public boolean isPentagon(String h3Address) {
        return this.isPentagon(this.stringToH3(h3Address));
    }

    public long latLngToCell(double lat, double lng, int res) {
        H3Core.checkResolution(res);
        return this.h3Api.latLngToCell(Math.toRadians(lat), Math.toRadians(lng), res);
    }

    public String latLngToCellAddress(double lat, double lng, int res) {
        return this.h3ToString(this.latLngToCell(lat, lng, res));
    }

    public LatLng cellToLatLng(long h3) {
        double[] coords = new double[2];
        this.h3Api.cellToLatLng(h3, coords);
        LatLng out = new LatLng(Math.toDegrees(coords[0]), Math.toDegrees(coords[1]));
        return out;
    }

    public LatLng cellToLatLng(String h3Address) {
        return this.cellToLatLng(this.stringToH3(h3Address));
    }

    public List<LatLng> cellToBoundary(long h3) {
        double[] verts = new double[20];
        int numVerts = this.h3Api.cellToBoundary(h3, verts);
        ArrayList<LatLng> out = new ArrayList<LatLng>(numVerts);
        for (int i = 0; i < numVerts; ++i) {
            LatLng coord = new LatLng(Math.toDegrees(verts[i * 2]), Math.toDegrees(verts[i * 2 + 1]));
            out.add(coord);
        }
        return out;
    }

    public List<LatLng> cellToBoundary(String h3Address) {
        return this.cellToBoundary(this.stringToH3(h3Address));
    }

    public List<String> gridDisk(String h3Address, int k) {
        return this.h3ToStringList(this.gridDisk(this.stringToH3(h3Address), k));
    }

    public List<Long> gridDisk(long h3, int k) {
        int sz = H3Core.longToIntSize(this.h3Api.maxGridDiskSize(k));
        long[] out = new long[sz];
        this.h3Api.gridDisk(h3, k, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public List<List<String>> gridDiskDistances(String h3Address, int k) {
        List<List<Long>> rings = this.gridDiskDistances(this.stringToH3(h3Address), k);
        return rings.stream().map(this::h3ToStringList).collect(Collectors.toList());
    }

    public List<List<Long>> gridDiskDistances(long h3, int k) {
        int i;
        int sz = H3Core.longToIntSize(this.h3Api.maxGridDiskSize(k));
        long[] out = new long[sz];
        int[] distances = new int[sz];
        this.h3Api.gridDiskDistances(h3, k, out, distances);
        ArrayList<List<Long>> ret = new ArrayList<List<Long>>(k + 1);
        for (i = 0; i <= k; ++i) {
            ret.add(new ArrayList());
        }
        for (i = 0; i < sz; ++i) {
            long nextH3 = out[i];
            if (nextH3 == 0L) continue;
            ((List)ret.get(distances[i])).add(nextH3);
        }
        return ret;
    }

    public List<List<String>> gridDiskUnsafe(String h3Address, int k) {
        List<List<Long>> rings = this.gridDiskUnsafe(this.stringToH3(h3Address), k);
        return rings.stream().map(this::h3ToStringList).collect(Collectors.toList());
    }

    public List<List<Long>> gridDiskUnsafe(long h3, int k) {
        int sz = H3Core.longToIntSize(this.h3Api.maxGridDiskSize(k));
        long[] out = new long[sz];
        this.h3Api.gridDiskUnsafe(h3, k, out);
        ArrayList<List<Long>> ret = new ArrayList<List<Long>>(k + 1);
        ArrayList<Long> ring = null;
        int currentK = 0;
        int nextRing = 0;
        for (int i = 0; i < sz; ++i) {
            if (i == nextRing) {
                ring = new ArrayList<Long>();
                ret.add(ring);
                nextRing = currentK == 0 ? 1 : (nextRing += 6 * currentK);
                ++currentK;
            }
            long h = out[i];
            ring.add(h);
        }
        return ret;
    }

    public List<String> gridRingUnsafe(String h3Address, int k) {
        return this.h3ToStringList(this.gridRingUnsafe(this.stringToH3(h3Address), k));
    }

    public List<Long> gridRingUnsafe(long h3, int k) {
        int sz = k == 0 ? 1 : 6 * k;
        long[] out = new long[sz];
        this.h3Api.gridRingUnsafe(h3, k, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public long gridDistance(String a, String b) {
        return this.gridDistance(this.stringToH3(a), this.stringToH3(b));
    }

    public long gridDistance(long a, long b) {
        return this.h3Api.gridDistance(a, b);
    }

    public CoordIJ cellToLocalIj(long origin, long h3) {
        int[] coords = new int[2];
        this.h3Api.cellToLocalIj(origin, h3, coords);
        return new CoordIJ(coords[0], coords[1]);
    }

    public CoordIJ cellToLocalIj(String originAddress, String h3Address) {
        return this.cellToLocalIj(this.stringToH3(originAddress), this.stringToH3(h3Address));
    }

    public long localIjToCell(long origin, CoordIJ ij) {
        return this.h3Api.localIjToCell(origin, ij.i, ij.j);
    }

    public String localIjToCell(String originAddress, CoordIJ ij) {
        return this.h3ToString(this.localIjToCell(this.stringToH3(originAddress), ij));
    }

    public List<String> gridPathCells(String startAddress, String endAddress) {
        return this.h3ToStringList(this.gridPathCells(this.stringToH3(startAddress), this.stringToH3(endAddress)));
    }

    public List<Long> gridPathCells(long start, long end) {
        int size = H3Core.longToIntSize(this.h3Api.gridPathCellsSize(start, end));
        long[] results = new long[size];
        this.h3Api.gridPathCells(start, end, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    public List<String> polygonToCellAddresses(List<LatLng> points, List<List<LatLng>> holes, int res) {
        return this.h3ToStringList(this.polygonToCells(points, holes, res));
    }

    public List<Long> polygonToCells(List<LatLng> points, List<List<LatLng>> holes, int res) {
        H3Core.checkResolution(res);
        double[] verts = new double[points.size() * 2];
        H3Core.packGeofenceVertices(verts, points, 0);
        int[] holeSizes = new int[]{};
        double[] holeVerts = new double[]{};
        if (holes != null) {
            holeSizes = new int[holes.size()];
            int totalSize = 0;
            for (int i = 0; i < holes.size(); ++i) {
                totalSize += holes.get(i).size() * 2;
                holeSizes[i] = holes.get(i).size() * 2;
            }
            holeVerts = new double[totalSize];
            int offset = 0;
            for (int i = 0; i < holes.size(); ++i) {
                offset = H3Core.packGeofenceVertices(holeVerts, holes.get(i), offset);
            }
        }
        int flags = 0;
        int sz = H3Core.longToIntSize(this.h3Api.maxPolygonToCellsSize(verts, holeSizes, holeVerts, res, flags));
        long[] results = new long[sz];
        this.h3Api.polygonToCells(verts, holeSizes, holeVerts, res, flags, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    private static int packGeofenceVertices(double[] arr, List<LatLng> original, int offset) {
        assert (arr.length >= original.size() * 2 + offset);
        for (int i = 0; i < original.size(); ++i) {
            LatLng coord = original.get(i);
            arr[i * 2 + offset] = Math.toRadians(coord.lat);
            arr[i * 2 + 1 + offset] = Math.toRadians(coord.lng);
        }
        return original.size() * 2 + offset;
    }

    public List<List<List<LatLng>>> cellAddressesToMultiPolygon(Collection<String> h3Addresses, boolean geoJson) {
        List<Long> indices = this.stringToH3List(h3Addresses);
        return this.cellsToMultiPolygon(indices, geoJson);
    }

    public List<List<List<LatLng>>> cellsToMultiPolygon(Collection<Long> h3, boolean geoJson) {
        long[] h3AsArray = H3Core.collectionToLongArray(h3);
        ArrayList<List<List<LatLng>>> result = new ArrayList<List<List<LatLng>>>();
        this.h3Api.cellsToLinkedMultiPolygon(h3AsArray, result);
        for (List<List<LatLng>> loops : result) {
            for (List<LatLng> loop : loops) {
                for (int vectorInLoop = 0; vectorInLoop < loop.size(); ++vectorInLoop) {
                    LatLng v = loop.get(vectorInLoop);
                    double origLat = Math.toDegrees(v.lat);
                    double origLng = Math.toDegrees(v.lng);
                    LatLng replacement = new LatLng(origLat, origLng);
                    loop.set(vectorInLoop, replacement);
                }
                if (!geoJson || loop.size() <= 0) continue;
                loop.add(loop.get(0));
            }
        }
        return result;
    }

    public int getResolution(String h3Address) {
        return this.getResolution(this.stringToH3(h3Address));
    }

    public int getResolution(long h3) {
        return (int)((h3 & 0xF0000000000000L) >> 52);
    }

    public long cellToParent(long h3, int res) {
        int childRes = (int)((h3 & 0xF0000000000000L) >> 52);
        if (res < 0 || res > childRes) {
            throw new IllegalArgumentException(String.format("res (%d) must be between 0 and %d, inclusive", res, childRes));
        }
        if (res == childRes) {
            return h3;
        }
        long newRes = (long)res << 52;
        long digitMaskForRes = 0x1FFFFFFFFFFFL;
        for (int i = 0; i < res; ++i) {
            digitMaskForRes >>= 3;
        }
        return h3 & 0xFF0FFFFFFFFFFFFFL | newRes | digitMaskForRes;
    }

    public String cellToParentAddress(String h3Address, int res) {
        long parent = this.cellToParent(this.stringToH3(h3Address), res);
        return this.h3ToString(parent);
    }

    public List<String> cellToChildren(String h3Address, int childRes) {
        return this.h3ToStringList(this.cellToChildren(this.stringToH3(h3Address), childRes));
    }

    public List<Long> cellToChildren(long h3, int childRes) {
        H3Core.checkResolution(childRes);
        int sz = H3Core.longToIntSize(this.h3Api.cellToChildrenSize(h3, childRes));
        long[] out = new long[sz];
        this.h3Api.cellToChildren(h3, childRes, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public String cellToCenterChild(String h3, int childRes) {
        return this.h3ToString(this.cellToCenterChild(this.stringToH3(h3), childRes));
    }

    public long cellToCenterChild(long h3, int childRes) {
        H3Core.checkResolution(childRes);
        long result = this.h3Api.cellToCenterChild(h3, childRes);
        return result;
    }

    public boolean isResClassIII(String h3Address) {
        return this.isResClassIII(this.stringToH3(h3Address));
    }

    public boolean isResClassIII(long h3) {
        return this.getResolution(h3) % 2 != 0;
    }

    public List<String> compactCellAddresses(Collection<String> h3Addresses) {
        List<Long> h3 = this.stringToH3List(h3Addresses);
        List<Long> compacted = this.compactCells(h3);
        return this.h3ToStringList(compacted);
    }

    public List<Long> compactCells(Collection<Long> h3) {
        int sz = h3.size();
        long[] h3AsArray = H3Core.collectionToLongArray(h3);
        long[] out = new long[sz];
        this.h3Api.compactCells(h3AsArray, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public List<String> uncompactCellAddresses(Collection<String> h3Addresses, int res) {
        List<Long> h3 = this.stringToH3List(h3Addresses);
        List<Long> uncompacted = this.uncompactCells(h3, res);
        return this.h3ToStringList(uncompacted);
    }

    public List<Long> uncompactCells(Collection<Long> h3, int res) {
        H3Core.checkResolution(res);
        long[] h3AsArray = H3Core.collectionToLongArray(h3);
        int sz = H3Core.longToIntSize(this.h3Api.uncompactCellsSize(h3AsArray, res));
        long[] out = new long[sz];
        this.h3Api.uncompactCells(h3AsArray, res, out);
        return H3Core.nonZeroLongArrayToList(out);
    }

    public String h3ToString(long h3) {
        return Long.toHexString(h3);
    }

    public long stringToH3(String h3Address) {
        return Long.parseUnsignedLong(h3Address, 16);
    }

    public double cellArea(String h3Address, AreaUnit unit) {
        return this.cellArea(this.stringToH3(h3Address), unit);
    }

    public double cellArea(long h3, AreaUnit unit) {
        if (unit == AreaUnit.rads2) {
            return this.h3Api.cellAreaRads2(h3);
        }
        if (unit == AreaUnit.km2) {
            return this.h3Api.cellAreaKm2(h3);
        }
        if (unit == AreaUnit.m2) {
            return this.h3Api.cellAreaM2(h3);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public double distance(LatLng a, LatLng b, LengthUnit unit) {
        double lat1 = Math.toRadians(a.lat);
        double lng1 = Math.toRadians(a.lng);
        double lat2 = Math.toRadians(b.lat);
        double lng2 = Math.toRadians(b.lng);
        if (unit == LengthUnit.rads) {
            return this.h3Api.distanceRads(lat1, lng1, lat2, lng2);
        }
        if (unit == LengthUnit.km) {
            return this.h3Api.distanceKm(lat1, lng1, lat2, lng2);
        }
        if (unit == LengthUnit.m) {
            return this.h3Api.distanceM(lat1, lng1, lat2, lng2);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public double exactEdgeLength(String edgeAddress, LengthUnit unit) {
        return this.exactEdgeLength(this.stringToH3(edgeAddress), unit);
    }

    public double exactEdgeLength(long edge, LengthUnit unit) {
        if (unit == LengthUnit.rads) {
            return this.h3Api.exactEdgeLengthRads(edge);
        }
        if (unit == LengthUnit.km) {
            return this.h3Api.exactEdgeLengthKm(edge);
        }
        if (unit == LengthUnit.m) {
            return this.h3Api.exactEdgeLengthM(edge);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public double getHexagonAreaAvg(int res, AreaUnit unit) {
        H3Core.checkResolution(res);
        if (unit == AreaUnit.km2) {
            return this.h3Api.getHexagonAreaAvgKm2(res);
        }
        if (unit == AreaUnit.m2) {
            return this.h3Api.getHexagonAreaAvgM2(res);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public double getHexagonEdgeLengthAvg(int res, LengthUnit unit) {
        H3Core.checkResolution(res);
        if (unit == LengthUnit.km) {
            return this.h3Api.getHexagonEdgeLengthAvgKm(res);
        }
        if (unit == LengthUnit.m) {
            return this.h3Api.getHexagonEdgeLengthAvgM(res);
        }
        throw new IllegalArgumentException(String.format("Invalid unit: %s", new Object[]{unit}));
    }

    public long getNumCells(int res) {
        H3Core.checkResolution(res);
        return this.h3Api.getNumCells(res);
    }

    public Collection<String> getRes0CellAddresses() {
        return this.h3ToStringList(this.getRes0Cells());
    }

    public Collection<Long> getRes0Cells() {
        long[] indexes = new long[122];
        this.h3Api.getRes0Cells(indexes);
        return H3Core.nonZeroLongArrayToList(indexes);
    }

    public Collection<String> getPentagonAddresses(int res) {
        return this.h3ToStringList(this.getPentagons(res));
    }

    public Collection<Long> getPentagons(int res) {
        H3Core.checkResolution(res);
        long[] indexes = new long[12];
        this.h3Api.getPentagons(res, indexes);
        return H3Core.nonZeroLongArrayToList(indexes);
    }

    public boolean areNeighborCells(long a, long b) {
        return this.h3Api.areNeighborCells(a, b);
    }

    public boolean areNeighborCells(String a, String b) {
        return this.areNeighborCells(this.stringToH3(a), this.stringToH3(b));
    }

    public long cellsToDirectedEdge(long a, long b) {
        return this.h3Api.cellsToDirectedEdge(a, b);
    }

    public String cellsToDirectedEdge(String a, String b) {
        return this.h3ToString(this.cellsToDirectedEdge(this.stringToH3(a), this.stringToH3(b)));
    }

    public boolean isValidDirectedEdge(long h3) {
        return this.h3Api.isValidDirectedEdge(h3);
    }

    public boolean isValidDirectedEdge(String h3) {
        return this.isValidDirectedEdge(this.stringToH3(h3));
    }

    public long getDirectedEdgeOrigin(long h3) {
        return this.h3Api.getDirectedEdgeOrigin(h3);
    }

    public String getDirectedEdgeOrigin(String h3) {
        return this.h3ToString(this.getDirectedEdgeOrigin(this.stringToH3(h3)));
    }

    public long getDirectedEdgeDestination(long h3) {
        return this.h3Api.getDirectedEdgeDestination(h3);
    }

    public String getDirectedEdgeDestination(String h3) {
        return this.h3ToString(this.getDirectedEdgeDestination(this.stringToH3(h3)));
    }

    public List<Long> directedEdgeToCells(long h3) {
        long[] results = new long[2];
        this.h3Api.directedEdgeToCells(h3, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    public List<String> directedEdgeToCells(String h3) {
        return this.h3ToStringList(this.directedEdgeToCells(this.stringToH3(h3)));
    }

    public List<Long> originToDirectedEdges(long h3) {
        long[] results = new long[6];
        this.h3Api.originToDirectedEdges(h3, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    public List<String> originToDirectedEdges(String h3) {
        return this.h3ToStringList(this.originToDirectedEdges(this.stringToH3(h3)));
    }

    public List<LatLng> directedEdgeToBoundary(long h3) {
        double[] verts = new double[20];
        int numVerts = this.h3Api.directedEdgeToBoundary(h3, verts);
        ArrayList<LatLng> out = new ArrayList<LatLng>(numVerts);
        for (int i = 0; i < numVerts; ++i) {
            LatLng coord = new LatLng(Math.toDegrees(verts[i * 2]), Math.toDegrees(verts[i * 2 + 1]));
            out.add(coord);
        }
        return out;
    }

    public List<LatLng> directedEdgeToBoundary(String h3) {
        return this.directedEdgeToBoundary(this.stringToH3(h3));
    }

    public Collection<Integer> getIcosahedronFaces(String h3) {
        return this.getIcosahedronFaces(this.stringToH3(h3));
    }

    public Collection<Integer> getIcosahedronFaces(long h3) {
        int maxFaces = this.h3Api.maxFaceCount(h3);
        int[] faces = new int[maxFaces];
        this.h3Api.getIcosahedronFaces(h3, faces);
        return IntStream.of(faces).filter(f -> f != -1).boxed().collect(Collectors.toList());
    }

    public long cellToVertex(long h3, int vertexNum) {
        return this.h3Api.cellToVertex(h3, vertexNum);
    }

    public String cellToVertex(String h3Address, int vertexNum) {
        return this.h3ToString(this.h3Api.cellToVertex(this.stringToH3(h3Address), vertexNum));
    }

    public List<Long> cellToVertexes(long h3) {
        long[] results = new long[6];
        this.h3Api.cellToVertexes(h3, results);
        return H3Core.nonZeroLongArrayToList(results);
    }

    public List<String> cellToVertexes(String h3Address) {
        return this.h3ToStringList(this.cellToVertexes(this.stringToH3(h3Address)));
    }

    public LatLng vertexToLatLng(long h3) {
        double[] results = new double[2];
        this.h3Api.vertexToLatLng(h3, results);
        return new LatLng(Math.toDegrees(results[0]), Math.toDegrees(results[1]));
    }

    public LatLng vertexToLatLng(String h3Address) {
        return this.vertexToLatLng(this.stringToH3(h3Address));
    }

    public boolean isValidVertex(long h3) {
        return this.h3Api.isValidVertex(h3);
    }

    public boolean isValidVertex(String h3Address) {
        return this.h3Api.isValidVertex(this.stringToH3(h3Address));
    }

    private List<Long> stringToH3List(Collection<String> collection) {
        return collection.stream().map(this::stringToH3).collect(Collectors.toList());
    }

    private List<String> h3ToStringList(Collection<Long> collection) {
        return collection.stream().map(this::h3ToString).collect(Collectors.toList());
    }

    private static List<Long> nonZeroLongArrayToList(long[] out) {
        ArrayList<Long> ret = new ArrayList<Long>(out.length);
        for (int i = 0; i < out.length; ++i) {
            long h = out[i];
            if (h == 0L) continue;
            ret.add(h);
        }
        return ret;
    }

    private static long[] collectionToLongArray(Collection<Long> collection) {
        return collection.stream().mapToLong(Long::longValue).toArray();
    }

    private static void checkResolution(int res) {
        if (res < 0 || res > 15) {
            throw new IllegalArgumentException(String.format("resolution %d is out of range (must be 0 <= res <= 15)", res));
        }
    }

    private static int longToIntSize(long sz) {
        if (sz < 0L || sz > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("size %d is out of range", sz));
        }
        return (int)sz;
    }
}

