/*
 * Decompiled with CFR 0.152.
 */
package com.uber.h3core;

import com.uber.h3core.AreaUnit;
import com.uber.h3core.H3Core;
import com.uber.h3core.H3CoreLoader;
import com.uber.h3core.LengthUnit;
import com.uber.h3core.util.CoordIJ;
import com.uber.h3core.util.LatLng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class H3CoreV3 {
    private final H3Core h3Api;

    public static H3CoreV3 newInstance() throws IOException {
        return new H3CoreV3(H3Core.newInstance());
    }

    public static H3CoreV3 newInstance(H3CoreLoader.OperatingSystem os, String arch) throws IOException {
        return new H3CoreV3(H3Core.newInstance(os, arch));
    }

    public static H3CoreV3 newSystemInstance() {
        return new H3CoreV3(H3Core.newSystemInstance());
    }

    private H3CoreV3(H3Core h3Api) {
        this.h3Api = h3Api;
    }

    public boolean h3IsValid(long h3) {
        return this.h3Api.isValidCell(h3);
    }

    public boolean h3IsValid(String h3Address) {
        return this.h3Api.isValidCell(h3Address);
    }

    public int h3GetBaseCell(long h3) {
        return this.h3Api.getBaseCellNumber(h3);
    }

    public int h3GetBaseCell(String h3Address) {
        return this.h3Api.getBaseCellNumber(h3Address);
    }

    public boolean h3IsPentagon(long h3) {
        return this.h3Api.isPentagon(h3);
    }

    public boolean h3IsPentagon(String h3Address) {
        return this.h3Api.isPentagon(h3Address);
    }

    public long geoToH3(double lat, double lng, int res) {
        return this.h3Api.latLngToCell(lat, lng, res);
    }

    public String geoToH3Address(double lat, double lng, int res) {
        return this.h3Api.latLngToCellAddress(lat, lng, res);
    }

    public LatLng h3ToGeo(long h3) {
        return this.h3Api.cellToLatLng(h3);
    }

    public LatLng h3ToGeo(String h3Address) {
        return this.h3Api.cellToLatLng(h3Address);
    }

    public List<LatLng> h3ToGeoBoundary(long h3) {
        return this.h3Api.cellToBoundary(h3);
    }

    public List<LatLng> h3ToGeoBoundary(String h3Address) {
        return this.h3Api.cellToBoundary(h3Address);
    }

    public List<String> kRing(String h3Address, int k) {
        return this.h3Api.gridDisk(h3Address, k);
    }

    public List<List<String>> kRings(String h3Address, int k) {
        ArrayList<List<String>> result = new ArrayList<List<String>>(k + 1);
        result.add(Collections.singletonList(h3Address));
        for (int i = 1; i <= k; ++i) {
            result.add(this.kRing(h3Address, i));
        }
        return result;
    }

    public List<Long> kRing(long h3, int k) {
        return this.h3Api.gridDisk(h3, k);
    }

    public List<List<String>> kRingDistances(String h3Address, int k) {
        return this.h3Api.gridDiskDistances(h3Address, k);
    }

    public List<List<Long>> kRingDistances(long h3, int k) {
        return this.h3Api.gridDiskDistances(h3, k);
    }

    public List<List<String>> hexRange(String h3Address, int k) {
        return this.h3Api.gridDiskUnsafe(h3Address, k);
    }

    public List<List<Long>> hexRange(long h3, int k) {
        return this.h3Api.gridDiskUnsafe(h3, k);
    }

    public List<String> hexRing(String h3Address, int k) {
        return this.h3Api.gridRingUnsafe(h3Address, k);
    }

    public List<Long> hexRing(long h3, int k) {
        return this.h3Api.gridRingUnsafe(h3, k);
    }

    public int h3Distance(String a, String b) {
        return H3CoreV3.longToIntDistance(this.h3Api.gridDistance(a, b));
    }

    public int h3Distance(long a, long b) {
        return H3CoreV3.longToIntDistance(this.h3Api.gridDistance(a, b));
    }

    public CoordIJ experimentalH3ToLocalIj(long origin, long h3) {
        return this.h3Api.cellToLocalIj(origin, h3);
    }

    public CoordIJ experimentalH3ToLocalIj(String originAddress, String h3Address) {
        return this.h3Api.cellToLocalIj(originAddress, h3Address);
    }

    public long experimentalLocalIjToH3(long origin, CoordIJ ij) {
        return this.h3Api.localIjToCell(origin, ij);
    }

    public String experimentalLocalIjToH3(String originAddress, CoordIJ ij) {
        return this.h3Api.localIjToCell(originAddress, ij);
    }

    public List<String> h3Line(String startAddress, String endAddress) {
        return this.h3Api.gridPathCells(startAddress, endAddress);
    }

    public List<Long> h3Line(long start, long end) {
        return this.h3Api.gridPathCells(start, end);
    }

    public List<String> polyfillAddress(List<LatLng> points, List<List<LatLng>> holes, int res) {
        return this.h3Api.polygonToCellAddresses(points, holes, res);
    }

    public List<Long> polyfill(List<LatLng> points, List<List<LatLng>> holes, int res) {
        return this.h3Api.polygonToCells(points, holes, res);
    }

    public List<List<List<LatLng>>> h3AddressSetToMultiPolygon(Collection<String> h3Addresses, boolean geoJson) {
        return this.h3Api.cellAddressesToMultiPolygon(h3Addresses, geoJson);
    }

    public List<List<List<LatLng>>> h3SetToMultiPolygon(Collection<Long> h3, boolean geoJson) {
        return this.h3Api.cellsToMultiPolygon(h3, geoJson);
    }

    public int h3GetResolution(String h3Address) {
        return this.h3Api.getResolution(h3Address);
    }

    public int h3GetResolution(long h3) {
        return this.h3Api.getResolution(h3);
    }

    public long h3ToParent(long h3, int res) {
        return this.h3Api.cellToParent(h3, res);
    }

    public String h3ToParentAddress(String h3Address, int res) {
        return this.h3Api.cellToParentAddress(h3Address, res);
    }

    public List<String> h3ToChildren(String h3Address, int childRes) {
        return this.h3Api.cellToChildren(h3Address, childRes);
    }

    public List<Long> h3ToChildren(long h3, int childRes) {
        return this.h3Api.cellToChildren(h3, childRes);
    }

    public String h3ToCenterChild(String h3, int childRes) {
        return this.h3Api.cellToCenterChild(h3, childRes);
    }

    public long h3ToCenterChild(long h3, int childRes) {
        return this.h3Api.cellToCenterChild(h3, childRes);
    }

    public boolean h3IsResClassIII(String h3Address) {
        return this.h3Api.isResClassIII(h3Address);
    }

    public boolean h3IsResClassIII(long h3) {
        return this.h3Api.isResClassIII(h3);
    }

    public List<String> compactAddress(Collection<String> h3Addresses) {
        return this.h3Api.compactCellAddresses(h3Addresses);
    }

    public List<Long> compact(Collection<Long> h3) {
        return this.h3Api.compactCells(h3);
    }

    public List<String> uncompactAddress(Collection<String> h3Addresses, int res) {
        return this.h3Api.uncompactCellAddresses(h3Addresses, res);
    }

    public List<Long> uncompact(Collection<Long> h3, int res) {
        return this.h3Api.uncompactCells(h3, res);
    }

    public String h3ToString(long h3) {
        return Long.toHexString(h3);
    }

    public long stringToH3(String h3Address) {
        return Long.parseUnsignedLong(h3Address, 16);
    }

    public double cellArea(String h3Address, AreaUnit unit) {
        return this.h3Api.cellArea(h3Address, unit);
    }

    public double cellArea(long h3, AreaUnit unit) {
        return this.h3Api.cellArea(h3, unit);
    }

    public double pointDist(LatLng a, LatLng b, LengthUnit unit) {
        return this.h3Api.distance(a, b, unit);
    }

    public double exactEdgeLength(String edgeAddress, LengthUnit unit) {
        return this.h3Api.exactEdgeLength(edgeAddress, unit);
    }

    public double exactEdgeLength(long edge, LengthUnit unit) {
        return this.h3Api.exactEdgeLength(edge, unit);
    }

    public double hexArea(int res, AreaUnit unit) {
        return this.h3Api.getHexagonAreaAvg(res, unit);
    }

    public double edgeLength(int res, LengthUnit unit) {
        return this.h3Api.getHexagonEdgeLengthAvg(res, unit);
    }

    public long numHexagons(int res) {
        return this.h3Api.getNumCells(res);
    }

    public Collection<String> getRes0IndexesAddresses() {
        return this.h3Api.getRes0CellAddresses();
    }

    public Collection<Long> getRes0Indexes() {
        return this.h3Api.getRes0Cells();
    }

    public Collection<String> getPentagonIndexesAddresses(int res) {
        return this.h3Api.getPentagonAddresses(res);
    }

    public Collection<Long> getPentagonIndexes(int res) {
        return this.h3Api.getPentagons(res);
    }

    public boolean h3IndexesAreNeighbors(long a, long b) {
        return this.h3Api.areNeighborCells(a, b);
    }

    public boolean h3IndexesAreNeighbors(String a, String b) {
        return this.h3Api.areNeighborCells(a, b);
    }

    public long getH3UnidirectionalEdge(long a, long b) {
        return this.h3Api.cellsToDirectedEdge(a, b);
    }

    public String getH3UnidirectionalEdge(String a, String b) {
        return this.h3Api.cellsToDirectedEdge(a, b);
    }

    public boolean h3UnidirectionalEdgeIsValid(long h3) {
        return this.h3Api.isValidDirectedEdge(h3);
    }

    public boolean h3UnidirectionalEdgeIsValid(String h3) {
        return this.h3Api.isValidDirectedEdge(h3);
    }

    public long getOriginH3IndexFromUnidirectionalEdge(long h3) {
        return this.h3Api.getDirectedEdgeOrigin(h3);
    }

    public String getOriginH3IndexFromUnidirectionalEdge(String h3) {
        return this.h3Api.getDirectedEdgeOrigin(h3);
    }

    public long getDestinationH3IndexFromUnidirectionalEdge(long h3) {
        return this.h3Api.getDirectedEdgeDestination(h3);
    }

    public String getDestinationH3IndexFromUnidirectionalEdge(String h3) {
        return this.h3Api.getDirectedEdgeDestination(h3);
    }

    public List<Long> getH3IndexesFromUnidirectionalEdge(long h3) {
        return this.h3Api.directedEdgeToCells(h3);
    }

    public List<String> getH3IndexesFromUnidirectionalEdge(String h3) {
        return this.h3Api.directedEdgeToCells(h3);
    }

    public List<Long> getH3UnidirectionalEdgesFromHexagon(long h3) {
        return this.h3Api.originToDirectedEdges(h3);
    }

    public List<String> getH3UnidirectionalEdgesFromHexagon(String h3) {
        return this.h3Api.originToDirectedEdges(h3);
    }

    public List<LatLng> getH3UnidirectionalEdgeBoundary(long h3) {
        return this.h3Api.directedEdgeToBoundary(h3);
    }

    public List<LatLng> getH3UnidirectionalEdgeBoundary(String h3) {
        return this.h3Api.directedEdgeToBoundary(h3);
    }

    public Collection<Integer> h3GetFaces(String h3) {
        return this.h3Api.getIcosahedronFaces(h3);
    }

    public Collection<Integer> h3GetFaces(long h3) {
        return this.h3Api.getIcosahedronFaces(h3);
    }

    private static int longToIntDistance(long sz) {
        if (sz < 0L || sz > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Distance %d is out of range", sz));
        }
        return (int)sz;
    }
}

