/*
 * Decompiled with CFR 0.152.
 */
package com.uber.h3core;

import com.uber.h3core.NativeMethods;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Locale;
import java.util.Set;

public final class H3CoreLoader {
    static final Locale H3_CORE_LOCALE = Locale.ENGLISH;
    static final String ARCH_X64 = "x64";
    static final String ARCH_X86 = "x86";
    static final String ARCH_ARM64 = "arm64";
    private static volatile File libraryFile = null;

    private H3CoreLoader() {
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    static void copyResource(String resourcePath, File newH3LibFile) throws IOException {
        try (InputStream resource = H3CoreLoader.class.getResourceAsStream(resourcePath);){
            if (resource == null) {
                throw new UnsatisfiedLinkError(String.format("No native resource found at %s", resourcePath));
            }
            try (FileOutputStream outFile = new FileOutputStream(newH3LibFile);){
                H3CoreLoader.copyStream(resource, outFile);
            }
        }
    }

    public static NativeMethods loadNatives() throws IOException {
        OperatingSystem os = H3CoreLoader.detectOs(System.getProperty("java.vendor"), System.getProperty("os.name"));
        String arch = H3CoreLoader.detectArch(System.getProperty("os.arch"));
        return H3CoreLoader.loadNatives(os, arch);
    }

    private static File createTempLibraryFile(OperatingSystem os) throws IOException {
        if (os.isPosix()) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            return Files.createTempFile("libh3-java", os.getSuffix(), attr).toFile();
        }
        File f = Files.createTempFile("libh3-java", os.getSuffix(), new FileAttribute[0]).toFile();
        f.setReadable(true, true);
        f.setWritable(true, true);
        f.setExecutable(true, true);
        return f;
    }

    public static synchronized NativeMethods loadNatives(OperatingSystem os, String arch) throws IOException {
        if (libraryFile == null) {
            String dirName = String.format("%s-%s", os.getDirName(), arch);
            String libName = String.format("libh3-java%s", os.getSuffix());
            File newLibraryFile = H3CoreLoader.createTempLibraryFile(os);
            newLibraryFile.deleteOnExit();
            H3CoreLoader.copyResource(String.format("/%s/%s", dirName, libName), newLibraryFile);
            System.load(newLibraryFile.getCanonicalPath());
            libraryFile = newLibraryFile;
        }
        return new NativeMethods();
    }

    public static NativeMethods loadSystemNatives() {
        System.loadLibrary("h3-java");
        return new NativeMethods();
    }

    static final OperatingSystem detectOs(String javaVendor, String osName) {
        if (javaVendor.toLowerCase(H3_CORE_LOCALE).contains("android")) {
            return OperatingSystem.ANDROID;
        }
        String javaOs = osName.toLowerCase(H3_CORE_LOCALE);
        if (javaOs.contains("mac")) {
            return OperatingSystem.DARWIN;
        }
        if (javaOs.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (javaOs.contains("freebsd")) {
            return OperatingSystem.FREEBSD;
        }
        return OperatingSystem.LINUX;
    }

    static final String detectArch(String osArch) {
        if (osArch.equals("amd64") || osArch.equals("x86_64")) {
            return ARCH_X64;
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("i786") || osArch.equals("i886")) {
            return ARCH_X86;
        }
        if (osArch.equals("aarch64")) {
            return ARCH_ARM64;
        }
        return osArch;
    }

    public static enum OperatingSystem {
        ANDROID(".so"),
        DARWIN(".dylib"),
        FREEBSD(".so"),
        WINDOWS(".dll", false),
        LINUX(".so");

        private final String suffix;
        private final boolean posix;

        private OperatingSystem(String suffix) {
            this.suffix = suffix;
            this.posix = true;
        }

        private OperatingSystem(String suffix, boolean posix) {
            this.suffix = suffix;
            this.posix = posix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getDirName() {
            return this.name().toLowerCase(H3_CORE_LOCALE);
        }

        public boolean isPosix() {
            return this.posix;
        }
    }
}

