/*
 * Copyright 2018 Uber Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.uber.h3core.util;

import java.util.Objects;

/** Immutable two-dimensional IJ grid coordinates. */
public class CoordIJ {
  /** I coordinate */
  public final int i;

  /** J coordinate */
  public final int j;

  /**
   * Construct with I and J coordinates
   *
   * @param i I coordinate
   * @param j J coordinate
   */
  public CoordIJ(int i, int j) {
    this.i = i;
    this.j = j;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CoordIJ ij = (CoordIJ) o;
    return ij.i == i && ij.j == j;
  }

  @Override
  public int hashCode() {
    return Objects.hash(i, j);
  }

  @Override
  public String toString() {
    return String.format("CoordIJ{i=%d, j=%d}", i, j);
  }
}
