/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.context;

import com.uber.jaeger.context.TraceContext;
import io.opentracing.Span;
import java.util.EmptyStackException;
import java.util.Stack;

public class ThreadLocalTraceContext
implements TraceContext {
    private final ThreadLocal<Stack<Span>> threadLocal = new ThreadLocal<Stack<Span>>(){

        @Override
        public Stack<Span> initialValue() {
            return new Stack<Span>();
        }
    };

    @Override
    public void push(Span span) {
        if (span == null) {
            throw new NullPointerException();
        }
        Stack<Span> spanStack = this.threadLocal.get();
        spanStack.push(span);
    }

    @Override
    public boolean isEmpty() {
        return this.threadLocal.get().isEmpty();
    }

    @Override
    public Span pop() throws EmptyStackException {
        return this.threadLocal.get().pop();
    }

    @Override
    public Span getCurrentSpan() throws EmptyStackException {
        return this.threadLocal.get().peek();
    }
}

