/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.context;

import com.uber.jaeger.context.TraceContext;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;

public class ScopeManagerTraceContext
implements TraceContext {
    private final ScopeManager scopeManager;

    public ScopeManagerTraceContext(ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
    }

    @Override
    public void push(Span span) {
        this.scopeManager.activate(span, false);
    }

    @Override
    public Span pop() {
        Scope scope = this.scopeManager.active();
        if (scope == null) {
            return null;
        }
        Span span = scope.span();
        scope.close();
        return span;
    }

    @Override
    public Span getCurrentSpan() {
        Scope scope = this.scopeManager.active();
        if (scope == null) {
            return null;
        }
        return scope.span();
    }

    @Override
    public boolean isEmpty() {
        return this.scopeManager.active() == null;
    }
}

