/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.thrift.senders;

import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThriftSenderBase {
    private static final Logger log = LoggerFactory.getLogger(ThriftSenderBase.class);
    public static final int EMIT_BATCH_OVERHEAD = 33;
    private AutoExpandingBufferWriteTransport memoryTransport;
    protected final TProtocolFactory protocolFactory;
    private final TSerializer serializer;
    private final int maxSpanBytes;

    public ThriftSenderBase(ProtocolType protocolType, int maxPacketSize) {
        switch (protocolType) {
            case Binary: {
                this.protocolFactory = new TBinaryProtocol.Factory();
                break;
            }
            case Compact: {
                this.protocolFactory = new TCompactProtocol.Factory();
                break;
            }
            default: {
                this.protocolFactory = null;
                log.error("Unknown thrift protocol type specified: " + (Object)((Object)protocolType));
            }
        }
        if (maxPacketSize == 0) {
            maxPacketSize = 65000;
        }
        this.maxSpanBytes = maxPacketSize - 33;
        this.memoryTransport = new AutoExpandingBufferWriteTransport(maxPacketSize, 2.0);
        this.serializer = new TSerializer(this.protocolFactory);
    }

    protected int getMaxSpanBytes() {
        return this.maxSpanBytes;
    }

    protected byte[] serialize(TBase<?, ?> thriftBase) throws Exception {
        return this.serializer.serialize(thriftBase);
    }

    public int getSize(TBase<?, ?> thriftBase) throws Exception {
        this.memoryTransport.reset();
        thriftBase.write(this.protocolFactory.getProtocol((TTransport)this.memoryTransport));
        return this.memoryTransport.getPos();
    }

    public String toString() {
        return "ThriftSenderBase(protocolFactory=" + this.protocolFactory + ", serializer=" + this.serializer + ", maxSpanBytes=" + this.getMaxSpanBytes() + ")";
    }

    public static enum ProtocolType {
        Binary,
        Compact;

    }
}

