/*
 * Decompiled with CFR 0.152.
 */
package com.uber.m3.tally.m3.thrift;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.apache.http.annotation.GuardedBy;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TUdpTransport
extends TTransport
implements AutoCloseable {
    public static final int PACKET_DATA_PAYLOAD_MAX_SIZE = 65023;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Object sendLock = new Object();
    protected final SocketAddress socketAddress;
    protected final DatagramSocket socket;
    protected volatile boolean open;
    @GuardedBy(value="sendLock")
    protected ByteBuffer writeBuffer;
    private final Object receiveLock = new Object();
    @GuardedBy(value="receiveLock")
    private ByteBuffer receiveBuffer;

    TUdpTransport(SocketAddress socketAddress, DatagramSocket socket) {
        this.socketAddress = socketAddress;
        this.socket = socket;
        this.writeBuffer = ByteBuffer.allocate(65023);
        this.receiveBuffer = ByteBuffer.allocate(65023);
        this.receiveBuffer.limit(0);
        this.open = false;
    }

    protected TUdpTransport(SocketAddress socketAddress) throws SocketException {
        this(socketAddress, new DatagramSocket(null));
    }

    public boolean isOpen() {
        return this.open;
    }

    public abstract void open() throws TTransportException;

    @Override
    public void close() {
        this.socket.close();
        this.open = false;
        this.logger.info("UDP socket has been closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1);
        }
        Object object = this.receiveLock;
        synchronized (object) {
            if (!this.receiveBuffer.hasRemaining()) {
                DatagramPacket packet = new DatagramPacket(this.receiveBuffer.array(), 65023);
                try {
                    this.socket.receive(packet);
                }
                catch (IOException e) {
                    throw new TTransportException("Error from underlying socket", (Throwable)e);
                }
                this.receiveBuffer.position(0);
                this.receiveBuffer.limit(packet.getLength());
            }
            length = Math.min(length, this.receiveBuffer.remaining());
            this.receiveBuffer.get(bytes, offset, length);
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes, int offset, int length) throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1);
        }
        Object object = this.sendLock;
        synchronized (object) {
            if (this.writeBuffer.position() + length > 65023) {
                throw new TTransportException(String.format("Message size too large: %d is greater than available size %d", length, 65023 - this.writeBuffer.position()));
            }
            this.writeBuffer.put(bytes, offset, length);
        }
    }

    public abstract void flush() throws TTransportException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesRemainingInBuffer() {
        Object object = this.receiveLock;
        synchronized (object) {
            return this.receiveBuffer.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer() {
        Object object = this.receiveLock;
        synchronized (object) {
            return this.receiveBuffer.array();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferPosition() {
        Object object = this.receiveLock;
        synchronized (object) {
            return this.receiveBuffer.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeBuffer(int length) {
        Object object = this.receiveLock;
        synchronized (object) {
            this.receiveBuffer.position(this.receiveBuffer.position() + length);
        }
    }
}

