/*
 * Decompiled with CFR 0.152.
 */
package com.uber.m3.tally.prometheus;

import com.uber.m3.tally.Buckets;
import com.uber.m3.tally.Capabilities;
import com.uber.m3.tally.CapableOf;
import com.uber.m3.tally.StatsReporter;
import com.uber.m3.tally.prometheus.TimerType;
import com.uber.m3.util.Duration;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.Summary;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PrometheusReporter
implements StatsReporter {
    static final String METRIC_ID_KEY_VALUE = "1";
    private static final String PREFIX_SPLITTER = "+";
    private static final String KEY_PAIR_SPLITTER = ",";
    private static final String KEY_NAME_SPLITTER = "=";
    private static final String KEY_PAIR_TEMPLATE = "%s=%s";
    private static final TimerType DEFAULT_TIMER_TYPE = TimerType.SUMMARY;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final CollectorRegistry registry;
    private final TimerType timerType;
    private final Map<Double, Double> defaultQuantiles;
    private final double[] defaultBuckets;
    private final int ageBuckets;
    private final long maxAgeSeconds;
    private final ConcurrentMap<String, Counter> registeredCounters;
    private final ConcurrentMap<String, Gauge> registeredGauges;
    private final ConcurrentMap<String, Histogram> registeredHistograms;
    private final ConcurrentMap<String, Summary> registeredSummaries;

    private PrometheusReporter(Map<Double, Double> defaultQuantiles, double[] defaultBuckets, TimerType defaultTimerType, CollectorRegistry registry, int ageBuckets, long maxAgeSeconds) {
        this.registry = registry;
        this.timerType = defaultTimerType;
        this.defaultBuckets = defaultBuckets;
        this.defaultQuantiles = defaultQuantiles;
        this.ageBuckets = ageBuckets;
        this.maxAgeSeconds = maxAgeSeconds;
        this.registeredCounters = new ConcurrentHashMap<String, Counter>();
        this.registeredGauges = new ConcurrentHashMap<String, Gauge>();
        this.registeredSummaries = new ConcurrentHashMap<String, Summary>();
        this.registeredHistograms = new ConcurrentHashMap<String, Histogram>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void reportCounter(String name, Map<String, String> tags, long value) {
        Map<Object, Object> finalTags = tags == null ? Collections.emptyMap() : tags;
        String collectorName = PrometheusReporter.canonicalMetricId(name, finalTags.keySet());
        Counter counter = this.registeredCounters.computeIfAbsent(collectorName, key -> (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(name)).help(String.format("%s counter", name))).labelNames(PrometheusReporter.collectionToStringArray(finalTags.keySet()))).register(this.registry));
        ((Counter.Child)counter.labels(PrometheusReporter.collectionToStringArray(finalTags.values()))).inc((double)value);
    }

    public void reportGauge(String name, Map<String, String> tags, double value) {
        Map<Object, Object> finalTags = tags == null ? Collections.emptyMap() : tags;
        String collectorName = PrometheusReporter.canonicalMetricId(name, finalTags.keySet());
        Gauge gauge = this.registeredGauges.computeIfAbsent(collectorName, key -> (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(name)).help(String.format("%s gauge", name))).labelNames(PrometheusReporter.collectionToStringArray(finalTags.keySet()))).register(this.registry));
        ((Gauge.Child)gauge.labels(PrometheusReporter.collectionToStringArray(finalTags.values()))).set(value);
    }

    public void reportTimer(String name, Map<String, String> tags, Duration interval) {
        switch (this.timerType) {
            case HISTOGRAM: {
                this.reportTimerHistogram(name, tags, interval);
                break;
            }
            default: {
                this.reportTimerSummary(name, tags, interval);
            }
        }
    }

    public void reportHistogramValueSamples(String name, Map<String, String> tags, Buckets buckets, double bucketLowerBound, double bucketUpperBound, long samples) {
        Map<Object, Object> finalTags = tags == null ? Collections.emptyMap() : tags;
        String collectorName = PrometheusReporter.canonicalMetricId(name, finalTags.keySet());
        Histogram.Child histogram = (Histogram.Child)this.registeredHistograms.computeIfAbsent(collectorName, key -> {
            double[] b = buckets.getValueUpperBounds().stream().mapToDouble(a -> a).toArray();
            return (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).help(String.format("%s histogram", name))).buckets(b).labelNames(PrometheusReporter.collectionToStringArray(finalTags.keySet()))).register(this.registry);
        }).labels(PrometheusReporter.collectionToStringArray(finalTags.values()));
        int i = 0;
        while ((long)i < samples) {
            histogram.observe(bucketUpperBound);
            ++i;
        }
    }

    public void reportHistogramDurationSamples(String name, Map<String, String> tags, Buckets buckets, Duration bucketLowerBound, Duration bucketUpperBound, long samples) {
        Map<Object, Object> finalTags = tags == null ? Collections.emptyMap() : tags;
        String collectorName = PrometheusReporter.canonicalMetricId(name, finalTags.keySet());
        Histogram.Child histogram = (Histogram.Child)this.registeredHistograms.computeIfAbsent(collectorName, key -> {
            double[] b = buckets.getDurationUpperBounds().stream().mapToDouble(Duration::getSeconds).toArray();
            return (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).help(String.format("%s histogram", name))).buckets(b).labelNames(PrometheusReporter.collectionToStringArray(finalTags.keySet()))).register(this.registry);
        }).labels(PrometheusReporter.collectionToStringArray(finalTags.values()));
        double bucketUpperBoundValue = bucketUpperBound.getSeconds();
        int i = 0;
        while ((long)i < samples) {
            histogram.observe(bucketUpperBoundValue);
            ++i;
        }
    }

    public Capabilities capabilities() {
        return CapableOf.REPORTING_TAGGING;
    }

    public void flush() {
    }

    public void close() {
        this.registeredCounters.values().forEach(arg_0 -> ((CollectorRegistry)this.registry).unregister(arg_0));
        this.registeredGauges.values().forEach(arg_0 -> ((CollectorRegistry)this.registry).unregister(arg_0));
        this.registeredSummaries.values().forEach(arg_0 -> ((CollectorRegistry)this.registry).unregister(arg_0));
        this.registeredHistograms.values().forEach(arg_0 -> ((CollectorRegistry)this.registry).unregister(arg_0));
    }

    private void reportTimerSummary(String name, Map<String, String> tags, Duration interval) {
        Map<Object, Object> finalTags = tags == null ? Collections.emptyMap() : tags;
        String collectorName = PrometheusReporter.canonicalMetricId(name, finalTags.keySet());
        Summary summary = this.registeredSummaries.computeIfAbsent(collectorName, key -> {
            Summary.Builder builder = (Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(name)).help(String.format("%s summary", name))).ageBuckets(this.ageBuckets).maxAgeSeconds(this.maxAgeSeconds).labelNames(PrometheusReporter.collectionToStringArray(finalTags.keySet()));
            this.defaultQuantiles.forEach((arg_0, arg_1) -> ((Summary.Builder)builder).quantile(arg_0, arg_1));
            return (Summary)builder.register(this.registry);
        });
        ((Summary.Child)summary.labels(PrometheusReporter.collectionToStringArray(finalTags.values()))).observe(interval.getSeconds());
    }

    private void reportTimerHistogram(String name, Map<String, String> tags, Duration interval) {
        Map<Object, Object> finalTags = tags == null ? Collections.emptyMap() : tags;
        String collectorName = PrometheusReporter.canonicalMetricId(name, finalTags.keySet());
        Histogram histogram = this.registeredHistograms.computeIfAbsent(collectorName, key -> (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).help(String.format("%s histogram", name))).buckets(this.defaultBuckets).labelNames(PrometheusReporter.collectionToStringArray(finalTags.keySet()))).register(this.registry));
        ((Histogram.Child)histogram.labels(PrometheusReporter.collectionToStringArray(finalTags.values()))).observe(interval.getSeconds());
    }

    static String canonicalMetricId(String name, Set<String> tagKeys) {
        Map<String, String> tags;
        if (name == null) {
            throw new IllegalArgumentException("metric name cannot be null");
        }
        if (tagKeys == null) {
            tags = Collections.emptyMap();
        } else {
            tags = new HashMap<String, String>(tagKeys.size());
            for (String key : tagKeys) {
                tags.put(key, METRIC_ID_KEY_VALUE);
            }
        }
        return PrometheusReporter.keyForPrefixedStringMap(name, tags);
    }

    static String keyForPrefixedStringMap(String prefix, Map<String, String> tags) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(PREFIX_SPLITTER);
        if (tags == null) {
            return sb.toString();
        }
        String tagsString = tags.keySet().stream().sorted().map(key -> String.format(KEY_PAIR_TEMPLATE, key, tags.get(key))).collect(Collectors.joining(KEY_PAIR_SPLITTER));
        sb.append(tagsString);
        return sb.toString();
    }

    static String[] collectionToStringArray(Collection<String> values) {
        return values.toArray(EMPTY_STRING_ARRAY);
    }

    private static Map<Double, Double> defaultQuantiles() {
        HashMap<Double, Double> quantiles = new HashMap<Double, Double>(5);
        quantiles.put(0.5, 0.01);
        quantiles.put(0.75, 0.001);
        quantiles.put(0.95, 0.001);
        quantiles.put(0.99, 0.001);
        quantiles.put(0.999, 1.0E-4);
        return Collections.unmodifiableMap(quantiles);
    }

    private static double[] defaultBuckets() {
        return new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};
    }

    static /* synthetic */ TimerType access$000() {
        return DEFAULT_TIMER_TYPE;
    }

    static /* synthetic */ Map access$100() {
        return PrometheusReporter.defaultQuantiles();
    }

    static /* synthetic */ double[] access$200() {
        return PrometheusReporter.defaultBuckets();
    }

    public static final class Builder {
        private CollectorRegistry registry = CollectorRegistry.defaultRegistry;
        private TimerType timerType = PrometheusReporter.access$000();
        private Map<Double, Double> defaultQuantiles = PrometheusReporter.access$100();
        private double[] defaultBuckets = PrometheusReporter.access$200();
        private int ageBuckets = 5;
        private long maxAgeSeconds = TimeUnit.MINUTES.toSeconds(10L);

        public Builder registry(CollectorRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder defaultQuantiles(Map<Double, Double> defaultQuantiles) {
            this.defaultQuantiles = defaultQuantiles;
            return this;
        }

        public Builder defaultBuckets(double[] defaultBuckets) {
            this.defaultBuckets = defaultBuckets;
            return this;
        }

        public Builder timerType(TimerType timerType) {
            this.timerType = timerType;
            return this;
        }

        public Builder ageBuckets(int ageBuckets) {
            this.ageBuckets = ageBuckets;
            return this;
        }

        public Builder maxAgeSeconds(long maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public PrometheusReporter build() {
            return new PrometheusReporter(this.defaultQuantiles, this.defaultBuckets, this.timerType, this.registry, this.ageBuckets, this.maxAgeSeconds);
        }
    }
}

