package com.uber.okbuck.template.config;

import java.io.IOException;
import com.fizzed.rocker.ForIterator;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerContent;
import com.fizzed.rocker.RockerOutput;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;

/*
 * Auto generated code to render template com/uber/okbuck/template/config/BuckWrapper.rocker.raw
 * Do not edit this file. Changes will eventually be overwritten by Rocker parser!
 */
@SuppressWarnings("unused")
@javax.annotation.Generated("Rocker")
public class BuckWrapper extends com.uber.okbuck.template.core.Rule {

    static public com.fizzed.rocker.ContentType getContentType() { return com.fizzed.rocker.ContentType.RAW; }
    static public String getTemplateName() { return "BuckWrapper.rocker.raw"; }
    static public String getTemplatePackageName() { return "com.uber.okbuck.template.config"; }
    static public String getHeaderHash() { return "1081508504"; }
    static public String[] getArgumentNames() { return new String[] { "customBuckRepo", "watch", "sourceRoots", "ignoredDirs" }; }

    // argument @ [1:2]
    private String customBuckRepo;
    // argument @ [1:2]
    private String watch;
    // argument @ [1:2]
    private String sourceRoots;
    // argument @ [1:2]
    private String ignoredDirs;

    public BuckWrapper customBuckRepo(String customBuckRepo) {
        this.customBuckRepo = customBuckRepo;
        return this;
    }

    public String customBuckRepo() {
        return this.customBuckRepo;
    }

    public BuckWrapper watch(String watch) {
        this.watch = watch;
        return this;
    }

    public String watch() {
        return this.watch;
    }

    public BuckWrapper sourceRoots(String sourceRoots) {
        this.sourceRoots = sourceRoots;
        return this;
    }

    public String sourceRoots() {
        return this.sourceRoots;
    }

    public BuckWrapper ignoredDirs(String ignoredDirs) {
        this.ignoredDirs = ignoredDirs;
        return this;
    }

    public String ignoredDirs() {
        return this.ignoredDirs;
    }

    static public BuckWrapper template(String customBuckRepo, String watch, String sourceRoots, String ignoredDirs) {
        return new BuckWrapper()
            .customBuckRepo(customBuckRepo)
            .watch(watch)
            .sourceRoots(sourceRoots)
            .ignoredDirs(ignoredDirs);
    }

    @Override
    protected DefaultRockerTemplate buildTemplate() throws RenderingException {
        // optimized for performance (via rocker.optimize flag; no auto reloading)
        return new Template(this);
    }

    @javax.annotation.Generated("Rocker")
    static public class Template extends com.uber.okbuck.template.core.RuleTemplate {

        // #!/usr/bin/env bash\n\n#########################################################################\n##\n##  Buck wrapper script to invoke okbuck when needed, before running buck\n##\n#########################################################################\n\nPRG=\"$0\"\n# Need this for relative symlinks.\nwhile [ -h \"$PRG\" ] ; do\n    ls=`ls -ld \"$PRG\"`\n    link=`expr \"$ls\" : \".*-> \\(.*\\)$\"`\n    if expr \"$link\" : \"/.*\" > /dev/null; then\n        PRG=\"$link\"\n    else\n       ...
        static private final byte[] PLAIN_TEXT_0_0;
        // \n        ],\n
        static private final byte[] PLAIN_TEXT_1_0;
        // \n    ],\n    \"fields\": [\"name\"]\n}]\nEOT`\n    SOURCE_ROOTS=`watchman --output-encoding=json --no-pretty -j 2>&1 <<-EOT\n[\"query\", \"$SCRIPT_DIR\", {\n    \"since\": \"n:okbuck_source_roots\",\n    \"expression\": [\"anyof\",\n        [\"allof\",\n        [\"type\", \"d\"],\n        [\"anyof\",\n
        static private final byte[] PLAIN_TEXT_2_0;
        // \n    ],\n    [\"allof\",\n        [\"type\", \"f\"],\n        [\"anyof\", [\"name\", \"AndroidManifest.xml\"]],\n        [\"not\", [\"dirname\", \".okbuck\"]]\n    ]\n    ],\n    \"fields\": [\"new\", \"exists\", \"name\"]\n}]\nEOT`\n    fi\n}\n\nupdateOkBuckSuccess ( ) {\n    OKBUCK_SUCCESS_DIR=`dirname $OKBUCK_SUCCESS`\n    mkdir -p $OKBUCK_SUCCESS_DIR\n    touch \"$OKBUCK_SUCCESS\"\n}\n\nrunOkBuck ( ) {\n    info \"RUNNING OKBUCK...\"\n    echo\n\n    rm -f $OKBUCK_SUCCESS\n    ( \"$SCRIP...
        static private final byte[] PLAIN_TEXT_3_0;

        static {
            PlainTextUnloadedClassLoader loader = PlainTextUnloadedClassLoader.tryLoad(BuckWrapper.class.getClassLoader(), BuckWrapper.class.getName() + "$PlainText", "UTF-8");
            PLAIN_TEXT_0_0 = loader.tryGet("PLAIN_TEXT_0_0");
            PLAIN_TEXT_1_0 = loader.tryGet("PLAIN_TEXT_1_0");
            PLAIN_TEXT_2_0 = loader.tryGet("PLAIN_TEXT_2_0");
            PLAIN_TEXT_3_0 = loader.tryGet("PLAIN_TEXT_3_0");
        }

        // argument @ [1:2]
        protected final String customBuckRepo;
        // argument @ [1:2]
        protected final String watch;
        // argument @ [1:2]
        protected final String sourceRoots;
        // argument @ [1:2]
        protected final String ignoredDirs;

        public Template(BuckWrapper model) {
            super(model);
            __internal.setCharset("UTF-8");
            __internal.setContentType(getContentType());
            __internal.setTemplateName(getTemplateName());
            __internal.setTemplatePackageName(getTemplatePackageName());
            this.customBuckRepo = model.customBuckRepo();
            this.watch = model.watch();
            this.sourceRoots = model.sourceRoots();
            this.ignoredDirs = model.ignoredDirs();
        }

        @Override
        protected void __doRender() throws IOException, RenderingException {
            // PlainText @ [6:2]
            __internal.aboutToExecutePosInTemplate(6, 2);
            __internal.writeValue(PLAIN_TEXT_0_0);
            // ValueExpression @ [112:1]
            __internal.aboutToExecutePosInTemplate(112, 1);
            __internal.renderValue(watch, false);
            // PlainText @ [112:7]
            __internal.aboutToExecutePosInTemplate(112, 7);
            __internal.writeValue(PLAIN_TEXT_1_0);
            // ValueExpression @ [114:1]
            __internal.aboutToExecutePosInTemplate(114, 1);
            __internal.renderValue(ignoredDirs, false);
            // PlainText @ [114:13]
            __internal.aboutToExecutePosInTemplate(114, 13);
            __internal.writeValue(PLAIN_TEXT_2_0);
            // ValueExpression @ [126:1]
            __internal.aboutToExecutePosInTemplate(126, 1);
            __internal.renderValue(sourceRoots, false);
            // PlainText @ [126:13]
            __internal.aboutToExecutePosInTemplate(126, 13);
            __internal.writeValue(PLAIN_TEXT_1_0);
            // ValueExpression @ [128:1]
            __internal.aboutToExecutePosInTemplate(128, 1);
            __internal.renderValue(ignoredDirs, false);
            // PlainText @ [128:13]
            __internal.aboutToExecutePosInTemplate(128, 13);
            __internal.writeValue(PLAIN_TEXT_3_0);
        }
    }

    @javax.annotation.Generated("Rocker")
    private static class PlainText {

        static private final String PLAIN_TEXT_0_0 = "#!/usr/bin/env bash\n\n#########################################################################\n##\n##  Buck wrapper script to invoke okbuck when needed, before running buck\n##\n#########################################################################\n\nPRG=\"$0\"\n# Need this for relative symlinks.\nwhile [ -h \"$PRG\" ] ; do\n    ls=`ls -ld \"$PRG\"`\n    link=`expr \"$ls\" : \".*-> \\(.*\\)$\"`\n    if expr \"$link\" : \"/.*\" > /dev/null; then\n        PRG=\"$link\"\n    else\n        PRG=`dirname \"$PRG\"`\"/$link\"\n    fi\ndone\nSAVED=\"`pwd`\"\ncd \"`dirname \\\"$PRG\\\"`/\" >/dev/null\nSCRIPT_DIR=\"`pwd -P`\"\ncd \"$SAVED\" >/dev/null\n\nred=`tput setaf 1 2>/dev/null || true`\nyellow=`tput setaf 3 2>/dev/null || true`\ngreen=`tput setaf 2 2>/dev/null || true`\nblue=`tput setaf 4 2>/dev/null || true`\nreset=`tput sgr0 2>/dev/null || true`\nbold=`tput bold 2>/dev/null || true`\n\ndie ( ) {\n    echo\n    echo \"${bold}${red} $* ${reset}\"\n    echo\n    exit 1\n}\n\ninfo ( ) {\n    echo \"${bold}${blue}$*${reset}\"\n}\n\nwarn ( ) {\n    echo \"${bold}${yellow}$*${reset}\"\n}\n\nsuccess ( ) {\n    echo\n    echo \"${bold}${green}$*${reset}\"\n    echo\n}\n\nensure ( ) {\n    command -v $1 >/dev/null 2>&1 || die \"ERROR: \"$1\" could be found in your PATH. Please install $1. $2\"\n}\n\njsonq() {\n    python -c \"import sys,json; obj=json.load(sys.stdin); print($1)\"\n}\n\nensure python \"https://www.python.org\"\nINSTALLED_WATCHMAN=`command -v watchman`\n\nOKBUCK_SUCCESS=\"$SCRIPT_DIR/build/okbuck.success\"\nOKBUCK_DIR=\"$SCRIPT_DIR/.okbuck\"\nMAX_DISPLAY_CHANGES=10\nWATCHMAN_TIMEOUT=10\nWATCHMAN_FAILED=\"WATCHMAN FAILED\"\nBUCK_BINARY_DIR=\"$OKBUCK_DIR/workspace/buck_binary\"\n\nexport JAVA_OPTS=\"${JAVA_OPTS:-\\\"-Xmx1g\\\" \\\"-Xms1g\\\"}\"\n\n# Timeout a call and exit early. This can be called via timeout <time> <command>.\ntimeout( ) {\n    perl -e \"alarm shift; exec @ARGV\" \"$@\";\n}\n\nensureWatch ( ) {\n    timeout $WATCHMAN_TIMEOUT watchman watch-project \"$SCRIPT_DIR\" >/dev/null 2>&1\n}\n\nremoveWatch ( ) {\n    timeout $WATCHMAN_TIMEOUT watchman watch-del \"$SCRIPT_DIR\" >/dev/null 2>&1\n}\n\ngetChanges ( ) {\n    ensureWatch\n    WATCHMAN_ERROR_CODE=$?\n    if [[ $WATCHMAN_ERROR_CODE -ne 0 ]]; then\n        WATCHED_CHANGES=$WATCHMAN_FAILED\n        echo \"watch-project failed after $WATCHMAN_TIMEOUT seconds, error code: $WATCHMAN_ERROR_CODE\"\n        removeWatch\n        WATCHDEL_ERROR_CODE=$?\n        if [[ $WATCHDEL_ERROR_CODE -ne 0 ]]; then\n            echo \"watch-del failed after $WATCHMAN_TIMEOUT seconds, error code: $?\"\n            echo \"Killing all watchman processes\"\n            killall watchman || true\n        fi\n    else\n        WATCHED_CHANGES=`watchman --output-encoding=json --no-pretty -j 2>&1 <<-EOT\n[\"query\", \"$SCRIPT_DIR\", {\n    \"since\": \"n:okbuck_trig\",\n    \"expression\": [\"allof\",\n        [\"type\", \"f\"],\n        [\"anyof\",\n";
        static private final String PLAIN_TEXT_1_0 = "\n        ],\n";
        static private final String PLAIN_TEXT_2_0 = "\n    ],\n    \"fields\": [\"name\"]\n}]\nEOT`\n    SOURCE_ROOTS=`watchman --output-encoding=json --no-pretty -j 2>&1 <<-EOT\n[\"query\", \"$SCRIPT_DIR\", {\n    \"since\": \"n:okbuck_source_roots\",\n    \"expression\": [\"anyof\",\n        [\"allof\",\n        [\"type\", \"d\"],\n        [\"anyof\",\n";
        static private final String PLAIN_TEXT_3_0 = "\n    ],\n    [\"allof\",\n        [\"type\", \"f\"],\n        [\"anyof\", [\"name\", \"AndroidManifest.xml\"]],\n        [\"not\", [\"dirname\", \".okbuck\"]]\n    ]\n    ],\n    \"fields\": [\"new\", \"exists\", \"name\"]\n}]\nEOT`\n    fi\n}\n\nupdateOkBuckSuccess ( ) {\n    OKBUCK_SUCCESS_DIR=`dirname $OKBUCK_SUCCESS`\n    mkdir -p $OKBUCK_SUCCESS_DIR\n    touch \"$OKBUCK_SUCCESS\"\n}\n\nrunOkBuck ( ) {\n    info \"RUNNING OKBUCK...\"\n    echo\n\n    rm -f $OKBUCK_SUCCESS\n    ( \"$SCRIPT_DIR/gradlew\" -p \"$SCRIPT_DIR\" okbuck -Dokbuck.wrapper=true $EXTRA_OKBUCK_ARGS &&\n    updateOkBuckSuccess && success \"PROCEEDING WITH BUCK\" ) || die \"OKBUCK FAILED\"\n}\n\nwatchmanWorkflow ( ) {\n    # Get list of changed files since last time by querying watchman\n    getChanges\n    if [[ \"$WATCHED_CHANGES\" = \"$WATCHMAN_FAILED\" ]]; then\n        runOkBuck\n    else\n        # Format list for simpler output\n        CHANGES=$(echo $WATCHED_CHANGES | jsonq '\" \".join(obj[\"files\"])')\n        NEW_OR_DELETED_SOURCE_ROOTS=$(echo $SOURCE_ROOTS | jsonq '\" \".join([f[\"name\"] for f in obj[\"files\"] if (not f[\"exists\"] or f[\"new\"])])')\n        NUM_CHANGES=$(echo $CHANGES $NEW_OR_DELETED_SOURCE_ROOTS | wc -w)\n\n        if [[ $NUM_CHANGES -gt 0 ]]; then\n            info \"CHANGES DETECTED IN:\"\n            echo $CHANGES $NEW_OR_DELETED_SOURCE_ROOTS | tr \" \" \"\\n\" | head -n $MAX_DISPLAY_CHANGES\n            if [[ $NUM_CHANGES -gt $MAX_DISPLAY_CHANGES ]]; then\n                DIFF=`expr $NUM_CHANGES - $MAX_DISPLAY_CHANGES`\n                echo \"...and $DIFF more\"\n            fi\n            echo\n            runOkBuck\n        fi\n    fi\n}\n\nsetupBuckBinary ( ) {\n    BUCK_BINARY=$(find \"$BUCK_BINARY_DIR\" -name buck*.pex)\n\n    if [[ ! -x \"$BUCK_BINARY\" ]]; then\n        chmod +x \"$BUCK_BINARY\"\n    fi\n}\n\n# Run tasks before buck command\nsetupBuckRun ( ) {\n    if [[ ! -z \"$SKIP_OKBUCK\" ]]; then\n        :\n    elif [[ ! -z \"$FORCE_OKBUCK\" ]]; then\n        runOkBuck\n    elif [[ ! -f \"$OKBUCK_SUCCESS\" ]] || [[ ! -d \"$OKBUCK_DIR\" ]]; then\n        warn \"NO PREVIOUS SUCCESSFUL OKBUCK RUN\"\n        if [[ ! -z \"$INSTALLED_WATCHMAN\" ]]; then\n            getChanges # Prevent watchman from running after this run, since changes would already be accounted for\n        fi\n        runOkBuck\n    elif [[ ! -z \"$INSTALLED_WATCHMAN\" ]]; then\n        watchmanWorkflow\n    else\n        warn \"ALWAYS RUNNING OKBUCK SINCE WATCHMAN IS NOT INSTALLED\"\n        warn \"INSTALL WATCHMAN FOR FASTER BUILDS\"\n        warn \"https://facebook.github.io/watchman\"\n        echo\n        runOkBuck\n    fi\n\n    setupBuckBinary\n\n    # Replace kotlin_home config with full path instead of source path\n    local kotlin_home\n    kotlin_home=$(\"$BUCK_BINARY\" audit config kotlin.kotlin_home)\n\n    if [[ \"$kotlin_home\" == *\":kotlin_home\"* ]]; then\n        echo \"changing kotlin home\"\n        local resolved_kotlin_home\n        resolved_kotlin_home=$(\"$BUCK_BINARY\" build //.okbuck/workspace/kotlin_home:kotlin_home --show-output | awk '{print $2}')\n        sed -i.bak \"s://.okbuck/workspace/kotlin_home\\:kotlin_home:${resolved_kotlin_home}:g\" .okbuck/config/okbuck.buckconfig\n    fi\n}\n\n# Handle parameters and flags\nhandleParams ( ) {\n   SKIP_FLAGS=\"\"\n   for arg in \"$@\"\n   do\n       case \"$arg\" in\n       --help|-h|help|kill) export SKIP_OKBUCK=1 && SKIP_FLAGS=1 ;; # Go directly to the kill command, help command, or --help option. Do not run okbuck.\n       --version) export SKIP_FLAGS=1;;\n       esac;\n   done\n}\n\nhandleParams \"$@\"\nsetupBuckRun\n\n# Invoke buck binary with arguments\nexec \"$BUCK_BINARY\" \"$@\" $EXTRA_BUCK_CONFIG\n";

    }

}
