/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck;

import com.facebook.infer.annotation.Initializer;
import com.google.common.collect.Sets;
import com.uber.okbuck.core.annotation.AnnotationProcessorCache;
import com.uber.okbuck.core.dependency.DependencyCache;
import com.uber.okbuck.core.dependency.DependencyFactory;
import com.uber.okbuck.core.dependency.exporter.DependencyExporter;
import com.uber.okbuck.core.dependency.exporter.JsonDependencyExporter;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.manager.BuckManager;
import com.uber.okbuck.core.manager.D8Manager;
import com.uber.okbuck.core.manager.DependencyManager;
import com.uber.okbuck.core.manager.GroovyManager;
import com.uber.okbuck.core.manager.JetifierManager;
import com.uber.okbuck.core.manager.KotlinManager;
import com.uber.okbuck.core.manager.LintManager;
import com.uber.okbuck.core.manager.ManifestMergerManager;
import com.uber.okbuck.core.manager.RobolectricManager;
import com.uber.okbuck.core.manager.ScalaManager;
import com.uber.okbuck.core.manager.TransformManager;
import com.uber.okbuck.core.model.base.ProjectType;
import com.uber.okbuck.core.task.OkBuckCleanTask;
import com.uber.okbuck.core.task.OkBuckTask;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.MoreCollectors;
import com.uber.okbuck.core.util.ProjectCache;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.KotlinExtension;
import com.uber.okbuck.extension.OkBuckExtension;
import com.uber.okbuck.extension.ScalaExtension;
import com.uber.okbuck.extension.WrapperExtension;
import com.uber.okbuck.generator.BuckFileGenerator;
import com.uber.okbuck.template.common.ExportFile;
import com.uber.okbuck.wrapper.BuckWrapperTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;

public class OkBuckGradlePlugin
implements Plugin<Project> {
    public static final String OKBUCK = "okbuck";
    private static final String DOT_OKBUCK = ".okbuck";
    public static final String WORKSPACE_PATH = ".okbuck/workspace";
    public static final String GROUP = "okbuck";
    public static final String BUCK_LINT = "buckLint";
    private static final String OKBUCK_TARGETS_BZL = "okbuck_targets.bzl";
    public static final String OKBUCK_TARGETS_FILE = ".okbuck/defs/okbuck_targets.bzl";
    public static final String OKBUCK_TARGETS_TARGET = "//.okbuck/defs:okbuck_targets.bzl";
    private static final String OKBUCK_PREBUILT_BZL = "okbuck_prebuilt.bzl";
    public static final String OKBUCK_PREBUILT_FOLDER = ".okbuck/defs";
    public static final String OKBUCK_PREBUILT_FILE = ".okbuck/defs/okbuck_prebuilt.bzl";
    public static final String OKBUCK_PREBUILT_TARGET = "//.okbuck/defs:okbuck_prebuilt.bzl";
    private static final String OKBUCK_ANDROID_MODULES_BZL = "okbuck_android_modules.bzl";
    public static final String OKBUCK_ANDROID_MODULES_FILE = ".okbuck/defs/okbuck_android_modules.bzl";
    public static final String OKBUCK_ANDROID_MODULES_TARGET = "//.okbuck/defs:okbuck_android_modules.bzl";
    public static final String OKBUCK_CONFIG = ".okbuck/config";
    private static final String OKBUCK_STATE_DIR = ".okbuck/state";
    private static final String OKBUCK_CLEAN = "okbuckClean";
    private static final String BUCK_WRAPPER = "buckWrapper";
    private static final String FORCED_OKBUCK = "forcedOkbuck";
    private static final String PROCESSOR_BUILD_FOLDER = ".okbuck/workspace/processor";
    private static final String LINT_BUILD_FOLDER = ".okbuck/workspace/lint";
    public static final String OKBUCK_STATE = ".okbuck/state/STATE";
    public static final String DEFAULT_OKBUCK_SHA256 = ".okbuck/state/SHA256";
    public final Set<String> exportedPaths = Sets.newConcurrentHashSet();
    public DependencyCache depCache;
    public DependencyFactory dependencyFactory;
    public DependencyManager dependencyManager;
    public AnnotationProcessorCache annotationProcessorCache;
    public LintManager lintManager;
    public KotlinManager kotlinManager;
    public ScalaManager scalaManager;
    public GroovyManager groovyManager;
    public JetifierManager jetifierManager;
    public TransformManager transformManager;
    public D8Manager d8Manager;
    ManifestMergerManager manifestMergerManager;
    RobolectricManager robolectricManager;
    BuckManager buckManager;

    @Initializer
    public void apply(Project rootProject) {
        OkBuckExtension okbuckExt = (OkBuckExtension)rootProject.getExtensions().create("okbuck", OkBuckExtension.class, new Object[]{rootProject});
        rootProject.getConfigurations().maybeCreate("transform");
        rootProject.getConfigurations().maybeCreate(FORCED_OKBUCK);
        rootProject.afterEvaluate(rootBuckProject -> {
            Set<String> configs = okbuckExt.getExternalDependenciesExtension().getAutoValueConfigurations();
            for (String config : configs) {
                rootBuckProject.getConfigurations().maybeCreate(config);
            }
            Task setupOkbuck = rootBuckProject.getTasks().create("setupOkbuck");
            setupOkbuck.setGroup("okbuck");
            setupOkbuck.setDescription("Setup okbuck cache and dependencies");
            BuckFileManager buckFileManager = new BuckFileManager(okbuckExt.getRuleOverridesExtension());
            this.dependencyFactory = new DependencyFactory();
            String processorBuildFile = ".okbuck/workspace/processor/" + okbuckExt.buildFileName;
            this.annotationProcessorCache = new AnnotationProcessorCache((Project)rootBuckProject, buckFileManager, processorBuildFile);
            this.dependencyManager = new DependencyManager((Project)rootBuckProject, okbuckExt, buckFileManager, OkBuckGradlePlugin.createDependencyExporter(okbuckExt));
            String lintBuildFile = ".okbuck/workspace/lint/" + okbuckExt.buildFileName;
            this.lintManager = new LintManager((Project)rootBuckProject, lintBuildFile, buckFileManager);
            this.kotlinManager = new KotlinManager((Project)rootBuckProject, buckFileManager);
            this.scalaManager = new ScalaManager((Project)rootBuckProject, buckFileManager);
            this.groovyManager = new GroovyManager((Project)rootBuckProject, buckFileManager);
            this.jetifierManager = new JetifierManager((Project)rootBuckProject, buckFileManager);
            this.robolectricManager = new RobolectricManager((Project)rootBuckProject, buckFileManager);
            this.transformManager = new TransformManager((Project)rootBuckProject, buckFileManager);
            this.d8Manager = new D8Manager((Project)rootBuckProject);
            this.buckManager = new BuckManager((Project)rootBuckProject);
            this.manifestMergerManager = new ManifestMergerManager((Project)rootBuckProject, buckFileManager);
            KotlinExtension kotlin = okbuckExt.getKotlinExtension();
            ScalaExtension scala = okbuckExt.getScalaExtension();
            Task rootOkBuckTask = rootBuckProject.getTasks().create("okbuck", OkBuckTask.class, new Object[]{okbuckExt, kotlin, scala, buckFileManager});
            rootOkBuckTask.dependsOn(new Object[]{setupOkbuck});
            rootOkBuckTask.doLast(task -> {
                this.annotationProcessorCache.finalizeProcessors();
                this.dependencyManager.resolveCurrentRawDeps();
                this.dependencyManager.finalizeDependencies(okbuckExt);
                this.jetifierManager.finalizeDependencies(okbuckExt);
                this.lintManager.finalizeDependencies();
                this.kotlinManager.finalizeDependencies(okbuckExt);
                this.scalaManager.finalizeDependencies(okbuckExt);
                this.groovyManager.finalizeDependencies(okbuckExt);
                this.robolectricManager.finalizeDependencies(okbuckExt);
                this.transformManager.finalizeDependencies(okbuckExt);
                this.buckManager.finalizeDependencies();
                this.manifestMergerManager.finalizeDependencies(okbuckExt);
                this.dependencyFactory.finalizeDependencies();
                this.writeExportedFileRules((Project)rootBuckProject, okbuckExt);
                ProjectCache.resetScopeCache(rootProject);
                ProjectCache.resetTargetCacheForAll(rootProject);
            });
            WrapperExtension wrapper = okbuckExt.getWrapperExtension();
            rootBuckProject.getTasks().create(BUCK_WRAPPER, BuckWrapperTask.class, new Object[]{wrapper.repo, wrapper.watch, wrapper.sourceRoots, wrapper.ignoredDirs});
            Map extraConfigurations = okbuckExt.extraDepCachesMap.keySet().stream().collect(Collectors.toMap(Function.identity(), cacheName -> (Configuration)rootBuckProject.getConfigurations().maybeCreate(cacheName + "ExtraDepCache")));
            setupOkbuck.doFirst(task -> {
                if (System.getProperty("okbuck.wrapper", "false").equals("false")) {
                    throw new IllegalArgumentException("Okbuck cannot be invoked without 'okbuck.wrapper' set to true. Use buckw instead");
                }
            });
            setupOkbuck.doLast(task -> {
                ProjectCache.initTargetCacheForAll(rootProject);
                ProjectCache.initScopeCache(rootProject);
                this.depCache = new DependencyCache((Project)rootBuckProject, this.dependencyManager, FORCED_OKBUCK);
                if (!okbuckExt.getLintExtension().disabled && okbuckExt.getLintExtension().version != null) {
                    this.lintManager.fetchLintDeps(okbuckExt.getLintExtension().version);
                }
                if (!okbuckExt.getTransformExtension().transforms.isEmpty()) {
                    this.transformManager.fetchTransformDeps();
                }
                this.d8Manager.copyDeps(buckFileManager, okbuckExt);
                if (okbuckExt.getTestExtension().robolectric) {
                    this.robolectricManager.download();
                }
                if (JetifierManager.isJetifierEnabled(rootProject)) {
                    this.jetifierManager.setupJetifier(okbuckExt.getJetifierExtension().version);
                }
                extraConfigurations.forEach((cacheName, extraConfiguration) -> new DependencyCache((Project)rootBuckProject, this.dependencyManager, okbuckExt.extraDepCachesMap.getOrDefault(cacheName, false)).build((Configuration)extraConfiguration));
                this.buckManager.setupBuckBinary();
                this.manifestMergerManager.fetchManifestMergerDeps();
            });
            Task okBuckClean = rootBuckProject.getTasks().create(OKBUCK_CLEAN, OkBuckCleanTask.class, new Object[]{okbuckExt.buckProjects});
            rootOkBuckTask.dependsOn(new Object[]{okBuckClean});
            okbuckExt.buckProjects.stream().filter(p -> p.getBuildFile().exists()).forEach(bp -> {
                bp.getConfigurations().maybeCreate(BUCK_LINT);
                Task okbuckProjectTask = (Task)bp.getTasks().maybeCreate("okbuck");
                okbuckProjectTask.doLast(task -> {
                    ProjectCache.initScopeCache(bp);
                    BuckFileGenerator.generate(bp, buckFileManager, okbuckExt);
                    ProjectCache.resetScopeCache(bp);
                });
                okbuckProjectTask.dependsOn(new Object[]{setupOkbuck});
                okBuckClean.dependsOn(new Object[]{okbuckProjectTask});
            });
        });
    }

    private void writeExportedFileRules(Project rootBuckProject, OkBuckExtension okBuckExtension) {
        Set currentProjectPaths = (Set)okBuckExtension.buckProjects.stream().filter(project -> ProjectUtil.getType(project) != ProjectType.UNKNOWN).map(project -> rootBuckProject.getProjectDir().toPath().relativize(project.getProjectDir().toPath()).toString()).collect(MoreCollectors.toImmutableSet());
        HashMap<String, Set> pathToRules = new HashMap<String, Set>();
        for (String string : this.exportedPaths) {
            File exportedFile = rootBuckProject.file((Object)string);
            String containingPath = FileUtil.getRelativePath(rootBuckProject.getProjectDir(), exportedFile.getParentFile());
            Set rules = pathToRules.getOrDefault(containingPath, new HashSet());
            rules.add(new ExportFile().name(exportedFile.getName()));
            pathToRules.put(containingPath, rules);
        }
        for (Map.Entry entry : pathToRules.entrySet()) {
            File buckFile = rootBuckProject.getRootDir().toPath().resolve((String)entry.getKey()).resolve(okBuckExtension.buildFileName).toFile();
            try (FileOutputStream os = new FileOutputStream(buckFile, currentProjectPaths.contains(entry.getKey()));){
                ((Set)entry.getValue()).stream().sorted((rule1, rule2) -> rule1.name().compareToIgnoreCase(rule2.name())).forEach(rule -> rule.render(os));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static DependencyExporter createDependencyExporter(OkBuckExtension okbuckExt) {
        return new JsonDependencyExporter(okbuckExt.getExportDependenciesExtension());
    }
}

