/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.composer.android;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.uber.okbuck.composer.android.AndroidBuckRuleComposer;
import com.uber.okbuck.core.manager.TransformManager;
import com.uber.okbuck.core.model.android.AndroidAppTarget;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.template.android.AndroidBinaryRule;
import com.uber.okbuck.template.core.Rule;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.Project;

public final class AndroidBinaryRuleComposer
extends AndroidBuckRuleComposer {
    private static final ImmutableMap<String, String> CPU_FILTER_MAP = new ImmutableMap.Builder().put((Object)"armeabi", (Object)"ARM").put((Object)"armeabi-v7a", (Object)"ARMV7").put((Object)"arm64-v8a", (Object)"ARM64").put((Object)"x86", (Object)"X86").put((Object)"x86_64", (Object)"X86_64").put((Object)"mips", (Object)"MIPS").build();

    private AndroidBinaryRuleComposer() {
    }

    public static Rule compose(AndroidAppTarget target, String manifestRule, List<String> deps, String keystoreRuleName) {
        Set mappedCpuFilters = target.getCpuFilters().stream().map(arg_0 -> CPU_FILTER_MAP.get(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        TransformManager transformManager = ProjectUtil.getTransformManager(target.getProject());
        Pair<String, List<String>> results = transformManager.getBashCommandAndTransformDeps(target);
        String bashCommand = (String)results.getLeft();
        List transformDeps = (List)results.getRight();
        transformDeps.add("//.okbuck/workspace/transform:okbuck_transform");
        ImmutableList testTargets = target.getAppInstrumentationTarget() != null ? ImmutableList.of((Object)(":" + AndroidBinaryRuleComposer.instrumentationTest(target))) : ImmutableList.of();
        String proguardConfig = target.getProguardConfig();
        if (proguardConfig != null) {
            ProjectUtil.getPlugin((Project)target.getRootProject()).exportedPaths.add(proguardConfig);
            String proguardMapping = target.getProguardMapping();
            if (proguardMapping != null) {
                ProjectUtil.getPlugin((Project)target.getRootProject()).exportedPaths.add(proguardMapping);
                deps.add(AndroidBinaryRuleComposer.fileRule(proguardMapping));
            }
        }
        if (proguardConfig != null && target.getProguardMapping() != null) {
            deps.add(AndroidBinaryRuleComposer.fileRule(target.getProguardMapping()));
        }
        return ((Rule)((Object)((Rule)((Object)((Rule)((Object)((Rule)((Object)new AndroidBinaryRule().manifestSkeleton(manifestRule).keystore(keystoreRuleName).multidexEnabled(target.getMultidexEnabled()).linearAllocHardLimit(target.getLinearAllocHardLimit()).primaryDexPatterns(target.getPrimaryDexPatterns()).exopackage(target.getExopackage() != null).cpuFilters(mappedCpuFilters).minifyEnabled(target.getMinifyEnabled()).proguardConfig(AndroidBinaryRuleComposer.fileRule(proguardConfig)).debuggable(target.getDebuggable()).placeholders(target.getPlaceholders()).includesVectorDrawables(target.getIncludesVectorDrawables()).preprocessJavaClassesDeps(transformDeps).preprocessJavaClassesBash(bashCommand).testTargets((Collection)testTargets).ruleType(RuleType.ANDROID_BINARY.getBuckName()))).defaultVisibility())).deps(deps))).name(AndroidBinaryRuleComposer.bin(target)))).extraBuckOpts(target.getExtraOpts(RuleType.ANDROID_BINARY));
    }
}

