/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.composer.android;

import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.composer.android.AndroidBuckRuleComposer;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.model.android.AndroidLibTarget;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.model.base.SourceSetType;
import com.uber.okbuck.core.model.jvm.JvmTarget;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.template.android.AndroidRule;
import com.uber.okbuck.template.core.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public final class AndroidLibraryRuleComposer
extends AndroidBuckRuleComposer {
    private AndroidLibraryRuleComposer() {
    }

    public static Rule compose(AndroidLibTarget target, String manifestRule, List<String> deps, List<String> aidlRuleNames, @Nullable String appClass) {
        HashSet<String> libraryDeps = new HashSet<String>(deps);
        libraryDeps.addAll(AndroidLibraryRuleComposer.external(target.getExternalDeps(SourceSetType.MAIN)));
        libraryDeps.addAll(AndroidLibraryRuleComposer.targets(target.getTargetDeps(SourceSetType.MAIN)));
        libraryDeps.addAll(AndroidLibraryRuleComposer.resources(target.getTargetDeps(SourceSetType.MAIN)));
        libraryDeps.addAll(AndroidLibraryRuleComposer.resources(target.getTargetExportedDeps(SourceSetType.MAIN)));
        ArrayList<String> libraryAptDeps = new ArrayList<String>();
        libraryAptDeps.addAll(AndroidLibraryRuleComposer.externalApt(target.getExternalAptDeps(SourceSetType.MAIN)));
        libraryAptDeps.addAll(AndroidLibraryRuleComposer.targetsApt(target.getTargetAptDeps(SourceSetType.MAIN)));
        HashSet<String> providedDeps = new HashSet<String>();
        providedDeps.addAll(AndroidLibraryRuleComposer.external(target.getExternalProvidedDeps(SourceSetType.MAIN)));
        providedDeps.addAll(AndroidLibraryRuleComposer.targets(target.getTargetProvidedDeps(SourceSetType.MAIN)));
        providedDeps.add("//.okbuck/workspace/d8:rt-stub.jar");
        HashSet<String> libraryExportedDeps = new HashSet<String>();
        libraryExportedDeps.addAll(AndroidLibraryRuleComposer.external(target.getExternalExportedDeps(SourceSetType.MAIN)));
        libraryExportedDeps.addAll(AndroidLibraryRuleComposer.targets(target.getTargetExportedDeps(SourceSetType.MAIN)));
        libraryExportedDeps.addAll(aidlRuleNames);
        ArrayList<String> testTargets = new ArrayList<String>();
        if (target.getRobolectricEnabled() && !target.getTest().getSources().isEmpty()) {
            testTargets.add(":" + AndroidLibraryRuleComposer.test(target));
        }
        if (target.getLibInstrumentationTarget() != null && !target.getLibInstrumentationTarget().getMain().getSources().isEmpty()) {
            testTargets.add(":" + AndroidBuckRuleComposer.bin(target.getLibInstrumentationTarget()));
        }
        AndroidRule androidRule = new AndroidRule().srcs(target.getMain().getSources()).exts((Collection)target.getRuleType().getProperties()).manifest(manifestRule).proguardConfig(target.getConsumerProguardConfig()).apPlugins(AndroidLibraryRuleComposer.getApPlugins(target.getApPlugins())).aptDeps(libraryAptDeps).providedDeps(providedDeps).exportedDeps(libraryExportedDeps).resources(target.getMain().getJavaResources()).resDirs(target.getResDirs()).sourceCompatibility(target.getSourceCompatibility()).targetCompatibility(target.getTargetCompatibility()).testTargets(testTargets).excludes((Collection)(appClass != null ? ImmutableSet.of((Object)appClass) : ImmutableSet.of())).generateR2(target.getGenerateR2()).options(target.getMain().getCustomOptions());
        if (target.getRuleType().equals((Object)RuleType.KOTLIN_ANDROID_LIBRARY)) {
            androidRule.language("kotlin");
        }
        if (target.getLintEnabled()) {
            String lintConfigPath;
            if (target.getLintOptions() != null && target.getLintOptions().getLintConfig() != null && target.getLintOptions().getLintConfig().exists()) {
                lintConfigPath = FileUtil.getRelativePath(target.getRootProject().getProjectDir(), target.getLintOptions().getLintConfig());
                ProjectUtil.getPlugin((Project)target.getRootProject()).exportedPaths.add(lintConfigPath);
            } else {
                lintConfigPath = null;
            }
            Set customLintTargets = target.getLint().getTargetDeps().stream().filter(t -> t instanceof JvmTarget).map(BuckRuleComposer::binTargets).collect(Collectors.toSet());
            if (lintConfigPath != null) {
                androidRule.lintConfigXml(AndroidLibraryRuleComposer.fileRule(lintConfigPath));
            }
            androidRule.customLints(customLintTargets).lintOptions(target.getLintOptions());
        } else {
            androidRule.disableLint(true);
        }
        return ((Rule)((Object)((Rule)((Object)((Rule)((Object)((Rule)((Object)androidRule.ruleType(target.getRuleType().getBuckName()))).defaultVisibility())).deps(libraryDeps))).name(AndroidLibraryRuleComposer.src(target)))).extraBuckOpts(target.getExtraOpts(RuleType.ANDROID_LIBRARY));
    }
}

