/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.composer.android;

import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.composer.android.AndroidBuckRuleComposer;
import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.model.android.AndroidLibTarget;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.core.model.base.SourceSetType;
import com.uber.okbuck.core.model.jvm.JvmTarget;
import com.uber.okbuck.core.util.FileUtil;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.template.android.AndroidModuleRule;
import com.uber.okbuck.template.core.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public final class AndroidModuleRuleComposer
extends AndroidBuckRuleComposer {
    private AndroidModuleRuleComposer() {
    }

    public static Rule compose(AndroidLibTarget target, List<String> deps, List<String> aidlRuleNames, @Nullable String appClass, List<String> extraResDeps) {
        HashSet<String> libraryDeps = new HashSet<String>(deps);
        libraryDeps.addAll(AndroidModuleRuleComposer.external(target.getExternalDeps(SourceSetType.MAIN)));
        libraryDeps.addAll(AndroidModuleRuleComposer.targets(target.getTargetDeps(SourceSetType.MAIN)));
        ArrayList<String> libraryAptDeps = new ArrayList<String>();
        libraryAptDeps.addAll(AndroidModuleRuleComposer.externalApt(target.getExternalAptDeps(SourceSetType.MAIN)));
        libraryAptDeps.addAll(AndroidModuleRuleComposer.targetsApt(target.getTargetAptDeps(SourceSetType.MAIN)));
        HashSet<String> providedDeps = new HashSet<String>();
        providedDeps.addAll(AndroidModuleRuleComposer.external(target.getExternalProvidedDeps(SourceSetType.MAIN)));
        providedDeps.addAll(AndroidModuleRuleComposer.targets(target.getTargetProvidedDeps(SourceSetType.MAIN)));
        providedDeps.add("//.okbuck/workspace/d8:rt-stub.jar");
        HashSet<String> libraryExportedDeps = new HashSet<String>();
        libraryExportedDeps.addAll(AndroidModuleRuleComposer.external(target.getExternalExportedDeps(SourceSetType.MAIN)));
        libraryExportedDeps.addAll(AndroidModuleRuleComposer.targets(target.getTargetExportedDeps(SourceSetType.MAIN)));
        libraryExportedDeps.addAll(aidlRuleNames);
        ArrayList<String> testTargets = new ArrayList<String>();
        if (target.getRobolectricEnabled() && !target.getTest().getSources().isEmpty()) {
            testTargets.add(":" + AndroidModuleRuleComposer.test(target));
        }
        if (target.getLibInstrumentationTarget() != null && !target.getLibInstrumentationTarget().getMain().getSources().isEmpty()) {
            testTargets.add(":" + AndroidBuckRuleComposer.bin(target.getLibInstrumentationTarget()));
        }
        AndroidModuleRule unifiedAndroid = new AndroidModuleRule().srcs(target.getMain().getSources()).exts((Collection)target.getRuleType().getProperties()).proguardConfig(target.getConsumerProguardConfig()).apPlugins(AndroidModuleRuleComposer.getApPlugins(target.getApPlugins())).aptDeps(libraryAptDeps).providedDeps(providedDeps).exportedDeps(libraryExportedDeps).resources(target.getMain().getJavaResources()).resDirs(target.getResDirs()).sourceCompatibility(target.getSourceCompatibility()).targetCompatibility(target.getTargetCompatibility()).testTargets(testTargets).excludes((Collection)(appClass != null ? ImmutableSet.of((Object)appClass) : ImmutableSet.of())).generateR2(target.getGenerateR2()).options(target.getMain().getCustomOptions());
        if (target.getLintEnabled()) {
            String lintConfigPath;
            if (target.getLintOptions() != null && target.getLintOptions().getLintConfig() != null && target.getLintOptions().getLintConfig().exists()) {
                lintConfigPath = FileUtil.getRelativePath(target.getRootProject().getProjectDir(), target.getLintOptions().getLintConfig());
                ProjectUtil.getPlugin((Project)target.getRootProject()).exportedPaths.add(lintConfigPath);
            } else {
                lintConfigPath = null;
            }
            Set customLintTargets = target.getLint().getTargetDeps().stream().filter(t -> t instanceof JvmTarget).map(BuckRuleComposer::binTargets).collect(Collectors.toSet());
            if (lintConfigPath != null) {
                unifiedAndroid.lintConfigXml(AndroidModuleRuleComposer.fileRule(lintConfigPath));
            }
            unifiedAndroid.customLints(customLintTargets).lintOptions(target.getLintOptions());
        } else {
            unifiedAndroid.disableLint(true);
        }
        ((Rule)((Object)((Rule)((Object)((Rule)((Object)((Rule)((Object)unifiedAndroid.ruleType(target.getRuleType().getBuckName()))).defaultVisibility())).deps(libraryDeps))).name(AndroidModuleRuleComposer.src(target)))).extraBuckOpts(target.getExtraOpts(RuleType.ANDROID_LIBRARY));
        unifiedAndroid.manifestDebuggable(target.getDebuggable()).manifestMinSdk(target.getMinSdk()).manifestTargetSdk(target.getTargetSdk()).manifestVersionCode(target.getVersionCode()).manifestVersionName(target.getVersionName()).manifestMainManifest(target.getMainManifest()).manifestSecondaryManifests(target.getSecondaryManifests());
        return unifiedAndroid.pkg(target.getResPackage()).resRes(target.getResDirs()).resProjectRes(target.getProjectResDir()).resAssets(target.getAssetDirs()).resResourceUnion(target.getOkbuck().useResourceUnion()).resExtraDeps(extraResDeps);
    }
}

