/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.composer.common;

import com.google.common.base.Preconditions;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.template.common.HttpFile;
import com.uber.okbuck.template.core.Rule;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class HttpFileRuleComposer {
    private HttpFileRuleComposer() {
    }

    public static List<Rule> compose(Collection<OExternalDependency> dependencies, HashMap<String, String> shaSum256) {
        return dependencies.stream().sorted(OExternalDependency.compareByName).map(dependency -> {
            String sha256Key = OExternalDependency.getGradleSha(dependency.getRealDependencyFile());
            String sha256 = (String)Preconditions.checkNotNull((Object)((String)shaSum256.get(sha256Key)));
            Object rule = new HttpFile().mavenCoords(dependency.getMavenCoords()).sha256(sha256).name(dependency.getTargetName());
            ((Rule)((Object)((Object)rule))).name(dependency.getTargetName());
            return rule;
        }).collect(Collectors.toList());
    }
}

