/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.composer.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.composer.jvm.JvmBuckRuleComposer;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.model.base.RuleType;
import com.uber.okbuck.template.core.Rule;
import com.uber.okbuck.template.java.Prebuilt;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class PrebuiltRuleComposer
extends JvmBuckRuleComposer {
    private PrebuiltRuleComposer() {
    }

    public static List<Rule> compose(Collection<OExternalDependency> dependencies, HashMap<String, String> shaSum256) {
        return dependencies.stream().peek(dependency -> {
            if (!ImmutableSet.of((Object)"jar", (Object)"aar").contains((Object)dependency.getPackaging())) {
                throw new IllegalStateException("Dependency not a valid prebuilt: " + dependency);
            }
        }).sorted(OExternalDependency.compareByName).map(dependency -> {
            String sha256Key = OExternalDependency.getGradleSha(dependency.getRealDependencyFile());
            String sha256 = (String)Preconditions.checkNotNull((Object)((String)shaSum256.get(sha256Key)));
            Prebuilt rule = new Prebuilt().mavenCoords(dependency.getMavenCoords()).enableJetifier(dependency.enableJetifier()).firstLevel(dependency.isFirstLevel()).sha256(sha256);
            dependency.getRealSourceFile().ifPresent(file -> {
                String sourcesSha256Key = OExternalDependency.getGradleSha(file);
                String sourcesSha256 = (String)Preconditions.checkNotNull((Object)((String)shaSum256.get(sourcesSha256Key)));
                rule.sourcesSha256(sourcesSha256);
            });
            ((Rule)((Object)((Object)rule.ruleType(RuleType.PREBUILT.getBuckName()).deps(PrebuiltRuleComposer.external(dependency.getDeps()))))).name(dependency.getTargetName());
            return rule;
        }).collect(Collectors.toList());
    }
}

