/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.composer.jvm;

import com.uber.okbuck.composer.base.BuckRuleComposer;
import com.uber.okbuck.core.annotation.JvmPlugin;
import com.uber.okbuck.core.model.jvm.JvmTarget;
import java.util.Set;
import java.util.stream.Collectors;

public class JvmBuckRuleComposer
extends BuckRuleComposer {
    public static String src(JvmTarget target) {
        return "src_" + target.getName();
    }

    public static String bin(JvmTarget target) {
        return "bin_" + target.getName();
    }

    public static String test(JvmTarget target) {
        return "test_" + target.getName();
    }

    public static String integrationTest(JvmTarget target) {
        return "integration_test_" + target.getName();
    }

    public static Set<String> getApPlugins(Set<JvmPlugin> aps) {
        return aps.stream().map(JvmBuckRuleComposer::getApPluginRulePath).collect(Collectors.toSet());
    }

    protected static String getApPluginRuleName(JvmPlugin plugin) {
        return String.format("processor-%s", plugin.pluginUID());
    }

    private static String getApPluginRulePath(JvmPlugin plugin) {
        if (plugin.pluginDependency().isPresent()) {
            return String.format("//%s:%s", plugin.pluginDependency().get().getTargetPath(), JvmBuckRuleComposer.getApPluginRuleName(plugin));
        }
        return String.format("//.okbuck/workspace/processor:%s", JvmBuckRuleComposer.getApPluginRuleName(plugin));
    }
}

