/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.annotation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.uber.okbuck.composer.java.JavaAnnotationProcessorRuleComposer;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.manager.BuckFileManager;
import com.uber.okbuck.core.model.base.Scope;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

public class AnnotationProcessorCache {
    public static final String AUTO_VALUE_GROUP = "com.google.auto.value";
    public static final String AUTO_VALUE_NAME = "auto-value";
    private final Project project;
    private final BuckFileManager buckFileManager;
    private final String processorBuckFile;
    private final Map<Set<Dependency>, Scope> dependencyToScopeMap;
    @Nullable
    private Map<Set<Dependency>, Scope> autoValueDependencyToScopeMap;

    public AnnotationProcessorCache(Project project, BuckFileManager buckFileManager, String processorBuckFile) {
        this.project = project;
        this.buckFileManager = buckFileManager;
        this.processorBuckFile = processorBuckFile;
        this.dependencyToScopeMap = new ConcurrentHashMap<Set<Dependency>, Scope>();
    }

    private Map<Set<Dependency>, Scope> getAutoValueDependencyToScopeMap() {
        if (this.autoValueDependencyToScopeMap == null) {
            Project rootProject = this.project.getRootProject();
            ExternalDependenciesExtension extension = ProjectUtil.getExternalDependencyExtension(this.project);
            this.autoValueDependencyToScopeMap = this.createAutoValueProcessorScopes(rootProject, extension.getAutoValueConfigurations());
        }
        return this.autoValueDependencyToScopeMap;
    }

    public List<Scope> getAnnotationProcessorScopes(Project project, String configurationString) {
        Optional<Configuration> configuration = AnnotationProcessorCache.getConfiguration(project, configurationString);
        return configuration.isPresent() ? this.getAnnotationProcessorScopes(project, configuration.get()) : ImmutableList.of();
    }

    public List<Scope> getAnnotationProcessorScopes(Project project, Configuration configuration) {
        ImmutableList.Builder scopesBuilder = ImmutableList.builder();
        ImmutableMap<Dependency, Scope> singleDependencyToScope = this.createProcessorScopes(project, (Set<Dependency>)configuration.getAllDependencies());
        ImmutableSet<Dependency> autoValueDependencies = AnnotationProcessorCache.getAutoValueDependencies(singleDependencyToScope);
        if (autoValueDependencies.size() > 0) {
            Map<Set<Dependency>, Scope> autoValueScopeMap = this.getAutoValueDependencyToScopeMap();
            if (autoValueScopeMap.size() == 0) {
                throw new IllegalStateException("autoValueConfigurations should be present if adding autoValue dependencies. missing: " + autoValueDependencies);
            }
            if (!autoValueScopeMap.containsKey(autoValueDependencies)) {
                throw new IllegalStateException("autoValueConfigurations declared mismatch the autoValue dependencies. missing: " + autoValueDependencies + " found: " + autoValueScopeMap.keySet());
            }
            scopesBuilder.add((Object)autoValueScopeMap.get(autoValueDependencies));
            singleDependencyToScope.forEach((dependency, scope) -> {
                if (!autoValueDependencies.contains(dependency)) {
                    scopesBuilder.add(scope);
                }
            });
        } else {
            scopesBuilder.addAll(singleDependencyToScope.values());
        }
        return scopesBuilder.build();
    }

    private static ImmutableSet<Dependency> getAutoValueDependencies(Map<Dependency, Scope> dependencyToScope) {
        return (ImmutableSet)dependencyToScope.entrySet().stream().filter(entry -> AnnotationProcessorCache.isAutoValueScope((Scope)entry.getValue())).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isAutoValueScope(Scope scope) {
        return scope.getExternalDeps().stream().anyMatch(dependency -> {
            if (dependency.getGroup().equals(AUTO_VALUE_GROUP) || dependency.getName().startsWith(AUTO_VALUE_NAME)) {
                return true;
            }
            return scope.hasAutoValueExtensions();
        });
    }

    public boolean hasEmptyAnnotationProcessors(Project project, String configurationString) {
        Optional<Configuration> configuration = AnnotationProcessorCache.getConfiguration(project, configurationString);
        return configuration.map(config -> this.hasEmptyAnnotationProcessors(project, (Configuration)config)).orElse(false);
    }

    public boolean hasEmptyAnnotationProcessors(Project project, Configuration configuration) {
        ImmutableMap<Dependency, Scope> depToScope = this.createProcessorScopes(project, (Set<Dependency>)configuration.getAllDependencies());
        return depToScope.values().stream().anyMatch(scope -> scope.getAnnotationProcessors().isEmpty());
    }

    public Map<Path, List<Scope>> getBasePathToExternalDependencyScopeMap() {
        Path rootPath = this.project.getRootDir().toPath();
        return this.dependencyToScopeMap.values().stream().filter(it -> it.getAnnotationProcessorPlugin().pluginDependency().isPresent()).collect(Collectors.groupingBy(scope -> rootPath.resolve(scope.getAnnotationProcessorPlugin().pluginDependency().get().getTargetPath())));
    }

    public void finalizeProcessors() {
        List<Scope> targetScopes = this.dependencyToScopeMap.values().stream().filter(it -> !it.getAnnotationProcessorPlugin().pluginDependency().isPresent()).collect(Collectors.toList());
        this.buckFileManager.writeToBuckFile(JavaAnnotationProcessorRuleComposer.compose(targetScopes), this.project.getRootProject().file((Object)this.processorBuckFile));
    }

    private ImmutableMap<Dependency, Scope> createProcessorScopes(Project project, Set<Dependency> dependencies) {
        ImmutableMap.Builder currentBuilder = new ImmutableMap.Builder();
        Function<Set, Scope> computeScope = depSet -> {
            Dependency[] depArray = depSet.toArray(new Dependency[0]);
            Configuration detached = project.getConfigurations().detachedConfiguration(depArray);
            return Scope.builder(project).configuration(detached).build();
        };
        dependencies.forEach(dependency -> {
            ImmutableSet dependencySet = ImmutableSet.of((Object)dependency);
            Scope scope = this.dependencyToScopeMap.computeIfAbsent((Set<Dependency>)dependencySet, computeScope);
            currentBuilder.put(dependency, (Object)scope);
        });
        return currentBuilder.build();
    }

    private ImmutableMap<Set<Dependency>, Scope> createAutoValueProcessorScopes(Project project, Set<String> configurations) {
        ImmutableMap.Builder currentBuilder = new ImmutableMap.Builder();
        for (String configurationString : configurations) {
            Optional<Configuration> optionalConfiguration = AnnotationProcessorCache.getConfiguration(project, configurationString);
            if (!optionalConfiguration.isPresent() || optionalConfiguration.get().getAllDependencies().size() <= 0) continue;
            Configuration configuration = optionalConfiguration.get();
            ImmutableSet dependencySet = ImmutableSet.copyOf((Collection)configuration.getAllDependencies());
            Scope scope = this.dependencyToScopeMap.computeIfAbsent((Set<Dependency>)dependencySet, depSet -> Scope.builder(project).configuration(configuration).build());
            currentBuilder.put((Object)dependencySet, (Object)scope);
        }
        return currentBuilder.build();
    }

    private static Optional<Configuration> getConfiguration(Project project, String configurationString) {
        Configuration configuration = DependencyUtils.useful(configurationString, project);
        return Optional.ofNullable(configuration);
    }
}

