/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.dependency;

import com.google.common.base.Strings;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.dependency.LocalOExternalDependency;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.dependency.OResolvedDependency;
import com.uber.okbuck.core.dependency.VersionlessDependency;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.JetifierExtension;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;

public final class DependencyFactory {
    public static final String LOCAL_GROUP = "local";
    private static final String LOCAL_DEP_VERSION = "1.0.0-LOCAL";
    private final Map<ExternalDependency, Set<VersionlessDependency>> unresolvedToVersionless = new HashMap<ExternalDependency, Set<VersionlessDependency>>();
    private final Map<OResolvedDependency, OExternalDependency> externalDependencyCache = new HashMap<OResolvedDependency, OExternalDependency>();

    public synchronized OExternalDependency from(String group, String name, String version, File dependencyFile, @Nullable File dependencySourceFile, ExternalDependenciesExtension externalDependenciesExtension, JetifierExtension jetifierExtension) {
        String classifier = DependencyUtils.getModuleClassifier(dependencyFile.getName(), version);
        VersionlessDependency versionlessDependency = VersionlessDependency.builder().setGroup(group).setName(name).setClassifier(Optional.ofNullable(Strings.emptyToNull((String)classifier))).build();
        OResolvedDependency resolvedDependency = OResolvedDependency.builder().setVersionless(versionlessDependency).setVersion(version).setIsVersioned(externalDependenciesExtension.isVersioned(versionlessDependency)).setRealDependencyFile(dependencyFile).setRealDependencySourceFile(Optional.ofNullable(dependencySourceFile)).build();
        if (this.externalDependencyCache.containsKey(resolvedDependency)) {
            return this.externalDependencyCache.get(resolvedDependency);
        }
        OExternalDependency externalDependency = group.equals(LOCAL_GROUP) || DependencyFactory.isLocalDependency(dependencyFile.getAbsolutePath()) ? new LocalOExternalDependency(resolvedDependency, externalDependenciesExtension, jetifierExtension) : new OExternalDependency(resolvedDependency, externalDependenciesExtension, jetifierExtension);
        this.externalDependencyCache.put(resolvedDependency, externalDependency);
        return externalDependency;
    }

    public LocalOExternalDependency fromLocal(File localDependency, @Nullable File localSourceDependency, ExternalDependenciesExtension externalDependenciesExtension, JetifierExtension jetifierExtension) {
        String name = FilenameUtils.getBaseName((String)localDependency.getName());
        return (LocalOExternalDependency)this.from(LOCAL_GROUP, name, LOCAL_DEP_VERSION, localDependency, localSourceDependency, externalDependenciesExtension, jetifierExtension);
    }

    public synchronized Set<VersionlessDependency> fromDependency(ExternalDependency dependency) {
        if (this.unresolvedToVersionless.containsKey(dependency)) {
            return this.unresolvedToVersionless.get(dependency);
        }
        VersionlessDependency.Builder vDependencyBuilder = VersionlessDependency.builder().setName(dependency.getName());
        String group = dependency.getGroup();
        if (group == null) {
            vDependencyBuilder.setGroup(LOCAL_GROUP);
        } else {
            vDependencyBuilder.setGroup(group);
        }
        HashSet<VersionlessDependency> vDeps = new HashSet<VersionlessDependency>();
        if (dependency.getArtifacts().size() > 0) {
            vDeps.addAll(dependency.getArtifacts().stream().map(dependencyArtifact -> vDependencyBuilder.setClassifier(Optional.ofNullable(dependencyArtifact.getClassifier())).build()).collect(Collectors.toSet()));
        } else {
            vDeps.add(vDependencyBuilder.build());
        }
        this.unresolvedToVersionless.put(dependency, vDeps);
        return vDeps;
    }

    public static Set<VersionlessDependency> fromDependency(ResolvedDependency dependency) {
        Set selfArtifacts = dependency.getModuleArtifacts();
        return DependencyFactory.fromResolvedArtifacts(selfArtifacts);
    }

    public static Set<VersionlessDependency> childrenFromDependency(ResolvedDependency dependency) {
        Set<ResolvedArtifact> childArtifacts = dependency.getChildren().stream().map(child -> child.getParentArtifacts(dependency)).flatMap(Collection::stream).collect(Collectors.toSet());
        return DependencyFactory.fromResolvedArtifacts(childArtifacts);
    }

    private static Set<VersionlessDependency> fromResolvedArtifacts(Set<ResolvedArtifact> artifacts) {
        return artifacts.stream().map(resolvedArtifact -> {
            if (resolvedArtifact.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier id = (ModuleComponentIdentifier)resolvedArtifact.getId().getComponentIdentifier();
                return VersionlessDependency.builder().setName(id.getModule()).setGroup(id.getGroup()).setClassifier(Optional.ofNullable(resolvedArtifact.getClassifier())).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void finalizeDependencies() {
        this.unresolvedToVersionless.clear();
        this.externalDependencyCache.clear();
    }

    private static boolean isLocalDependency(String dependencyFilePath) {
        return dependencyFilePath.contains("-SNAPSHOT") || dependencyFilePath.contains("-LOCAL");
    }
}

