/*
 * Decompiled with CFR 0.152.
 */
package com.uber.okbuck.core.dependency;

import com.google.common.collect.ImmutableList;
import com.uber.okbuck.core.dependency.DependencyUtils;
import com.uber.okbuck.core.dependency.OExternalDependency;
import com.uber.okbuck.core.dependency.OResolvedDependency;
import com.uber.okbuck.core.util.ProjectUtil;
import com.uber.okbuck.extension.ExternalDependenciesExtension;
import com.uber.okbuck.extension.JetifierExtension;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public final class LocalOExternalDependency
extends OExternalDependency {
    @Nullable
    Path computeSourceFile(Project project) {
        if (!DependencyUtils.isWhiteListed(this.getRealDependencyFile()) && ImmutableList.of((Object)"jar", (Object)"aar").contains((Object)this.getPackaging())) {
            String sourceFileName = this.getSourceFileNameFrom(this.getRealDependencyFile().getName());
            Path sourcesJar = this.getRealDependencyFile().getParentFile().toPath().resolve(sourceFileName);
            if (Files.exists(sourcesJar, new LinkOption[0])) {
                return sourcesJar;
            }
        }
        return null;
    }

    @Override
    public Optional<File> getRealSourceFile() {
        Optional<File> optionalSourceFile = super.getRealSourceFile();
        if (!optionalSourceFile.isPresent() && ProjectUtil.canHaveSources(this.getRealDependencyFile())) {
            String sourceFileName = this.getSourceFileNameFrom(this.getRealDependencyFile().getName());
            Path sourcesJar = this.getRealDependencyFile().getParentFile().toPath().resolve(sourceFileName);
            if (Files.exists(sourcesJar, new LinkOption[0])) {
                return Optional.of(sourcesJar.toFile());
            }
        }
        return optionalSourceFile;
    }

    LocalOExternalDependency(OResolvedDependency resolvedDependency, ExternalDependenciesExtension externalDependenciesExtension, JetifierExtension jetifierExtension) {
        super(resolvedDependency, externalDependenciesExtension, jetifierExtension);
    }
}

